/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import java.util.UUID;

public class LifecycleSkill
extends BuiltinSkill
implements Lifecycle {
    private static int installationOrder = -1;
    @Inject
    private SpawnService spawnService;

    LifecycleSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = LifecycleSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    public UUID spawnInContext(Class<? extends Agent> agentType, AgentContext context, Object ... params) {
        return this.spawnService.spawn(context, null, agentType, params);
    }

    @Override
    public UUID spawnInContextWithID(Class<? extends Agent> agentClass, UUID agentID, AgentContext context, Object ... params) {
        return this.spawnService.spawn(context, agentID, agentClass, params);
    }

    @Override
    public void killMe() {
        InternalEventBusCapacity busCapacity = this.getSkill(InternalEventBusCapacity.class);
        busCapacity.selfEvent(new AsynchronousAgentKillingEvent());
        throw new ChuckNorrisException();
    }

    public static class AgentKillException
    extends RuntimeException {
        private static final long serialVersionUID = 3186824315988212481L;

        AgentKillException(SpawnService.AgentKillException exception) {
            super(exception.getMessage(), exception);
        }

        public UUID getAgent() {
            return ((SpawnService.AgentKillException)this.getCause()).getAgent();
        }
    }
}

