/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Queues;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.internaleventdispatching.AgentInternalEventsDispatcher;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.core.Initialize;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class InternalEventBusSkill
extends BuiltinSkill
implements InternalEventBusCapacity {
    private static int installationOrder = -1;
    private final AtomicReference<InternalEventBusCapacity.OwnerState> state = new AtomicReference<InternalEventBusCapacity.OwnerState>(InternalEventBusCapacity.OwnerState.NEW);
    private final AgentEventListener agentAsEventListener = new AgentEventListener();
    @Inject
    private AgentInternalEventsDispatcher eventDispatcher;
    @Inject
    private LogService logger;
    @Inject
    private SpawnService spawnService;
    private final Address agentAddressInInnerDefaultSpace;
    private List<Object> eventListeners;

    InternalEventBusSkill(Agent agent, Address addressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = addressInInnerDefaultSpace;
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = InternalEventBusSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", state = " + this.state + ", addressInDefaultspace = " + this.agentAddressInInnerDefaultSpace;
    }

    @Override
    public InternalEventBusCapacity.OwnerState getOwnerState() {
        return this.state.get();
    }

    @Override
    public Address getInnerDefaultSpaceAddress() {
        return this.agentAddressInInnerDefaultSpace;
    }

    @Override
    protected void install() {
        this.eventDispatcher.register(this.getOwner());
    }

    @Override
    protected void uninstall() {
        this.eventDispatcher.unregister(this.getOwner());
        List<Object> list = this.eventListeners;
        this.eventListeners = null;
        if (list != null) {
            for (Object o : list) {
                this.eventDispatcher.unregister(o);
            }
        }
    }

    @Override
    public void registerEventListener(Object listener) {
        this.eventDispatcher.register(listener);
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<Object>();
        }
        this.eventListeners.add(listener);
    }

    @Override
    public void unregisterEventListener(Object listener) {
        this.eventDispatcher.unregister(listener);
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
            if (this.eventListeners.isEmpty()) {
                this.eventListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selfEvent(Event event) {
        event.setSource(this.getInnerDefaultSpaceAddress());
        if (event instanceof Initialize) {
            try {
                this.eventDispatcher.immediateDispatch(event);
                this.state.set(InternalEventBusCapacity.OwnerState.RUNNING);
            }
            catch (Exception exception) {
                this.state.set(InternalEventBusCapacity.OwnerState.RUNNING);
                this.agentAsEventListener.killOrMarkAsKilled();
            }
        } else if (event instanceof Destroy) {
            AtomicReference<InternalEventBusCapacity.OwnerState> atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.set(InternalEventBusCapacity.OwnerState.DESTROYED);
            }
            this.eventDispatcher.immediateDispatch(event);
        } else if (event instanceof AsynchronousAgentKillingEvent) {
            this.agentAsEventListener.killOrMarkAsKilled();
        } else {
            this.agentAsEventListener.receiveEvent(event);
        }
        this.logger.debug("SELF_EVENT", event);
    }

    @Override
    public final EventListener asEventListener() {
        return this.agentAsEventListener;
    }

    private class AgentEventListener
    implements EventListener {
        private Queue<Event> buffer = Queues.newConcurrentLinkedQueue();
        private final UUID aid;
        private final AtomicBoolean isKilled = new AtomicBoolean(false);

        AgentEventListener() {
            this.aid = InternalEventBusSkill.this.getOwner().getID();
        }

        @Override
        public UUID getID() {
            return this.aid;
        }

        @Override
        public void receiveEvent(Event event) {
            assert (!(event instanceof Initialize || event instanceof Destroy || event instanceof AsynchronousAgentKillingEvent)) : "Unsupported type of event: " + event;
            if (event instanceof AgentSpawned && this.aid.equals(((AgentSpawned)event).agentID)) {
                this.fireEnqueuedEvents(InternalEventBusSkill.this);
                if (this.isKilled.get()) {
                    this.killOwner(InternalEventBusSkill.this);
                    return;
                }
            }
            switch ((InternalEventBusCapacity.OwnerState)((Object)InternalEventBusSkill.this.state.get())) {
                case NEW: {
                    this.buffer.add(event);
                    break;
                }
                case RUNNING: {
                    this.fireEnqueuedEvents(InternalEventBusSkill.this);
                    InternalEventBusSkill.this.eventDispatcher.asyncDispatch(event);
                    break;
                }
                case DESTROYED: {
                    InternalEventBusSkill.this.logger.debug(InternalEventBusSkill.class, "EVENT_DROP_WARNING", event);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private void fireEnqueuedEvents(InternalEventBusSkill skill) {
            Queue<Event> queue = this.buffer;
            if (queue != null && !queue.isEmpty()) {
                this.buffer = null;
                for (Event evt : queue) {
                    skill.eventDispatcher.asyncDispatch(evt);
                }
            }
        }

        private void killOwner(InternalEventBusSkill skill) {
            try {
                skill.spawnService.killAgent(this.aid);
            }
            catch (SpawnService.AgentKillException e) {
                skill.logger.error(InternalEventBusSkill.class, "CANNOT_KILL_AGENT", this.aid, e);
            }
        }

        void killOrMarkAsKilled() {
            this.isKilled.set(true);
            if (InternalEventBusSkill.this.state.get() != InternalEventBusCapacity.OwnerState.NEW) {
                this.killOwner(InternalEventBusSkill.this);
            }
        }
    }
}

