/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.Behaviors;
import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.Collections3;
import io.sarl.util.OpenEventSpace;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.arakhne.afc.vmutil.locale.Locale;

public class ExternalContextAccessSkill
extends BuiltinSkill
implements ExternalContextAccess {
    private static int installationOrder = -1;
    private final Set<UUID> contexts = Sets.newConcurrentHashSet();
    @Inject
    private ContextSpaceService contextRepository;

    ExternalContextAccessSkill(Agent agent) {
        super(agent);
    }

    @Override
    public int getInstallationOrder() {
        if (installationOrder < 0) {
            installationOrder = ExternalContextAccessSkill.installationOrder(this);
        }
        return installationOrder;
    }

    @Override
    protected String attributesToString() {
        return String.valueOf(super.attributesToString()) + ", contexts = " + this.contextRepository.toString();
    }

    @Override
    protected void install() {
        AgentContext ac = this.contextRepository.getContext(this.getOwner().getParentID());
        this.join(ac.getID(), ac.getDefaultSpace().getSpaceID().getID());
    }

    @Override
    protected void uninstall() {
        for (UUID contextID : this.contexts) {
            this.leave(contextID);
        }
    }

    @Override
    public SynchronizedCollection<AgentContext> getAllContexts() {
        return Collections3.synchronizedCollection(Collections.unmodifiableCollection(this.contextRepository.getContexts(this.contexts)), this.contextRepository.mutex());
    }

    @Override
    public AgentContext getContext(UUID contextID) {
        assert (contextID != null);
        if (!this.contexts.contains(contextID)) {
            throw new IllegalArgumentException(Locale.getString(ExternalContextAccessSkill.class, "UNKNOWN_CONTEXT_ID", contextID));
        }
        return this.contextRepository.getContext(contextID);
    }

    @Override
    public void join(UUID futureContext, UUID futureContextDefaultSpaceID) {
        assert (futureContext != null);
        assert (futureContextDefaultSpaceID != null);
        if (this.contexts.contains(futureContext)) {
            return;
        }
        AgentContext ac = this.contextRepository.getContext(futureContext);
        assert (ac != null) : "Unknown Context";
        if (!futureContextDefaultSpaceID.equals(ac.getDefaultSpace().getSpaceID().getID())) {
            throw new IllegalArgumentException(Locale.getString(ExternalContextAccessSkill.class, "INVALID_DEFAULT_SPACE_MATCHING", futureContextDefaultSpaceID));
        }
        this.contexts.add(futureContext);
        ((OpenEventSpace)ac.getDefaultSpace()).register(this.getSkill(InternalEventBusCapacity.class).asEventListener());
        this.fireContextJoined(futureContext, futureContextDefaultSpaceID);
        this.fireMemberJoined(ac);
    }

    protected void fireContextJoined(UUID futureContext, UUID futureContextDefaultSpaceID) {
        this.getSkill(Behaviors.class).wake(new ContextJoined(futureContext, futureContextDefaultSpaceID));
    }

    protected void fireMemberJoined(AgentContext newJoinedContext) {
        EventSpace defSpace = newJoinedContext.getDefaultSpace();
        defSpace.emit(new MemberJoined(defSpace.getAddress(this.getOwner().getID()), newJoinedContext.getID(), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    @Override
    public void leave(UUID contextID) {
        assert (contextID != null);
        AgentContext ac = this.contextRepository.getContext(contextID);
        assert (ac != null) : "Unknown Context";
        if (!this.contexts.contains(contextID)) {
            return;
        }
        this.fireContextLeft(contextID);
        this.fireMemberLeft(ac);
        ((OpenEventSpace)ac.getDefaultSpace()).unregister(this.getSkill(InternalEventBusCapacity.class).asEventListener());
        this.contexts.remove(contextID);
    }

    protected void fireContextLeft(UUID contextID) {
        this.getSkill(Behaviors.class).wake(new ContextLeft(contextID));
    }

    protected void fireMemberLeft(AgentContext leftContext) {
        EventSpace defSpace = leftContext.getDefaultSpace();
        defSpace.emit(new MemberLeft(defSpace.getAddress(this.getOwner().getID()), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    @Override
    public boolean isInSpace(Event event, Space space) {
        return this.isInSpace(event, space.getSpaceID());
    }

    @Override
    public boolean isInSpace(Event event, SpaceID spaceID) {
        return spaceID.equals(event.getSource().getSpaceId());
    }

    @Override
    public boolean isInSpace(Event event, UUID spaceID) {
        return spaceID.equals(event.getSource().getSpaceId().getID());
    }
}

