/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.janusproject.kernel.bic.BuiltinSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.sarl.core.Destroy;
import io.sarl.core.Initialize;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Skill;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.arakhne.afc.util.ListUtil;
import org.arakhne.afc.util.MultiCollection;

class AgentLifeCycleSupport
implements SpawnServiceListener {
    private static final Comparator<BuiltinSkill> ORDER_COMPARATOR = new OrderComparator();
    private static final Comparator<BuiltinSkill> REVERSE_ORDER_COMPARATOR = new ReverseOrderComparator();
    private static Method skillInstallationMethod;
    private static Method skillUninstallationMethod;
    private static Field agentSkillField;
    private final UUID agentID;
    private final WeakReference<SpawnService> spawnService;
    private final InternalEventBusCapacity eventBusCapacity;

    AgentLifeCycleSupport(UUID agentID, SpawnService spawnService, InternalEventBusCapacity eventBusCapacity) {
        this.agentID = agentID;
        this.spawnService = new WeakReference<SpawnService>(spawnService);
        this.eventBusCapacity = eventBusCapacity;
    }

    @Override
    public void agentSpawned(AgentContext parent, Agent agent, Object[] initializationParameters) {
        AgentLifeCycleSupport.installSkills(agent);
        Initialize init = new Initialize();
        init.parameters = initializationParameters;
        this.eventBusCapacity.selfEvent(init);
    }

    @Override
    public void agentDestroy(Agent agent) {
        SpawnService service = (SpawnService)this.spawnService.get();
        assert (service != null);
        service.removeSpawnServiceListener(this.agentID, this);
        Destroy destroy = new Destroy();
        this.eventBusCapacity.selfEvent(destroy);
        AgentLifeCycleSupport.uninstallSkills(agent);
    }

    private static Iterable<? extends Skill> getAllSkills(Agent agent, boolean inReverseOrder) {
        try {
            Map skills;
            if (agentSkillField == null) {
                Field field = Agent.class.getDeclaredField("skills");
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                agentSkillField = field;
            }
            if ((skills = (Map)agentSkillField.get(agent)) != null) {
                ArrayList builtinSkills = new ArrayList();
                TreeSet<Skill> otherSkills = new TreeSet<Skill>((first, second) -> {
                    if (first == second) {
                        return 0;
                    }
                    return Integer.compare(System.identityHashCode(first), System.identityHashCode(second));
                });
                Comparator<BuiltinSkill> comparator = inReverseOrder ? REVERSE_ORDER_COMPARATOR : ORDER_COMPARATOR;
                for (Skill skill : skills.values()) {
                    if (skill instanceof BuiltinSkill) {
                        ListUtil.add(builtinSkills, comparator, (BuiltinSkill)skill, true, false);
                        continue;
                    }
                    otherSkills.add(skill);
                }
                if (otherSkills.isEmpty()) {
                    return builtinSkills;
                }
                MultiCollection<Skill> allSkills = new MultiCollection<Skill>();
                if (inReverseOrder) {
                    allSkills.addCollection(otherSkills);
                    allSkills.addCollection(builtinSkills);
                } else {
                    allSkills.addCollection(builtinSkills);
                    allSkills.addCollection(otherSkills);
                }
                return allSkills;
            }
            return Collections.emptyList();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void installSkills(Agent agent) {
        try {
            if (skillInstallationMethod == null) {
                Method method = Skill.class.getDeclaredMethod("install", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                skillInstallationMethod = method;
            }
            for (Skill skill : AgentLifeCycleSupport.getAllSkills(agent, false)) {
                skillInstallationMethod.invoke((Object)skill, new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void uninstallSkills(Agent agent) {
        try {
            if (skillUninstallationMethod == null) {
                Method method = Skill.class.getDeclaredMethod("uninstall", new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                skillUninstallationMethod = method;
            }
            for (Skill skill : AgentLifeCycleSupport.getAllSkills(agent, true)) {
                skillUninstallationMethod.invoke((Object)skill, new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class OrderComparator
    implements Comparator<BuiltinSkill> {
        OrderComparator() {
        }

        @Override
        public int compare(BuiltinSkill outsideElement, BuiltinSkill insideElement) {
            return Integer.compare(outsideElement.getInstallationOrder(), insideElement.getInstallationOrder());
        }
    }

    private static class ReverseOrderComparator
    implements Comparator<BuiltinSkill> {
        ReverseOrderComparator() {
        }

        @Override
        public int compare(BuiltinSkill outsideElement, BuiltinSkill insideElement) {
            return Integer.compare(insideElement.getInstallationOrder(), outsideElement.getInstallationOrder());
        }
    }
}

