/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.eclipse.sre;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.GenericXMLWriter;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JavaClasspathParser {
    private JavaClasspathParser() {
    }

    public static IClasspathEntry[][] readFileEntriesWithException(String projectName, URL projectRootAbsoluteFullPath) throws CoreException, IOException, ClasspathEntry.AssertionFailedException, URISyntaxException {
        return JavaClasspathParser.readFileEntriesWithException(projectName, projectRootAbsoluteFullPath, null);
    }

    public static IClasspathEntry[][] readFileEntriesWithException(String projectName, URL projectRootAbsoluteFullPath, Map<IPath, UnknownXmlElements> unknownElements) throws CoreException, IOException, ClasspathEntry.AssertionFailedException, URISyntaxException {
        String xmlClasspath;
        URL rscFile = new URL(projectRootAbsoluteFullPath.toExternalForm().concat(".classpath"));
        URI location = rscFile.toURI();
        if (location == null) {
            throw new IOException("Cannot obtain a location URI for " + rscFile);
        }
        File file = Util.toLocalFile((URI)location, null);
        if (file == null) {
            throw new IOException("Unable to fetch file from " + location);
        }
        byte[] bytes = org.eclipse.jdt.internal.compiler.util.Util.getFileByteContent((File)file);
        if (JavaClasspathParser.hasUTF8BOM(bytes)) {
            int length = bytes.length - IContentDescription.BOM_UTF_8.length;
            byte[] byArray = bytes;
            bytes = new byte[length];
            System.arraycopy(byArray, IContentDescription.BOM_UTF_8.length, bytes, 0, length);
        }
        try {
            xmlClasspath = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log((Throwable)e, (String)"Could not read .classpath with UTF-8 encoding");
            xmlClasspath = new String(bytes);
        }
        return JavaClasspathParser.decodeClasspath(projectName, Path.fromPortableString((String)projectRootAbsoluteFullPath.getPath()), xmlClasspath, unknownElements);
    }

    private static boolean hasUTF8BOM(byte[] bytes) {
        if (bytes.length > IContentDescription.BOM_UTF_8.length) {
            int i = 0;
            int length = IContentDescription.BOM_UTF_8.length;
            while (i < length) {
                if (IContentDescription.BOM_UTF_8[i] != bytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static IClasspathEntry[][] decodeClasspath(String projectName, IPath projectRootAbsoluteFullPath, String xmlClasspath, Map<IPath, UnknownXmlElements> unknownElements) throws IOException, ClasspathEntry.AssertionFailedException {
        Element cpElement;
        ArrayList<IClasspathEntry> paths = new ArrayList<IClasspathEntry>();
        IClasspathEntry defaultOutput = null;
        try {
            Throwable throwable = null;
            Object var8_8 = null;
            try (StringReader reader = new StringReader(xmlClasspath);){
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(Messages.file_badFormat);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(Messages.file_badFormat);
        }
        if (!cpElement.getNodeName().equalsIgnoreCase("classpath")) {
            throw new IOException(Messages.file_badFormat);
        }
        NodeList list = cpElement.getElementsByTagName("classpathentry");
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            IClasspathEntry entry;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (entry = JavaClasspathParser.elementDecode((Element)node, projectName, projectRootAbsoluteFullPath, unknownElements)) != null) {
                if (entry.getContentKind() == 10) {
                    defaultOutput = entry;
                } else {
                    paths.add(entry);
                }
            }
            ++i;
        }
        int pathSize = paths.size();
        IClasspathEntry[][] entries = new IClasspathEntry[2][];
        entries[0] = new IClasspathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
        paths.toArray(entries[0]);
        if (defaultOutput != null) {
            entries[0][pathSize] = defaultOutput;
        }
        paths.clear();
        list = cpElement.getElementsByTagName("referencedentry");
        length = list.getLength();
        int i2 = 0;
        while (i2 < length) {
            IClasspathEntry entry;
            Node node = list.item(i2);
            if (node.getNodeType() == 1 && (entry = JavaClasspathParser.elementDecode((Element)node, projectName, projectRootAbsoluteFullPath, unknownElements)) != null) {
                paths.add(entry);
            }
            ++i2;
        }
        entries[1] = new IClasspathEntry[paths.size()];
        paths.toArray(entries[1]);
        return entries;
    }

    public static IClasspathEntry elementDecode(Element element, String projectName, IPath projectRootAbsoluteFullPath, Map<IPath, UnknownXmlElements> unknownElements) {
        NodeList attributeList;
        IAccessRule[] accessRules;
        IPath[] exclusionPatterns;
        Path sourceAttachmentPath;
        IPath projectPath = projectRootAbsoluteFullPath;
        NamedNodeMap attributes = element.getAttributes();
        NodeList children = element.getChildNodes();
        boolean[] foundChildren = new boolean[children.getLength()];
        String kindAttr = JavaClasspathParser.removeAttribute("kind", attributes);
        String pathAttr = JavaClasspathParser.removeAttribute("path", attributes);
        Path path = new Path(pathAttr);
        int kind = JavaClasspathParser.kindFromString(kindAttr);
        if (!(kind == 4 || kind == 5 || path.isAbsolute() || path.segmentCount() > 0 && path.segment(0).equals(".."))) {
            path = projectPath.append((IPath)path);
        }
        Path path2 = sourceAttachmentPath = element.hasAttribute("sourcepath") ? new Path(JavaClasspathParser.removeAttribute("sourcepath", attributes)) : null;
        if (kind != 4 && sourceAttachmentPath != null && !sourceAttachmentPath.isAbsolute()) {
            sourceAttachmentPath = projectPath.append((IPath)sourceAttachmentPath);
        }
        Path sourceAttachmentRootPath = element.hasAttribute("rootpath") ? new Path(JavaClasspathParser.removeAttribute("rootpath", attributes)) : null;
        boolean isExported = JavaClasspathParser.removeAttribute("exported", attributes).equals("true");
        IPath[] inclusionPatterns = JavaClasspathParser.decodePatterns(attributes, "including");
        if (inclusionPatterns == null) {
            inclusionPatterns = ClasspathEntry.INCLUDE_ALL;
        }
        if ((exclusionPatterns = JavaClasspathParser.decodePatterns(attributes, "excluding")) == null) {
            exclusionPatterns = ClasspathEntry.EXCLUDE_NONE;
        }
        if ((accessRules = JavaClasspathParser.decodeAccessRules(attributeList = JavaClasspathParser.getChildAttributes("accessrules", children, foundChildren))) == null) {
            accessRules = JavaClasspathParser.getAccessRules(inclusionPatterns, exclusionPatterns);
        }
        boolean combineAccessRestrictions = !JavaClasspathParser.removeAttribute("combineaccessrules", attributes).equals("false");
        attributeList = JavaClasspathParser.getChildAttributes("attributes", children, foundChildren);
        IClasspathAttribute[] extraAttributes = JavaClasspathParser.decodeExtraAttributes(attributeList);
        IPath outputLocation = element.hasAttribute("output") ? projectPath.append(JavaClasspathParser.removeAttribute("output", attributes)) : null;
        String[] unknownAttributes = null;
        ArrayList<String> unknownChildren = null;
        if (unknownElements != null) {
            int i;
            int unknownAttributeLength = attributes.getLength();
            if (unknownAttributeLength != 0) {
                unknownAttributes = new String[unknownAttributeLength * 2];
                i = 0;
                while (i < unknownAttributeLength) {
                    Node attribute = attributes.item(i);
                    unknownAttributes[i * 2] = attribute.getNodeName();
                    unknownAttributes[i * 2 + 1] = attribute.getNodeValue();
                    ++i;
                }
            }
            i = 0;
            int length = foundChildren.length;
            while (i < length) {
                Node node;
                if (!foundChildren[i] && (node = children.item(i)).getNodeType() == 1) {
                    if (unknownChildren == null) {
                        unknownChildren = new ArrayList<String>();
                    }
                    StringBuffer buffer = new StringBuffer();
                    JavaClasspathParser.decodeUnknownNode(node, buffer);
                    unknownChildren.add(buffer.toString());
                }
                ++i;
            }
        }
        IClasspathEntry entry = null;
        switch (kind) {
            case 2: {
                entry = new ClasspathEntry(1, 2, (IPath)path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, isExported, accessRules, combineAccessRestrictions, extraAttributes);
                break;
            }
            case 1: {
                entry = JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IAccessRule[])accessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
                break;
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(projectName)) {
                    entry = JavaCore.newSourceEntry((IPath)path, (IPath[])inclusionPatterns, (IPath[])exclusionPatterns, (IPath)outputLocation, (IClasspathAttribute[])extraAttributes);
                    break;
                }
                if (path.segmentCount() == 1) {
                    entry = JavaCore.newProjectEntry((IPath)path, (IAccessRule[])accessRules, (boolean)combineAccessRestrictions, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
                    break;
                }
                entry = JavaCore.newSourceEntry((IPath)path, (IPath[])inclusionPatterns, (IPath[])exclusionPatterns, (IPath)outputLocation, (IClasspathAttribute[])extraAttributes);
                break;
            }
            case 4: {
                entry = JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IAccessRule[])accessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
                break;
            }
            case 5: {
                entry = JavaCore.newContainerEntry((IPath)path, (IAccessRule[])accessRules, (IClasspathAttribute[])extraAttributes, (boolean)isExported);
                break;
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                entry = new ClasspathEntry(10, 1, (IPath)path, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, false, null, false, ClasspathEntry.NO_EXTRA_ATTRIBUTES);
                break;
            }
            default: {
                throw new ClasspathEntry.AssertionFailedException(Messages.bind((String)Messages.classpath_unknownKind, (Object)kindAttr));
            }
        }
        if (unknownAttributes != null || unknownChildren != null) {
            UnknownXmlElements unknownXmlElements = new UnknownXmlElements();
            unknownXmlElements.attributes = unknownAttributes;
            unknownXmlElements.children = unknownChildren;
            if (unknownElements != null) {
                unknownElements.put((IPath)path, unknownXmlElements);
            }
        }
        return entry;
    }

    private static NodeList getChildAttributes(String childName, NodeList children, boolean[] foundChildren) {
        int i = 0;
        int length = foundChildren.length;
        while (i < length) {
            Node node = children.item(i);
            if (childName.equals(node.getNodeName())) {
                foundChildren[i] = true;
                return node.getChildNodes();
            }
            ++i;
        }
        return null;
    }

    private static String removeAttribute(String nodeName, NamedNodeMap nodeMap) {
        Node node = JavaClasspathParser.removeNode(nodeName, nodeMap);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    private static Node removeNode(String nodeName, NamedNodeMap nodeMap) {
        try {
            return nodeMap.removeNamedItem(nodeName);
        }
        catch (DOMException e) {
            if (e.code != 8) {
                throw e;
            }
            return null;
        }
    }

    private static IPath[] decodePatterns(NamedNodeMap nodeMap, String tag) {
        char[][] patterns;
        int patternCount;
        String sequence = JavaClasspathParser.removeAttribute(tag, nodeMap);
        if (!"".equals(sequence) && (patternCount = (patterns = CharOperation.splitOn((char)'|', (char[])sequence.toCharArray())).length) > 0) {
            IPath[] paths = new IPath[patternCount];
            int index = 0;
            int j = 0;
            while (j < patternCount) {
                char[] pattern = patterns[j];
                if (pattern.length != 0) {
                    paths[index++] = new Path(new String(pattern));
                }
                ++j;
            }
            if (index < patternCount) {
                IPath[] iPathArray = paths;
                paths = new IPath[index];
                System.arraycopy(iPathArray, 0, paths, 0, index);
            }
            return paths;
        }
        return null;
    }

    private static IAccessRule[] decodeAccessRules(NodeList list) {
        if (list == null) {
            return null;
        }
        int length = list.getLength();
        if (length == 0) {
            return null;
        }
        IAccessRule[] result = new IAccessRule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            block7: {
                int kind;
                Element elementAccessRule;
                String pattern;
                block9: {
                    String tagKind;
                    block10: {
                        block8: {
                            Node accessRule = list.item(i);
                            if (accessRule.getNodeType() != 1 || (pattern = (elementAccessRule = (Element)accessRule).getAttribute("pattern")) == null) break block7;
                            tagKind = elementAccessRule.getAttribute("kind");
                            if (!"accessible".equals(tagKind)) break block8;
                            kind = 0;
                            break block9;
                        }
                        if (!"nonaccessible".equals(tagKind)) break block10;
                        kind = 1;
                        break block9;
                    }
                    if (!"discouraged".equals(tagKind)) break block7;
                    kind = 2;
                }
                boolean ignoreIfBetter = "true".equals(elementAccessRule.getAttribute("ignoreifbetter"));
                result[index++] = new ClasspathAccessRule((IPath)new Path(pattern), ignoreIfBetter ? kind | 0x100 : kind);
            }
            ++i;
        }
        if (index != length) {
            IAccessRule[] iAccessRuleArray = result;
            result = new IAccessRule[index];
            System.arraycopy(iAccessRuleArray, 0, result, 0, index);
        }
        return result;
    }

    private static IClasspathAttribute[] decodeExtraAttributes(NodeList attributes) {
        if (attributes == null) {
            return ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        int length = attributes.getLength();
        if (length == 0) {
            return ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        }
        IClasspathAttribute[] result = new IClasspathAttribute[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            String value;
            Element attribute;
            String name;
            Node node = attributes.item(i);
            if (node.getNodeType() == 1 && (name = (attribute = (Element)node).getAttribute("name")) != null && (value = attribute.getAttribute("value")) != null) {
                result[index++] = new ClasspathAttribute(name, value);
            }
            ++i;
        }
        if (index != length) {
            IClasspathAttribute[] iClasspathAttributeArray = result;
            result = new IClasspathAttribute[index];
            System.arraycopy(iClasspathAttributeArray, 0, result, 0, index);
        }
        return result;
    }

    private static void decodeUnknownNode(Node node, StringBuffer buffer) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            Throwable throwable = null;
            Object var5_6 = null;
            try (GenericXMLWriter xmlWriter = new GenericXMLWriter((Writer)writer, System.getProperty("line.separator"), false);){
                JavaClasspathParser.decodeUnknownNode(node, xmlWriter, true);
                xmlWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            buffer.append(s.toString("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static void decodeUnknownNode(Node node, GenericXMLWriter xmlWriter, boolean insertNewLine) {
        switch (node.getNodeType()) {
            case 1: {
                int length;
                HashMap<String, String> parameters = null;
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null && (length = attributes.getLength()) > 0) {
                    parameters = new HashMap<String, String>();
                    int i = 0;
                    while (i < length) {
                        Node attribute = attributes.item(i);
                        parameters.put(attribute.getNodeName(), attribute.getNodeValue());
                        ++i;
                    }
                }
                NodeList children = node.getChildNodes();
                int childrenLength = children.getLength();
                String nodeName = node.getNodeName();
                xmlWriter.printTag(nodeName, parameters, false, false, childrenLength == 0);
                if (childrenLength <= 0) break;
                int i = 0;
                while (i < childrenLength) {
                    JavaClasspathParser.decodeUnknownNode(children.item(i), xmlWriter, false);
                    ++i;
                }
                xmlWriter.endTag(nodeName, false, insertNewLine);
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                xmlWriter.printString(data, false, false);
                break;
            }
        }
    }

    private static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("output")) {
            return 10;
        }
        return -1;
    }

    private static IAccessRule[] getAccessRules(IPath[] accessibleFiles, IPath[] nonAccessibleFiles) {
        int i;
        int nonAccessibleFilesLength;
        int accessibleFilesLength = accessibleFiles == null ? 0 : accessibleFiles.length;
        int length = accessibleFilesLength + (nonAccessibleFilesLength = nonAccessibleFiles == null ? 0 : nonAccessibleFiles.length);
        if (length == 0) {
            return null;
        }
        IAccessRule[] accessRules = new IAccessRule[length];
        if (accessibleFiles != null) {
            i = 0;
            while (i < accessibleFilesLength) {
                accessRules[i] = JavaCore.newAccessRule((IPath)accessibleFiles[i], (int)0);
                ++i;
            }
        }
        if (nonAccessibleFiles != null) {
            i = 0;
            while (i < nonAccessibleFilesLength) {
                accessRules[accessibleFilesLength + i] = JavaCore.newAccessRule((IPath)nonAccessibleFiles[i], (int)1);
                ++i;
            }
        }
        return accessRules;
    }

    static class UnknownXmlElements {
        String[] attributes;
        List<String> children;

        UnknownXmlElements() {
        }
    }
}

