/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.eclipse.sre;

import com.google.common.collect.Maps;
import io.janusproject.Boot;
import io.janusproject.eclipse.buildpath.JanusClasspathContainer;
import io.janusproject.eclipse.sre.JavaClasspathParser;
import io.sarl.eclipse.SARLEclipsePlugin;
import io.sarl.eclipse.runtime.AbstractSREInstall;
import io.sarl.eclipse.util.BundleUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JanusSREInstall
extends AbstractSREInstall {
    public static final String JANUS_SRE_ID = "io.janusproject.plugin.sre";
    private static final String ROOT_NAME = "/";
    private static final String JAR_EXTENSION = "jar";
    private static final String DOT_JAR_EXTENSION = ".jar";
    private static final String DEFAULT_PATH_TO_CLASSES_IN_MAVEN_PROJECT = "target/classes";
    private static Set<String> janusBundleDependencies;
    private IPath janusSREInstallPath;
    private Map<Bundle, Pair<Version, List<IRuntimeClasspathEntry>>> dependencies = new TreeMap<Bundle, Pair<Version, List<IRuntimeClasspathEntry>>>(new Comparator<Bundle>(){

        @Override
        public int compare(Bundle o1, Bundle o2) {
            return o1.getSymbolicName().compareTo(o2.getSymbolicName());
        }
    });
    private String location;

    public JanusSREInstall() {
        super(JANUS_SRE_ID);
        Bundle bundle = Platform.getBundle((String)"io.janusproject.plugin");
        IPath bundlePath = BundleUtil.getBundlePath((Bundle)bundle);
        if (bundlePath.toFile().isDirectory()) {
            IPath bundleSourcePath = BundleUtil.getSourceBundlePath((Bundle)bundle, (IPath)bundlePath);
            this.janusSREInstallPath = Path.fromPortableString((String)bundleSourcePath.toPortableString().concat(DEFAULT_PATH_TO_CLASSES_IN_MAVEN_PROJECT));
            URL janusBundleURL = null;
            try {
                janusBundleURL = new URL("file://" + bundleSourcePath.toPortableString());
            }
            catch (MalformedURLException e) {
                SARLEclipsePlugin.getDefault().log((Throwable)e);
                return;
            }
            this.janusSREInstallPath = this.readDotClasspathAndReferencestoClasspath(bundle, janusBundleURL);
        } else {
            this.janusSREInstallPath = bundlePath;
            IClasspathEntry cpEntry = JanusSREInstall.newLibraryEntry(bundle, bundlePath);
            ArrayList<IRuntimeClasspathEntry> cpEntries = new ArrayList<IRuntimeClasspathEntry>();
            JanusSREInstall.addToRuntimeClassPath(bundle, cpEntry, cpEntries);
            this.dependencies.put(bundle, new Pair<Version, ArrayList<IRuntimeClasspathEntry>>(bundle.getVersion(), cpEntries));
        }
        this.location = this.janusSREInstallPath.toPortableString();
        this.setName("Janus SRE");
        this.getAllBundleDependencies(bundle, true);
        ArrayList classpathEntries = new ArrayList();
        for (Pair<Version, List<IRuntimeClasspathEntry>> cpe : this.dependencies.values()) {
            classpathEntries.addAll(cpe.getValue());
        }
        this.setMainClass(Boot.class.getName());
        this.setClassPathEntries(new ArrayList(classpathEntries));
    }

    private static IClasspathEntry newLibraryEntry(Bundle bundle, IPath precomputedBundlePath) {
        assert (bundle != null);
        IPath path = precomputedBundlePath == null ? BundleUtil.getBundlePath((Bundle)bundle) : precomputedBundlePath;
        IPath sourcePath = BundleUtil.getSourceBundlePath((Bundle)bundle, (IPath)path);
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourcePath, null);
    }

    private static void addToRuntimeClassPath(Bundle bundle, IClasspathEntry entry, Collection<IRuntimeClasspathEntry> entries) {
        assert (bundle != null);
        assert (entry != null);
        entries.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(entry));
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments != null && fragments.length > 0) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                IClasspathEntry fragmentEntry = JanusSREInstall.newLibraryEntry(fragment, null);
                entries.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(fragmentEntry));
                ++n2;
            }
        }
    }

    private static Set<String> getJanusBundleDependencies() {
        if (janusBundleDependencies == null) {
            JanusClasspathContainer container = new JanusClasspathContainer(null);
            janusBundleDependencies = container.getBundleDependencies();
        }
        return janusBundleDependencies;
    }

    private void getAllBundleDependencies(Bundle bundle, boolean firstcall) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List bundleWires = bundleWiring.getRequiredWires(null);
        if (bundleWires != null) {
            Bundle dependency = null;
            for (BundleWire wire : bundleWires) {
                ArrayList<Object> cpEntries;
                IClasspathEntry cpEntry;
                URL u;
                dependency = wire.getProviderWiring().getBundle();
                String dependencyInstallationPath = dependency.getLocation();
                Pair<Version, List<IRuntimeClasspathEntry>> existingDependencyCPE = this.dependencies.get(dependency);
                if (existingDependencyCPE != null && dependency.getVersion().compareTo(existingDependencyCPE.getKey()) <= 0) continue;
                if (firstcall) {
                    if (!JanusSREInstall.getJanusBundleDependencies().contains(dependency.getSymbolicName())) continue;
                    u = null;
                    try {
                        u = FileLocator.resolve((URL)dependency.getEntry(ROOT_NAME));
                    }
                    catch (IOException e) {
                        SARLEclipsePlugin.getDefault().log((Throwable)e);
                        return;
                    }
                    if (dependencyInstallationPath.contains(JAR_EXTENSION) || u.getProtocol().equals(JAR_EXTENSION)) {
                        cpEntry = JanusSREInstall.newLibraryEntry(dependency, null);
                        cpEntries = new ArrayList();
                        JanusSREInstall.addToRuntimeClassPath(bundle, cpEntry, cpEntries);
                        this.dependencies.put(dependency, new Pair<Version, ArrayList<IRuntimeClasspathEntry>>(dependency.getVersion(), cpEntries));
                    } else {
                        this.readDotClasspathAndReferencestoClasspath(dependency, u);
                    }
                    this.getAllBundleDependencies(dependency, false);
                    continue;
                }
                u = null;
                try {
                    u = FileLocator.resolve((URL)dependency.getEntry(ROOT_NAME));
                }
                catch (IOException e) {
                    SARLEclipsePlugin.getDefault().log((Throwable)e);
                    return;
                }
                if (dependencyInstallationPath.contains(JAR_EXTENSION) || u.getProtocol().equals(JAR_EXTENSION)) {
                    cpEntry = JanusSREInstall.newLibraryEntry(dependency, null);
                    cpEntries = new ArrayList<IRuntimeClasspathEntry>();
                    JanusSREInstall.addToRuntimeClassPath(bundle, cpEntry, cpEntries);
                    this.dependencies.put(dependency, new Pair<Version, ArrayList<IRuntimeClasspathEntry>>(dependency.getVersion(), cpEntries));
                } else {
                    this.readDotClasspathAndReferencestoClasspath(dependency, u);
                }
                this.getAllBundleDependencies(dependency, false);
            }
        }
    }

    private IPath readDotClasspathAndReferencestoClasspath(Bundle bundle, URL bundleInstallURL) {
        IPath outputLocation = null;
        ArrayList<IRuntimeClasspathEntry> cpEntries = new ArrayList<IRuntimeClasspathEntry>();
        Enumeration entries = bundle.getEntryPaths(ROOT_NAME);
        String entry = null;
        while (entries.hasMoreElements()) {
            entry = (String)entries.nextElement();
            if (entry.contains(".classpath")) {
                try {
                    IClasspathEntry otherEntries;
                    IClasspathEntry outputLocationEntry;
                    IClasspathEntry[][] classpath = JavaClasspathParser.readFileEntriesWithException(bundle.getSymbolicName(), bundleInstallURL);
                    if (classpath[0].length > 0 && (outputLocationEntry = classpath[0][classpath[0].length - 1]).getContentKind() == 10) {
                        outputLocation = outputLocationEntry.getPath();
                        cpEntries.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(outputLocationEntry));
                    }
                    IClasspathEntry[] rawClassapth = null;
                    if (classpath[0].length <= 0 || (otherEntries = classpath[0][classpath[0].length - 1]).getContentKind() != 10) continue;
                    IClasspathEntry[] copy = new IClasspathEntry[classpath[0].length - 1];
                    System.arraycopy(classpath[0], 0, copy, 0, copy.length);
                    rawClassapth = copy;
                    IClasspathEntry cpentry = null;
                    int i = 0;
                    while (i < rawClassapth.length) {
                        cpentry = rawClassapth[i];
                        if (cpentry.getEntryKind() != 5 && cpentry.getEntryKind() != 3) {
                            cpEntries.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(cpentry));
                        }
                        ++i;
                    }
                    continue;
                }
                catch (IOException | URISyntaxException | CoreException e) {
                    SARLEclipsePlugin.getDefault().log(e);
                    return null;
                }
            }
            if (!entry.contains(DOT_JAR_EXTENSION)) continue;
            try {
                URL bundleJARfileFullURL = new URL(bundleInstallURL.toExternalForm().concat(File.separator).concat(entry));
                File jarFile = Util.toLocalFile((URI)bundleJARfileFullURL.toURI(), null);
                Path jarFilePath = new Path(jarFile.getAbsolutePath());
                IClasspathEntry cpEntry = JanusSREInstall.newLibraryEntry(bundle, (IPath)jarFilePath);
                JanusSREInstall.addToRuntimeClassPath(bundle, cpEntry, cpEntries);
            }
            catch (MalformedURLException | URISyntaxException | CoreException e) {
                SARLEclipsePlugin.getDefault().log(e);
                return null;
            }
        }
        if (cpEntries.size() > 0) {
            this.dependencies.put(bundle, new Pair(bundle.getVersion(), cpEntries));
        }
        return outputLocation;
    }

    public String getNameNoDefault() {
        return Locale.getString(((Object)((Object)this)).getClass(), "PLUGIN_NAME", new Object[0]);
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, String> getAvailableCommandLineOptions() {
        HashMap<String, String> options = Maps.newHashMap();
        options.put("CLI-Show-Logo", "");
        options.put("CLI-Hide-Logo", JanusSREInstall.formatCommandLineOption((String)"nologo", null));
        options.put("CLI-Show-Info", JanusSREInstall.formatCommandLineOption((String)"log", (String)"info"));
        options.put("CLI-Hide-Info", JanusSREInstall.formatCommandLineOption((String)"log", (String)"warning"));
        options.put("CLI-Default-Context-ID", JanusSREInstall.formatCommandLineOption((String)"worldid", null));
        options.put("CLI-Random-Context-ID", JanusSREInstall.formatCommandLineOption((String)"randomid", null));
        options.put("CLI-BootAgent-Context-ID", JanusSREInstall.formatCommandLineOption((String)"bootid", null));
        options.put("CLI-Offline", JanusSREInstall.formatCommandLineOption((String)"offline", null));
        options.put("CLI-Embedded", JanusSREInstall.formatCommandLineOption((String)"embedded", null));
        options.put("CLI-No-More-Option", JanusSREInstall.formatCommandLineOption(null, null));
        return Collections.unmodifiableMap(options);
    }

    public boolean isStandalone() {
        return true;
    }

    public String getSREArguments() {
        return "";
    }

    public String getJVMArguments() {
        return "";
    }

    public void getAsXML(Document document, Element element) throws IOException {
    }

    public void setFromXML(Element element) throws IOException {
    }

    protected void resolveDirtyFields(boolean forceSettings) {
    }
}

