/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject;

import com.google.common.base.Strings;
import com.google.inject.Module;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.Kernel;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.services.network.NetworkConfig;
import io.janusproject.util.LoggerCreator;
import io.sarl.lang.core.Agent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.arakhne.afc.vmutil.locale.Locale;

public final class Boot {
    public static final String CLI_OPTION_EMBEDDED_SHORT = "e";
    public static final String CLI_OPTION_EMBEDDED_LONG = "embedded";
    public static final String CLI_OPTION_BOOTID_SHORT = "B";
    public static final String CLI_OPTION_BOOTID_LONG = "bootid";
    public static final String CLI_OPTION_RANDOMID_SHORT = "R";
    public static final String CLI_OPTION_RANDOMID_LONG = "randomid";
    public static final String CLI_OPTION_WORLDID_SHORT = "W";
    public static final String CLI_OPTION_WORLDID_LONG = "worldid";
    public static final String CLI_OPTION_FILE_SHORT = "f";
    public static final String CLI_OPTION_FILE_LONG = "file";
    public static final String CLI_OPTION_HELP_SHORT = "h";
    public static final String CLI_OPTION_HELP_LONG = "help";
    public static final String CLI_OPTION_NOLOGO_LONG = "nologo";
    public static final String CLI_OPTION_OFFLINE_SHORT = "o";
    public static final String CLI_OPTION_OFFLINE_LONG = "offline";
    public static final String CLI_OPTION_QUIET_SHORT = "q";
    public static final String CLI_OPTION_QUIET_LONG = "quiet";
    public static final String CLI_OPTION_VERBOSE_SHORT = "v";
    public static final String CLI_OPTION_VERBOSE_LONG = "verbose";
    public static final String CLI_OPTION_LOG_SHORT = "l";
    public static final String CLI_OPTION_LOG_LONG = "log";
    public static final String CLI_OPTION_DEFINE_SHORT = "D";
    public static final String CLI_OPTION_DEFINE_LONG = "define";
    public static final String CLI_OPTION_SHOWDEFAULTS_SHORT = "s";
    public static final String CLI_OPTION_SHOWDEFAULTS_LONG = "showdefaults";
    public static final String CLI_OPTION_SHOWCLIARGUMENTS_LONG = "cli";
    private static final int ERROR_EXIT_CODE = 255;
    private static PrintStream consoleLogger;
    private static Exiter applicationExiter;

    private Boot() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] parseCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(Boot.getOptions(), args);
            if (cmd.getArgs().length == 0) {
                Boot.showHelp();
                return null;
            }
            boolean noLogo = false;
            boolean embedded = false;
            int verbose = LoggerCreator.toInt("info");
            Iterator<Option> optIterator = cmd.iterator();
            block34: while (optIterator.hasNext()) {
                Option opt = optIterator.next();
                switch (opt.getLongOpt()) {
                    case "help": {
                        Boot.showHelp();
                        return null;
                    }
                    case "showdefaults": {
                        Boot.showDefaults();
                        return null;
                    }
                    case "cli": {
                        Boot.showCommandLineArguments(args);
                        return null;
                    }
                    case "file": {
                        File file;
                        String rawFilename = opt.getValue();
                        if (rawFilename == null || "".equals(rawFilename)) {
                            Boot.showHelp();
                        }
                        if (!(file = new File(rawFilename)).canRead()) {
                            Boot.showError(Locale.getString(Boot.class, "INVALID_PROPERTY_FILENAME", rawFilename), null);
                            return null;
                        }
                        Boot.setPropertiesFrom(file);
                        break;
                    }
                    case "offline": {
                        Boot.setOffline(true);
                        break;
                    }
                    case "randomid": {
                        Boot.setRandomContextUUID();
                        break;
                    }
                    case "bootid": {
                        Boot.setBootAgentTypeContextUUID();
                        break;
                    }
                    case "worldid": {
                        Boot.setDefaultContextUUID();
                        break;
                    }
                    case "define": {
                        String name = opt.getValue(0);
                        if (Strings.isNullOrEmpty(name)) continue block34;
                        Boot.setProperty(name, Strings.emptyToNull(opt.getValue(1)));
                        break;
                    }
                    case "log": {
                        verbose = Math.max(LoggerCreator.toInt(opt.getValue()), 0);
                        break;
                    }
                    case "quiet": {
                        if (verbose <= 0) continue block34;
                        --verbose;
                        break;
                    }
                    case "verbose": {
                        ++verbose;
                        break;
                    }
                    case "nologo": {
                        noLogo = true;
                        break;
                    }
                    case "embedded": {
                        embedded = true;
                        break;
                    }
                }
            }
            Boot.setVerboseLevel(verbose);
            if (embedded) {
                Boot.setExiter(() -> {
                    throw new ChuckNorrisException();
                });
            }
            if (noLogo || verbose == 0) {
                Boot.setProperty("janus.logo.show", Boolean.FALSE.toString());
            }
            return cmd.getArgs();
        }
        catch (IOException | ParseException e) {
            Boot.showError(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private static Class<? extends Agent> loadAgentClass(String fullyQualifiedName) {
        Class<?> type;
        try {
            type = Class.forName(fullyQualifiedName);
        }
        catch (Exception e) {
            Boot.showError(Locale.getString(Boot.class, "INVALID_AGENT_QUALIFIED_NAME", fullyQualifiedName, System.getProperty("java.class.path")), e);
            return null;
        }
        if (Agent.class.isAssignableFrom(type)) {
            return type.asSubclass(Agent.class);
        }
        Boot.showError(Locale.getString(Boot.class, "INVALID_AGENT_TYPE", fullyQualifiedName), null);
        return null;
    }

    public static void main(String[] args) {
        try {
            String[] freeArgs = Boot.parseCommandLine(args);
            if (JanusConfig.getSystemPropertyAsBoolean("janus.logo.show", JanusConfig.JANUS_LOGO_SHOW)) {
                Boot.showJanusLogo();
            }
            if (freeArgs.length == 0) {
                Boot.showError(Locale.getString(Boot.class, "NO_AGENT_QUALIFIED_NAME", new Object[0]), null);
                return;
            }
            String agentToLaunch = freeArgs[0].toString();
            freeArgs = Arrays.copyOfRange(freeArgs, 1, freeArgs.length, String[].class);
            Class<? extends Agent> agent = Boot.loadAgentClass(agentToLaunch);
            assert (agent != null);
            Boot.startJanus(null, agent, (Object[])freeArgs);
        }
        catch (ChuckNorrisException chuckNorrisException) {
            return;
        }
        catch (Throwable e) {
            Boot.showError(Locale.getString(Boot.class, "LAUNCHING_ERROR", e.getLocalizedMessage()), e);
            return;
        }
    }

    public static PrintStream getConsoleLogger() {
        return consoleLogger == null ? System.err : consoleLogger;
    }

    public static void setConsoleLogger(PrintStream stream) {
        consoleLogger = stream;
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption(CLI_OPTION_EMBEDDED_SHORT, CLI_OPTION_EMBEDDED_LONG, false, Locale.getString(Boot.class, "CLI_HELP_E", new Object[0]));
        options.addOption(CLI_OPTION_BOOTID_SHORT, CLI_OPTION_BOOTID_LONG, false, Locale.getString(Boot.class, "CLI_HELP_B", "janus.context.id.boot", "janus.context.id.random"));
        options.addOption(CLI_OPTION_FILE_SHORT, CLI_OPTION_FILE_LONG, true, Locale.getString(Boot.class, "CLI_HELP_F", new Object[0]));
        options.addOption(CLI_OPTION_HELP_SHORT, CLI_OPTION_HELP_LONG, false, Locale.getString(Boot.class, "CLI_HELP_H", new Object[0]));
        options.addOption(null, CLI_OPTION_NOLOGO_LONG, false, Locale.getString(Boot.class, "CLI_HELP_NOLOGO", new Object[0]));
        options.addOption(CLI_OPTION_OFFLINE_SHORT, CLI_OPTION_OFFLINE_LONG, false, Locale.getString(Boot.class, "CLI_HELP_O", "janus.network.offline"));
        options.addOption(CLI_OPTION_QUIET_SHORT, CLI_OPTION_QUIET_LONG, false, Locale.getString(Boot.class, "CLI_HELP_Q", new Object[0]));
        options.addOption(CLI_OPTION_RANDOMID_SHORT, CLI_OPTION_RANDOMID_LONG, false, Locale.getString(Boot.class, "CLI_HELP_R", "janus.context.id.boot", "janus.context.id.random"));
        options.addOption(CLI_OPTION_SHOWDEFAULTS_SHORT, CLI_OPTION_SHOWDEFAULTS_LONG, false, Locale.getString(Boot.class, "CLI_HELP_S", new Object[0]));
        options.addOption(null, CLI_OPTION_SHOWCLIARGUMENTS_LONG, false, Locale.getString(Boot.class, "CLI_HELP_CLI", new Object[0]));
        options.addOption(CLI_OPTION_VERBOSE_SHORT, CLI_OPTION_VERBOSE_LONG, false, Locale.getString(Boot.class, "CLI_HELP_V", new Object[0]));
        options.addOption(CLI_OPTION_WORLDID_SHORT, CLI_OPTION_WORLDID_LONG, false, Locale.getString(Boot.class, "CLI_HELP_W", "janus.context.id.boot", "janus.context.id.random"));
        StringBuilder b = new StringBuilder();
        int level = 0;
        String[] stringArray = LoggerCreator.getLevelStrings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String logLevel = stringArray[n2];
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(logLevel);
            b.append(" (");
            b.append(level);
            b.append(")");
            ++level;
            ++n2;
        }
        Option opt = new Option(CLI_OPTION_LOG_SHORT, CLI_OPTION_LOG_LONG, true, Locale.getString(Boot.class, "CLI_HELP_L", "info", b));
        opt.setArgs(1);
        options.addOption(opt);
        opt = new Option(CLI_OPTION_DEFINE_SHORT, CLI_OPTION_DEFINE_LONG, true, Locale.getString(Boot.class, "CLI_HELP_D", new Object[0]));
        opt.setArgs(2);
        opt.setValueSeparator('=');
        opt.setArgName(Locale.getString(Boot.class, "CLI_HELP_D_ARGNAME", new Object[0]));
        options.addOption(opt);
        return options;
    }

    protected static void showError(String message, Throwable exception) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter logger = new PrintWriter(Boot.getConsoleLogger());){
            if (message != null && !message.isEmpty()) {
                logger.println(message);
            }
            if (exception != null) {
                exception.printStackTrace(logger);
            }
            logger.flush();
            Boot.showHelp(logger);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void showHelp() {
        Boot.showHelp(new PrintWriter(Boot.getConsoleLogger()));
    }

    private static void showHelp(PrintWriter logger) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(logger, 74, String.valueOf(Boot.class.getName()) + " " + Locale.getString(Boot.class, "CLI_PARAM_SYNOPTIC", new Object[0]), "", Boot.getOptions(), 1, 3, "");
        logger.flush();
        Boot.getExiter().exit();
    }

    public static void showDefaults() {
        Properties defaultValues = new Properties();
        JanusConfig.getDefaultValues(defaultValues);
        NetworkConfig.getDefaultValues(defaultValues);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PrintStream os = Boot.getConsoleLogger();){
                defaultValues.storeToXML(os, null);
                ((OutputStream)os).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Boot.getExiter().exit();
    }

    public static void showCommandLineArguments(String[] args) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PrintStream os = Boot.getConsoleLogger();){
                int i = 0;
                while (i < args.length) {
                    os.println(String.valueOf(i) + ": " + args[i]);
                    ++i;
                }
                os.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Boot.getExiter().exit();
    }

    public static void showJanusLogo() {
        System.out.println(Locale.getString(Boot.class, "JANUS_TEXT_LOGO", new Object[0]));
    }

    public static void setOffline(boolean isOffline) {
        System.setProperty("janus.network.offline", Boolean.toString(isOffline));
    }

    public static void setRandomContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.FALSE.toString());
        System.setProperty("janus.context.id.random", Boolean.TRUE.toString());
    }

    public static void setBootAgentTypeContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.TRUE.toString());
        System.setProperty("janus.context.id.random", Boolean.FALSE.toString());
    }

    public static void setDefaultContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.FALSE.toString());
        System.setProperty("janus.context.id.random", Boolean.FALSE.toString());
    }

    public static void setVerboseLevel(int level) {
        System.setProperty("janus.verbose.level", Integer.toString(level));
    }

    public static void setProperty(String name, String value) {
        if (name != null && !name.isEmpty()) {
            if (value == null || value.isEmpty()) {
                System.getProperties().remove(name);
            } else {
                System.setProperty(name, value);
            }
        }
    }

    public static void setPropertiesFrom(URL propertyFile) throws IOException {
        Properties systemProperties = System.getProperties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = propertyFile.openStream();){
            systemProperties.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setPropertiesFrom(File propertyFile) throws IOException {
        Properties systemProperties = System.getProperties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream stream = new FileInputStream(propertyFile);){
            systemProperties.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static UUID getBootAgentIdentifier() {
        String id = JanusConfig.getSystemProperty("janus.boot.agent.id");
        if (id != null && !id.isEmpty()) {
            try {
                return UUID.fromString(id);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static Kernel startJanus(Class<? extends Module> platformModule, Class<? extends Agent> agentCls, Object ... params) throws Exception {
        Class<? extends Module> startupModule = platformModule;
        if (startupModule == null) {
            startupModule = JanusConfig.getSystemPropertyAsClass(Module.class, "janus.injection.module", JanusConfig.INJECTION_MODULE_NAME_VALUE);
        }
        assert (startupModule != null) : "No platform injection module";
        return Boot.startJanus(startupModule.newInstance(), agentCls, params);
    }

    public static Kernel startJanus(Module startupModule, Class<? extends Agent> agentCls, Object ... params) throws Exception {
        UUID id;
        System.setProperty("janus.boot.agent", agentCls.getName());
        assert (startupModule != null) : "No platform injection module";
        Kernel k = Kernel.create(startupModule);
        Logger logger = k.getLogger();
        if (logger != null) {
            logger.info(Locale.getString(Boot.class, "LAUNCHING_AGENT", agentCls.getName()));
        }
        if ((id = k.spawn(agentCls, params)) != null) {
            System.setProperty("janus.boot.agent.id", id.toString());
        } else {
            System.getProperties().remove("janus.boot.agent.id");
        }
        return k;
    }

    public static Exiter getExiter() {
        return applicationExiter == null ? () -> System.exit(255) : applicationExiter;
    }

    public static void setExiter(Exiter exiter) {
        applicationExiter = exiter;
    }

    @FunctionalInterface
    public static interface Exiter {
        public void exit();
    }
}

