/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.XmlElements;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConfigBuilder
extends AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(AbstractConfigBuilder.class);
    private final Set<String> currentlyImportedFiles = new HashSet<String>();
    private final XPath xpath;

    public AbstractConfigBuilder() {
        XPathFactory fac = XPathFactory.newInstance();
        this.xpath = fac.newXPath();
        this.xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "hz".equals(prefix) ? AbstractConfigBuilder.this.xmlns : null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
    }

    protected void process(Node root) throws Exception {
        this.traverseChildsAndReplaceVariables(root);
        this.replaceImportElementsWithActualFileContents(root);
    }

    private void replaceImportElementsWithActualFileContents(Node root) throws Exception {
        Document document = root.getOwnerDocument();
        NodeList misplacedImports = (NodeList)this.xpath.evaluate(String.format("//hz:%s/parent::*[not(self::hz:%s)]", XmlElements.IMPORT.name, this.getXmlType().name), document, XPathConstants.NODESET);
        if (misplacedImports.getLength() > 0) {
            throw new InvalidConfigurationException("<import> element can appear only in the top level of the XML");
        }
        NodeList importTags = (NodeList)this.xpath.evaluate(String.format("/hz:%s/hz:%s", this.getXmlType().name, XmlElements.IMPORT.name), document, XPathConstants.NODESET);
        for (Node node : AbstractConfigBuilder.asElementIterable(importTags)) {
            this.loadAndReplaceImportElement(root, node);
        }
    }

    private void loadAndReplaceImportElement(Node root, Node node) throws Exception {
        NamedNodeMap attributes = node.getAttributes();
        Node resourceAtrribute = attributes.getNamedItem("resource");
        String resource = resourceAtrribute.getTextContent();
        URL url = ConfigLoader.locateConfig(resource);
        if (url == null) {
            throw new InvalidConfigurationException("Failed to load resource: " + resource);
        }
        if (!this.currentlyImportedFiles.add(url.getPath())) {
            throw new InvalidConfigurationException("Cyclic loading of resource " + url.getPath() + " is detected !");
        }
        Document doc = this.parse(url.openStream());
        Element importedRoot = doc.getDocumentElement();
        this.traverseChildsAndReplaceVariables(importedRoot);
        this.replaceImportElementsWithActualFileContents(importedRoot);
        for (Node fromImportedDoc : AbstractConfigBuilder.childElements(importedRoot)) {
            Node importedNode = root.getOwnerDocument().importNode(fromImportedDoc, true);
            root.insertBefore(importedNode, node);
        }
        root.removeChild(node);
    }

    protected abstract Document parse(InputStream var1) throws Exception;

    protected abstract Properties getProperties();

    @Override
    protected abstract ConfigType getXmlType();

    private void traverseChildsAndReplaceVariables(Node root) {
        NamedNodeMap attributes = root.getAttributes();
        if (attributes != null) {
            for (int k = 0; k < attributes.getLength(); ++k) {
                Node attribute = attributes.item(k);
                this.replaceVariables(attribute);
            }
        }
        if (root.getNodeValue() != null) {
            this.replaceVariables(root);
        }
        NodeList childNodes = root.getChildNodes();
        for (int k = 0; k < childNodes.getLength(); ++k) {
            Node child = childNodes.item(k);
            this.traverseChildsAndReplaceVariables(child);
        }
    }

    private void replaceVariables(Node node) {
        String value = node.getNodeValue();
        StringBuilder sb = new StringBuilder(value);
        int endIndex = -1;
        int startIndex = sb.indexOf("${");
        while (startIndex > -1) {
            endIndex = sb.indexOf("}", startIndex);
            if (endIndex == -1) {
                LOGGER.warning("Bad variable syntax. Could not find a closing curly bracket '}' on node: " + node.getLocalName());
                break;
            }
            String variable = sb.substring(startIndex + 2, endIndex);
            String variableReplacement = this.getProperties().getProperty(variable);
            if (variableReplacement != null) {
                sb.replace(startIndex, endIndex + 1, variableReplacement);
                endIndex = startIndex + variableReplacement.length();
            } else {
                LOGGER.warning("Could not find a value for property  '" + variable + "' on node: " + node.getLocalName());
            }
            startIndex = sb.indexOf("${", endIndex);
        }
        node.setNodeValue(sb.toString());
    }

    protected static enum ConfigType {
        SERVER("hazelcast"),
        CLIENT("hazelcast-client");

        final String name;

        private ConfigType(String name) {
            this.name = name;
        }
    }
}

