/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Errors;
import com.google.inject.multibindings.Element;
import com.google.inject.multibindings.Indexer;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.RealElement;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class MapBinder<K, V> {
    private MapBinder() {
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newRealMapBinder(binder, keyType, valueType, Key.get(MapBinder.mapOf(keyType, valueType)), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType)));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Annotation annotation) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newRealMapBinder(binder, keyType, valueType, Key.get(MapBinder.mapOf(keyType, valueType), annotation), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType), annotation));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType, Annotation annotation) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType), annotation);
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Class<? extends Annotation> annotationType) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newRealMapBinder(binder, keyType, valueType, Key.get(MapBinder.mapOf(keyType, valueType), annotationType), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType), annotationType));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType, Class<? extends Annotation> annotationType) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType), annotationType);
    }

    static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), valueType.getType()));
    }

    static <K, V> TypeLiteral<Map<K, Provider<V>>> mapOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.providerOf(valueType.getType())));
    }

    static <K, V> TypeLiteral<Map<K, javax.inject.Provider<V>>> mapOfJavaxProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.newParameterizedType(javax.inject.Provider.class, new Type[]{valueType.getType()})));
    }

    static <K, V> TypeLiteral<Map<K, Set<Provider<V>>>> mapOfSetOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.setOf(Types.providerOf(valueType.getType()))));
    }

    static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{keyType.getType(), Types.providerOf(valueType.getType())}));
    }

    static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> keyType, Key<V> valueTypeAndAnnotation) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        TypeLiteral<V> valueType = valueTypeAndAnnotation.getTypeLiteral();
        return MapBinder.newRealMapBinder(binder, keyType, valueType, valueTypeAndAnnotation.ofType(MapBinder.mapOf(keyType, valueType)), Multibinder.newSetBinder(binder, valueTypeAndAnnotation.ofType(MapBinder.entryOfProviderOf(keyType, valueType))));
    }

    private static <K, V> RealMapBinder<K, V> newRealMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
        RealMapBinder mapBinder = new RealMapBinder(binder, keyType, valueType, mapKey, entrySetBinder);
        binder.install(mapBinder);
        return mapBinder;
    }

    public abstract MapBinder<K, V> permitDuplicates();

    public abstract LinkedBindingBuilder<V> addBinding(K var1);

    static final class RealMapBinder<K, V>
    extends MapBinder<K, V>
    implements Module {
        private final TypeLiteral<K> keyType;
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private final Key<Map<K, javax.inject.Provider<V>>> javaxProviderMapKey;
        private final Key<Map<K, Provider<V>>> providerMapKey;
        private final Key<Map<K, Set<V>>> multimapKey;
        private final Key<Map<K, Set<Provider<V>>>> providerMultimapKey;
        private final Multibinder.RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;
        private final Map<K, String> duplicateKeyErrorMessages;
        private Binder binder;
        private boolean permitDuplicates;
        private ImmutableList<Map.Entry<K, Binding<V>>> mapBindings;

        private RealMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.mapKey = mapKey;
            this.providerMapKey = mapKey.ofType(RealMapBinder.mapOfProviderOf(keyType, valueType));
            this.javaxProviderMapKey = mapKey.ofType(RealMapBinder.mapOfJavaxProviderOf(keyType, valueType));
            this.multimapKey = mapKey.ofType(RealMapBinder.mapOf(keyType, Multibinder.setOf(valueType)));
            this.providerMultimapKey = mapKey.ofType(RealMapBinder.mapOfSetOfProviderOf(keyType, valueType));
            this.entrySetBinder = (Multibinder.RealMultibinder)entrySetBinder;
            this.binder = binder;
            this.duplicateKeyErrorMessages = Maps.newHashMap();
        }

        void updateDuplicateKeyMessage(K k, String errMsg) {
            this.duplicateKeyErrorMessages.put(k, errMsg);
        }

        @Override
        public MapBinder<K, V> permitDuplicates() {
            this.entrySetBinder.permitDuplicates();
            this.binder.install(new MultimapBinder<K, V>(this.multimapKey, this.providerMultimapKey, this.entrySetBinder.getSetKey()));
            return this;
        }

        Key<V> getKeyForNewValue(K key) {
            Multibinder.checkNotNull(key, "key");
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Key<V> valueKey = Key.get(this.valueType, (Annotation)new RealElement(this.entrySetBinder.getSetName(), Element.Type.MAPBINDER, this.keyType.toString()));
            this.entrySetBinder.addBinding().toProvider(new ProviderMapEntry(key, this.binder.getProvider(valueKey), valueKey));
            return valueKey;
        }

        @Override
        public LinkedBindingBuilder<V> addBinding(K key) {
            return this.binder.bind(this.getKeyForNewValue(key));
        }

        @Override
        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            ImmutableSet<Dependency<Set<Map.Entry<K, Provider<V>>>>> dependencies = ImmutableSet.of(Dependency.get(this.entrySetBinder.getSetKey()));
            Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider = binder.getProvider(this.entrySetBinder.getSetKey());
            binder.bind(this.providerMapKey).toProvider(new RealProviderMapProvider(dependencies, entrySetProvider));
            Key<Map<K, Provider<V>>> massagedProviderMapKey = this.providerMapKey;
            binder.bind(this.javaxProviderMapKey).to(massagedProviderMapKey);
            Provider<Map<K, Provider<V>>> mapProvider = binder.getProvider(this.providerMapKey);
            binder.bind(this.mapKey).toProvider(new RealMapProvider(dependencies, mapProvider));
        }

        boolean containsElement(Element element) {
            Key key;
            if (this.entrySetBinder.containsElement(element)) {
                return true;
            }
            if (element instanceof Binding) {
                key = ((Binding)element).getKey();
            } else if (element instanceof ProviderLookup) {
                key = ((ProviderLookup)element).getKey();
            } else {
                return false;
            }
            return key.equals(this.mapKey) || key.equals(this.providerMapKey) || key.equals(this.javaxProviderMapKey) || key.equals(this.multimapKey) || key.equals(this.providerMultimapKey) || key.equals(this.entrySetBinder.getSetKey()) || this.matchesValueKey(key);
        }

        private boolean matchesValueKey(Key<?> key) {
            return key.getAnnotation() instanceof RealElement && ((RealElement)key.getAnnotation()).setName().equals(this.entrySetBinder.getSetName()) && ((RealElement)key.getAnnotation()).type() == Element.Type.MAPBINDER && ((RealElement)key.getAnnotation()).keyType().equals(this.keyType.toString()) && key.getTypeLiteral().equals(this.valueType);
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object o) {
            return o instanceof RealMapBinder && ((RealMapBinder)o).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private Multimap<K, String> newLinkedKeyArrayValueMultimap() {
            return Multimaps.newListMultimap(new LinkedHashMap(), new Supplier<List<String>>(){

                @Override
                public List<String> get() {
                    return Lists.newArrayList();
                }
            });
        }

        private static abstract class RealMapBinderProviderWithDependencies<T>
        implements ProviderWithDependencies<T> {
            private final Object equality;

            public RealMapBinderProviderWithDependencies(Object equality) {
                this.equality = equality;
            }

            public boolean equals(Object obj) {
                return this.getClass() == obj.getClass() && this.equality.equals(((RealMapBinderProviderWithDependencies)obj).equality);
            }

            public int hashCode() {
                return this.equality.hashCode();
            }
        }

        private static abstract class RealMapWithExtensionProvider<T>
        extends RealMapBinderProviderWithDependencies<T>
        implements ProviderWithExtensionVisitor<T>,
        MapBinderBinding<T> {
            public RealMapWithExtensionProvider(Object equality) {
                super(equality);
            }
        }

        static final class ProviderMapEntry<K, V>
        implements ProviderWithDependencies<Map.Entry<K, Provider<V>>>,
        Map.Entry<K, Provider<V>> {
            private final K key;
            private final Provider<V> provider;
            private final Key<V> valueKey;

            private ProviderMapEntry(K key, Provider<V> provider, Key<V> valueKey) {
                this.key = key;
                this.provider = provider;
                this.valueKey = valueKey;
            }

            @Override
            public Map.Entry<K, Provider<V>> get() {
                return this;
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                return ((HasDependencies)((Object)this.provider)).getDependencies();
            }

            public Key<V> getValueKey() {
                return this.valueKey;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public Provider<V> getValue() {
                return this.provider;
            }

            @Override
            public Provider<V> setValue(Provider<V> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry o = (Map.Entry)obj;
                    return Objects.equal(this.key, o.getKey()) && Objects.equal(this.provider, o.getValue());
                }
                return false;
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ this.provider.hashCode();
            }

            public String toString() {
                String string = String.valueOf(String.valueOf(this.key));
                String string2 = String.valueOf(String.valueOf(this.provider));
                return new StringBuilder(20 + string.length() + string2.length()).append("ProviderMapEntry(").append(string).append(", ").append(string2).append(")").toString();
            }
        }

        static final class ValueProvider<V>
        implements Provider<V> {
            private final Provider<V> delegate;
            private final Binding<V> binding;

            ValueProvider(Provider<V> delegate, Binding<V> binding) {
                this.delegate = delegate;
                this.binding = binding;
            }

            @Override
            public V get() {
                return this.delegate.get();
            }

            public Binding<V> getValueBinding() {
                return this.binding;
            }
        }

        static final class MultimapBinder<K, V>
        implements Module {
            private final Key<Map<K, Set<V>>> multimapKey;
            private final Key<Map<K, Set<Provider<V>>>> providerMultimapKey;
            private final Key<Set<Map.Entry<K, Provider<V>>>> entrySetKey;

            public MultimapBinder(Key<Map<K, Set<V>>> multimapKey, Key<Map<K, Set<Provider<V>>>> providerMultimapKey, Key<Set<Map.Entry<K, Provider<V>>>> entrySetKey) {
                this.multimapKey = multimapKey;
                this.providerMultimapKey = providerMultimapKey;
                this.entrySetKey = entrySetKey;
            }

            @Override
            public void configure(Binder binder) {
                ImmutableSet<Dependency<?>> dependencies = ImmutableSet.of(Dependency.get(this.entrySetKey));
                Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider = binder.getProvider(this.entrySetKey);
                binder.bind(this.providerMultimapKey).toProvider(new RealProviderMultimapProvider(dependencies, entrySetProvider));
                Provider<Map<K, Set<Provider<V>>>> multimapProvider = binder.getProvider(this.providerMultimapKey);
                binder.bind(this.multimapKey).toProvider(new RealMultimapProvider(dependencies, multimapProvider));
            }

            public int hashCode() {
                return this.multimapKey.hashCode();
            }

            public boolean equals(Object o) {
                return o instanceof MultimapBinder && ((MultimapBinder)o).multimapKey.equals(this.multimapKey);
            }

            final class RealMultimapProvider
            extends RealMapBinderProviderWithDependencies<Map<K, Set<V>>> {
                private final ImmutableSet<Dependency<?>> dependencies;
                private final Provider<Map<K, Set<Provider<V>>>> multimapProvider;

                RealMultimapProvider(ImmutableSet<Dependency<?>> dependencies, Provider<Map<K, Set<Provider<V>>>> multimapProvider) {
                    super(MultimapBinder.this.multimapKey);
                    this.dependencies = dependencies;
                    this.multimapProvider = multimapProvider;
                }

                @Override
                public Map<K, Set<V>> get() {
                    ImmutableMap.Builder multimapBuilder = ImmutableMap.builder();
                    for (Map.Entry entry : this.multimapProvider.get().entrySet()) {
                        Object key = entry.getKey();
                        ImmutableSet.Builder valuesBuilder = ImmutableSet.builder();
                        for (Provider valueProvider : entry.getValue()) {
                            Object value = valueProvider.get();
                            Multibinder.checkConfiguration(value != null, "Multimap injection failed due to null value for key \"%s\"", key);
                            valuesBuilder.add(value);
                        }
                        multimapBuilder.put(key, valuesBuilder.build());
                    }
                    return multimapBuilder.build();
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return this.dependencies;
                }
            }

            final class RealProviderMultimapProvider
            extends RealMapBinderProviderWithDependencies<Map<K, Set<Provider<V>>>> {
                private final ImmutableSet<Dependency<?>> dependencies;
                private final Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider;
                private Map<K, Set<Provider<V>>> providerMultimap;

                private RealProviderMultimapProvider(ImmutableSet<Dependency<?>> dependencies, Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider) {
                    super(MultimapBinder.this.multimapKey);
                    this.dependencies = dependencies;
                    this.entrySetProvider = entrySetProvider;
                }

                @Inject
                void initialize(Injector injector) {
                    LinkedHashMap providerMultimapMutable = new LinkedHashMap();
                    for (Map.Entry entry : this.entrySetProvider.get()) {
                        if (!providerMultimapMutable.containsKey(entry.getKey())) {
                            providerMultimapMutable.put(entry.getKey(), ImmutableSet.builder());
                        }
                        ((ImmutableSet.Builder)providerMultimapMutable.get(entry.getKey())).add(entry.getValue());
                    }
                    ImmutableMap.Builder providerMultimapBuilder = ImmutableMap.builder();
                    for (Map.Entry entry : providerMultimapMutable.entrySet()) {
                        providerMultimapBuilder.put(entry.getKey(), ((ImmutableSet.Builder)entry.getValue()).build());
                    }
                    this.providerMultimap = providerMultimapBuilder.build();
                }

                @Override
                public Map<K, Set<Provider<V>>> get() {
                    return this.providerMultimap;
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return this.dependencies;
                }
            }
        }

        final class RealMapProvider
        extends RealMapWithExtensionProvider<Map<K, V>> {
            private final ImmutableSet<Dependency<?>> dependencies;
            private final Provider<Map<K, Provider<V>>> mapProvider;

            private RealMapProvider(ImmutableSet<Dependency<?>> dependencies, Provider<Map<K, Provider<V>>> mapProvider) {
                super(RealMapBinder.this.mapKey);
                this.dependencies = dependencies;
                this.mapProvider = mapProvider;
            }

            @Override
            public Map<K, V> get() {
                LinkedHashMap map = new LinkedHashMap(this.mapProvider.get());
                for (Map.Entry entry : map.entrySet()) {
                    ValueProvider provider = (ValueProvider)entry.getValue();
                    Object value = provider.get();
                    Multibinder.checkConfiguration(value != null, "Map injection failed due to null value for key \"%s\", bound at: %s", entry.getKey(), provider.getValueBinding().getSource());
                    entry.setValue(value);
                }
                LinkedHashMap typedMap = map;
                return Collections.unmodifiableMap(typedMap);
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }

            @Override
            public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> visitor, ProviderInstanceBinding<? extends B> binding) {
                if (visitor instanceof MultibindingsTargetVisitor) {
                    return (R)((MultibindingsTargetVisitor)visitor).visit(this);
                }
                return visitor.visit(binding);
            }

            @Override
            public Key<Map<K, V>> getMapKey() {
                return RealMapBinder.this.mapKey;
            }

            @Override
            public TypeLiteral<?> getKeyTypeLiteral() {
                return RealMapBinder.this.keyType;
            }

            @Override
            public TypeLiteral<?> getValueTypeLiteral() {
                return RealMapBinder.this.valueType;
            }

            @Override
            public List<Map.Entry<?, Binding<?>>> getEntries() {
                if (RealMapBinder.this.isInitialized()) {
                    return RealMapBinder.this.mapBindings;
                }
                throw new UnsupportedOperationException("getElements() not supported for module bindings");
            }

            @Override
            public boolean permitsDuplicates() {
                if (RealMapBinder.this.isInitialized()) {
                    return RealMapBinder.this.permitDuplicates;
                }
                throw new UnsupportedOperationException("permitsDuplicates() not supported for module bindings");
            }

            @Override
            public boolean containsElement(Element element) {
                return RealMapBinder.this.containsElement(element);
            }
        }

        final class RealProviderMapProvider
        extends RealMapBinderProviderWithDependencies<Map<K, Provider<V>>> {
            private final ImmutableSet<Dependency<?>> dependencies;
            private final Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider;
            private Map<K, Provider<V>> providerMap;

            private RealProviderMapProvider(ImmutableSet<Dependency<?>> dependencies, Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider) {
                super(RealMapBinder.this.mapKey);
                this.dependencies = dependencies;
                this.entrySetProvider = entrySetProvider;
            }

            @Toolable
            @Inject
            void initialize(Injector injector) {
                Object valueKey;
                RealMapBinder.this.binder = null;
                RealMapBinder.this.permitDuplicates = RealMapBinder.this.entrySetBinder.permitsDuplicates(injector);
                LinkedHashMap providerMapMutable = new LinkedHashMap();
                ArrayList bindingsMutable = Lists.newArrayList();
                Indexer indexer = new Indexer(injector);
                HashMultimap index = HashMultimap.create();
                HashSet duplicateKeys = null;
                for (Map.Entry entry : this.entrySetProvider.get()) {
                    ProviderMapEntry providerMapEntry = (ProviderMapEntry)entry;
                    valueKey = providerMapEntry.getValueKey();
                    Binding<Indexer.IndexedBinding> valueBinding = injector.getBinding(valueKey);
                    if (!index.put(providerMapEntry.getKey(), valueBinding.acceptTargetVisitor(indexer))) continue;
                    Provider previous = providerMapMutable.put(providerMapEntry.getKey(), new ValueProvider(providerMapEntry.getValue(), valueBinding));
                    if (previous != null && !RealMapBinder.this.permitDuplicates) {
                        if (duplicateKeys == null) {
                            duplicateKeys = Sets.newHashSet();
                        }
                        duplicateKeys.add(providerMapEntry.getKey());
                    }
                    bindingsMutable.add(Maps.immutableEntry(providerMapEntry.getKey(), valueBinding));
                }
                if (duplicateKeys != null) {
                    Multimap dups = RealMapBinder.this.newLinkedKeyArrayValueMultimap();
                    for (Map.Entry entry : bindingsMutable) {
                        if (!duplicateKeys.contains(entry.getKey())) continue;
                        valueKey = String.valueOf(String.valueOf(Errors.convert(((Binding)entry.getValue()).getSource())));
                        dups.put(entry.getKey(), new StringBuilder(5 + ((String)valueKey).length()).append("\t at ").append((String)valueKey).toString());
                    }
                    StringBuilder sb = new StringBuilder("Map injection failed due to duplicated key ");
                    boolean bl = true;
                    for (Object key : dups.keySet()) {
                        String string;
                        boolean bl2;
                        if (bl2) {
                            bl2 = false;
                            if (RealMapBinder.this.duplicateKeyErrorMessages.containsKey(key)) {
                                sb.setLength(0);
                                sb.append((String)RealMapBinder.this.duplicateKeyErrorMessages.get(key));
                            } else {
                                string = String.valueOf(String.valueOf(key));
                                sb.append(new StringBuilder(19 + string.length()).append("\"").append(string).append("\", from bindings:\n").toString());
                            }
                        } else if (RealMapBinder.this.duplicateKeyErrorMessages.containsKey(key)) {
                            String string2 = String.valueOf((String)RealMapBinder.this.duplicateKeyErrorMessages.get(key));
                            sb.append(string2.length() != 0 ? "\n and ".concat(string2) : new String("\n and "));
                        } else {
                            string = String.valueOf(String.valueOf(key));
                            sb.append(new StringBuilder(30 + string.length()).append("\n and key: \"").append(string).append("\", from bindings:\n").toString());
                        }
                        Joiner.on('\n').appendTo(sb, (Iterable<?>)dups.get(key)).append("\n");
                    }
                    Multibinder.checkConfiguration(false, sb.toString(), new Object[0]);
                }
                this.providerMap = ImmutableMap.copyOf(providerMapMutable);
                RealMapBinder.this.mapBindings = ImmutableList.copyOf(bindingsMutable);
            }

            @Override
            public Map<K, Provider<V>> get() {
                return this.providerMap;
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                return this.dependencies;
            }
        }
    }
}

