/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import io.janusproject.JanusConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerCreator {
    private static final String FORMAT_PROPERTY_KEY = "java.util.logging.SimpleFormatter.format";
    private static final String JANUS_FORMAT = "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp %3$s%n%4$s: %5$s%6$s%n";
    private static Level levelFromProperties;

    private LoggerCreator() {
    }

    public static void useJanusMessageFormat() {
        String format = System.getProperty(FORMAT_PROPERTY_KEY, null);
        if (format == null || format.isEmpty()) {
            System.setProperty(FORMAT_PROPERTY_KEY, JANUS_FORMAT);
        }
    }

    public static Logger createLogger(String name) {
        Logger logger = Logger.getLogger(name);
        logger.setLevel(LoggerCreator.getLoggingLevelFromProperties());
        return logger;
    }

    public static Logger createLogger(String name, Logger parent) {
        Logger logger = Logger.getLogger(name);
        if (parent != null) {
            logger.setParent(parent);
        }
        logger.setUseParentHandlers(true);
        if (parent != null) {
            logger.setLevel(parent.getLevel());
        }
        return logger;
    }

    public static Level getLoggingLevelFromProperties() {
        if (levelFromProperties == null) {
            String verboseLevel = JanusConfig.getSystemProperty("janus.verbose.level", "info");
            levelFromProperties = LoggerCreator.parseLoggingLevel(verboseLevel);
        }
        return levelFromProperties;
    }

    public static Level parseLoggingLevel(String level) {
        if (level == null) {
            return Level.INFO;
        }
        switch (level.toLowerCase()) {
            case "none": 
            case "false": 
            case "0": {
                return Level.OFF;
            }
            case "severe": 
            case "error": 
            case "1": {
                return Level.SEVERE;
            }
            case "warn": 
            case "warning": 
            case "2": {
                return Level.WARNING;
            }
            case "info": 
            case "true": 
            case "3": {
                return Level.INFO;
            }
            case "fine": 
            case "config": 
            case "4": {
                return Level.FINE;
            }
            case "finer": 
            case "5": {
                return Level.FINER;
            }
            case "finest": 
            case "debug": 
            case "6": {
                return Level.FINEST;
            }
            case "all": 
            case "7": {
                return Level.ALL;
            }
        }
        try {
            return LoggerCreator.fromInt(Integer.parseInt(level));
        }
        catch (Throwable throwable) {
            return Level.INFO;
        }
    }

    public static Level fromInt(int num) {
        switch (num) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.FINE;
            }
            case 5: {
                return Level.FINER;
            }
            case 6: {
                return Level.FINEST;
            }
            case 7: {
                return Level.ALL;
            }
        }
        if (num < 0) {
            return Level.OFF;
        }
        return Level.ALL;
    }

    public static int toInt(Level level) {
        if (level == Level.OFF) {
            return 0;
        }
        if (level == Level.SEVERE) {
            return 1;
        }
        if (level == Level.WARNING) {
            return 2;
        }
        if (level == Level.INFO) {
            return 3;
        }
        if (level == Level.CONFIG) {
            return 4;
        }
        if (level == Level.FINE) {
            return 4;
        }
        if (level == Level.FINER) {
            return 5;
        }
        if (level == Level.FINEST) {
            return 6;
        }
        if (level == Level.ALL) {
            return 7;
        }
        return 3;
    }

    public static int toInt(String level) {
        return LoggerCreator.toInt(LoggerCreator.parseLoggingLevel(level));
    }

    public static String[] getLevelStrings() {
        return new String[]{"none", "error", "warning", "info", "fine", "finer", "finest", "all"};
    }
}

