/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class ListenerCollection<L extends EventListener> {
    private static final Object[] NULL = new Object[0];
    protected transient Object[] listeners = NULL;

    public boolean isEmpty() {
        return this.listeners == NULL;
    }

    public void clear() {
        this.listeners = NULL;
    }

    public Object[] getListenerList() {
        return this.listeners;
    }

    public <T extends EventListener> T[] getListeners(Class<T> type) {
        Object[] listeners = this.listeners;
        int listenerCount = ListenerCollection.getListenerCount(listeners, type);
        EventListener[] result = (EventListener[])Array.newInstance(type, listenerCount);
        int j = 0;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != type) continue;
            result[j++] = (EventListener)type.cast(listeners[i + 1]);
        }
        return result;
    }

    public int size() {
        return this.listeners.length / 2;
    }

    public int getListenerCount(Class<?> type) {
        return ListenerCollection.getListenerCount(this.listeners, type);
    }

    private static int getListenerCount(Object[] list, Class<?> type) {
        int count = 0;
        for (int i = 0; i < list.length; i += 2) {
            if (type != (Class)list[i]) continue;
            ++count;
        }
        return count;
    }

    public synchronized <T extends EventListener> void add(Class<T> type, T listener) {
        assert (listener != null);
        if (this.listeners == NULL) {
            this.listeners = new Object[]{type, listener};
        } else {
            int i = this.listeners.length;
            Object[] tmp = new Object[i + 2];
            System.arraycopy(this.listeners, 0, tmp, 0, i);
            tmp[i] = type;
            tmp[i + 1] = listener;
            this.listeners = tmp;
        }
    }

    public synchronized <T extends EventListener> void remove(Class<T> type, T listener) {
        assert (listener != null);
        int index = -1;
        for (int i = this.listeners.length - 2; i >= 0; i -= 2) {
            if (this.listeners[i] != type || !this.listeners[i + 1].equals(listener)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listeners.length - 2];
            System.arraycopy(this.listeners, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listeners, index + 2, tmp, index, tmp.length - index);
            }
            this.listeners = tmp.length == 0 ? NULL : tmp;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Object[] lList = this.listeners;
        stream.defaultWriteObject();
        for (int i = 0; i < lList.length; i += 2) {
            Class t = (Class)lList[i];
            EventListener listener = (EventListener)lList[i + 1];
            if (listener == null || !(listener instanceof Serializable)) continue;
            stream.writeObject(t.getName());
            stream.writeObject(listener);
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listeners = NULL;
        stream.defaultReadObject();
        while (null != (listenerTypeOrNull = stream.readObject())) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            EventListener listener = (EventListener)stream.readObject();
            this.add(Class.forName((String)listenerTypeOrNull, true, cl), listener);
        }
    }

    public String toString() {
        Object[] lList = this.listeners;
        String txt = "EventListenerList: ";
        txt = txt + lList.length / 2 + " listeners: ";
        for (int i = 0; i <= lList.length - 2; i += 2) {
            txt = txt + " type " + ((Class)lList[i]).getName();
            txt = txt + " listener " + lList[i + 1];
        }
        return txt;
    }
}

