/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.util.ListenerCollection;

public abstract class AbstractMapView<K, V> {
    protected final ListenerCollection<DMapListener<? super K, ? super V>> listeners = new ListenerCollection();

    protected void fireEntryAdded(K key, V value) {
        if (this.listeners != null) {
            for (DMapListener listener : (DMapListener[])this.listeners.getListeners(DMapListener.class)) {
                listener.entryAdded(key, value);
            }
        }
    }

    protected void fireEntryRemoved(K key, V value) {
        if (this.listeners != null) {
            for (DMapListener listener : (DMapListener[])this.listeners.getListeners(DMapListener.class)) {
                listener.entryRemoved(key, value);
            }
        }
    }

    protected void fireEntryUpdated(K key, V value) {
        for (DMapListener listener : (DMapListener[])this.listeners.getListeners(DMapListener.class)) {
            listener.entryUpdated(key, value);
        }
    }

    protected void fireCleared(boolean localClearing) {
        for (DMapListener listener : (DMapListener[])this.listeners.getListeners(DMapListener.class)) {
            listener.mapCleared(localClearing);
        }
    }

    public void addDMapListener(DMapListener<? super K, ? super V> listener) {
        this.listeners.add(DMapListener.class, listener);
    }

    public void removeDMapListener(DMapListener<? super K, ? super V> listener) {
        this.listeners.remove(DMapListener.class, listener);
    }
}

