/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.janusproject.services.distributeddata.DMultiMap;
import io.janusproject.util.AbstractMapView;
import io.janusproject.util.DataViewDelegate;
import io.janusproject.util.MultisetView;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractDMultiMapView<K, V>
extends AbstractMapView<K, V>
implements DMultiMap<K, V>,
Serializable,
DataViewDelegate.Delegator<Multimap<K, V>> {
    private static final long serialVersionUID = -6970650402150118406L;
    private final String name;
    private transient Map<K, Collection<V>> map;

    public AbstractDMultiMapView(String name) {
        this.name = name;
    }

    @Override
    public boolean isBackedCollection() {
        return true;
    }

    Collection<V> wrapValues(K key, Collection<V> values) {
        Object backEnd = DataViewDelegate.undelegate(values);
        if (backEnd instanceof List) {
            return new SingleKeyValueListView(key, (List)values);
        }
        if (backEnd instanceof Set) {
            return new SingleKeyValueSetView(key, (Set)values);
        }
        throw new IllegalStateException("Unsupported type of the backend multimap: " + values.getClass());
    }

    Collection<V> copyValues(Collection<V> values) {
        Object backEnd = DataViewDelegate.undelegate(values);
        if (backEnd instanceof List) {
            return Lists.newArrayList(values);
        }
        if (backEnd instanceof TreeSet) {
            TreeSet c = (TreeSet)backEnd;
            c = Sets.newTreeSet(c.comparator());
            c.addAll(values);
            return c;
        }
        if (backEnd instanceof LinkedHashSet) {
            return Sets.newLinkedHashSet(values);
        }
        if (backEnd instanceof Set) {
            return Sets.newHashSet(values);
        }
        throw new IllegalStateException("Unsupported type of the backend multimap: " + values.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return ((Multimap)this.getDelegatedObject()).equals(DataViewDelegate.undelegate(obj));
    }

    public int hashCode() {
        return ((Multimap)this.getDelegatedObject()).hashCode();
    }

    public String toString() {
        return ((Multimap)this.getDelegatedObject()).toString();
    }

    public boolean containsKey(Object key) {
        return ((Multimap)this.getDelegatedObject()).containsKey(key);
    }

    public boolean containsValue(Object value) {
        return ((Multimap)this.getDelegatedObject()).containsValue(value);
    }

    public boolean containsEntry(Object key, Object value) {
        return ((Multimap)this.getDelegatedObject()).containsEntry(key, value);
    }

    public int size() {
        return ((Multimap)this.getDelegatedObject()).size();
    }

    @Override
    public int valueCount(K key) {
        Collection values = ((Multimap)this.getDelegatedObject()).get(key);
        if (values != null && !values.isEmpty()) {
            return values.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        return ((Multimap)this.getDelegatedObject()).isEmpty();
    }

    public boolean put(K key, V value) {
        if (((Multimap)this.getDelegatedObject()).put(key, value)) {
            this.fireEntryAdded(key, value);
            return true;
        }
        return false;
    }

    public boolean remove(Object key, Object value) {
        if (((Multimap)this.getDelegatedObject()).remove(key, value)) {
            this.fireEntryRemoved(key, value);
            return true;
        }
        return false;
    }

    public Collection<V> removeAll(Object key) {
        Collection values = ((Multimap)this.getDelegatedObject()).removeAll(key);
        if (values != null && !values.isEmpty()) {
            Object kkey = key;
            for (Object value : values) {
                this.fireEntryRemoved(kkey, value);
            }
        }
        return values;
    }

    public boolean putAll(K key, Iterable<? extends V> values) {
        boolean changed = false;
        for (V value : values) {
            if (!((Multimap)this.getDelegatedObject()).put(key, value)) continue;
            changed = true;
            this.fireEntryAdded(key, value);
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            if (!((Multimap)this.getDelegatedObject()).put(entry.getKey(), entry.getValue())) continue;
            changed = true;
            this.fireEntryAdded(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
        return ((Multimap)this.getDelegatedObject()).replaceValues(key, values);
    }

    public void clear() {
        if (!((Multimap)this.getDelegatedObject()).isEmpty()) {
            ((Multimap)this.getDelegatedObject()).clear();
            this.fireCleared(false);
        }
    }

    public Collection<V> get(K key) {
        return this.wrapValues(key, ((Multimap)this.getDelegatedObject()).get(key));
    }

    public Set<K> keySet() {
        return new KeySetView(((Multimap)this.getDelegatedObject()).keySet());
    }

    public Collection<Map.Entry<K, V>> entries() {
        return new EntryCollectionView(((Multimap)this.getDelegatedObject()).entries());
    }

    public Collection<V> values() {
        return new ValueCollectionView(((Multimap)this.getDelegatedObject()).entries());
    }

    public Multiset<K> keys() {
        return new MultisetView(this);
    }

    public Map<K, Collection<V>> asMap() {
        if (this.map == null) {
            this.map = new MapView(((Multimap)this.getDelegatedObject()).asMap());
        }
        return this.map;
    }

    protected class MapView
    extends AbstractMap<K, Collection<V>>
    implements DataViewDelegate.Delegator<Map<K, Collection<V>>> {
        private final Map<K, Collection<V>> backedMap;

        public MapView(Map<K, Collection<V>> backedMap) {
            this.backedMap = backedMap;
        }

        @Override
        public Map<K, Collection<V>> getDelegatedObject() {
            return this.backedMap;
        }

        @Override
        public boolean equals(Object obj) {
            return this.backedMap.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.backedMap.hashCode();
        }

        @Override
        public String toString() {
            return this.backedMap.toString();
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            return new EntrySet(this.backedMap.entrySet());
        }

        @Override
        public Collection<V> remove(Object key) {
            Collection collection = this.backedMap.remove(key);
            if (collection == null) {
                return null;
            }
            Collection output = AbstractDMultiMapView.this.copyValues(collection);
            collection.clear();
            for (Object value : output) {
                AbstractDMultiMapView.this.fireEntryRemoved(key, value);
            }
            return output;
        }

        @Override
        public Collection<V> get(Object key) {
            Collection collection = this.backedMap.get(key);
            if (collection == null) {
                return null;
            }
            return AbstractDMultiMapView.this.wrapValues(key, collection);
        }

        @Override
        public void clear() {
            AbstractDMultiMapView.this.clear();
        }

        @Override
        public Set<K> keySet() {
            return AbstractDMultiMapView.this.keySet();
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<K, Collection<V>>> {
            private final Set<Map.Entry<K, Collection<V>>> backedSet;

            EntrySet(Set<Map.Entry<K, Collection<V>>> backedSet) {
                this.backedSet = backedSet;
            }

            @Override
            public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                return new EntryIterator(this.backedSet.iterator());
            }

            @Override
            public int size() {
                return this.backedSet.size();
            }

            private class EntryIterator
            implements Iterator<Map.Entry<K, Collection<V>>> {
                private final Iterator<Map.Entry<K, Collection<V>>> iterator;
                private Map.Entry<K, Collection<V>> entry;

                EntryIterator(Iterator<Map.Entry<K, Collection<V>>> iterator) {
                    this.iterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    this.entry = this.iterator.next();
                    Collection wrappedValues = AbstractDMultiMapView.this.wrapValues(this.entry.getKey(), this.entry.getValue());
                    return Maps.immutableEntry(this.entry.getKey(), wrappedValues);
                }

                @Override
                public void remove() {
                    if (this.entry == null) {
                        throw new IllegalStateException();
                    }
                    Collection originalCollection = this.entry.getValue();
                    ArrayList oldValues = Lists.newArrayList(originalCollection);
                    this.iterator.remove();
                    Object key = this.entry.getKey();
                    for (Object value : oldValues) {
                        AbstractDMultiMapView.this.fireEntryRemoved(key, value);
                    }
                    this.entry = null;
                }
            }
        }
    }

    protected class ValueCollectionView
    extends AbstractCollection<V>
    implements Serializable,
    DataViewDelegate.Delegator<Collection<V>> {
        private static final long serialVersionUID = -1288962742301549934L;
        private final Collection<Map.Entry<K, V>> entries;

        public ValueCollectionView(Collection<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @Override
        public Collection<V> getDelegatedObject() {
            return ((Multimap)AbstractDMultiMapView.this.getDelegatedObject()).values();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public void clear() {
            AbstractDMultiMapView.this.clear();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(this.entries.iterator());
        }

        private class ValueIterator
        implements Iterator<V> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private Map.Entry<K, V> entry;

            ValueIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                this.entry = this.iterator.next();
                return this.entry.getValue();
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMultiMapView.this.fireEntryRemoved(this.entry.getKey(), this.entry.getValue());
            }
        }
    }

    protected class EntryCollectionView
    extends AbstractCollection<Map.Entry<K, V>>
    implements Serializable,
    DataViewDelegate.Delegator<Collection<Map.Entry<K, V>>> {
        private static final long serialVersionUID = 3746778947439539504L;
        private final Collection<Map.Entry<K, V>> entries;

        public EntryCollectionView(Collection<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @Override
        public Collection<Map.Entry<K, V>> getDelegatedObject() {
            return ((Multimap)AbstractDMultiMapView.this.getDelegatedObject()).entries();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (this.entries.add(entry)) {
                AbstractDMultiMapView.this.fireEntryAdded(entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        private class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private Map.Entry<K, V> entry;

            EntryIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = this.iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMultiMapView.this.fireEntryRemoved(this.entry.getKey(), this.entry.getValue());
            }
        }
    }

    protected class KeySetView
    extends AbstractSet<K>
    implements Serializable,
    DataViewDelegate.Delegator<Set<K>> {
        private static final long serialVersionUID = -5008029594376258921L;
        private final Set<K> keys;

        public KeySetView(Set<K> keys) {
            this.keys = keys;
        }

        @Override
        public Set<K> getDelegatedObject() {
            return this.keys;
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public int size() {
            return this.keys.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.keys.iterator());
        }

        private class KeyIterator
        implements Iterator<K> {
            private final Iterator<K> iterator;
            private K key;

            KeyIterator(Iterator<K> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public K next() {
                this.key = this.iterator.next();
                return this.key;
            }

            @Override
            public void remove() {
                Collection oldValues = AbstractDMultiMapView.this.get(this.key);
                Object[] tab = new Object[oldValues.size()];
                oldValues.toArray(tab);
                this.iterator.remove();
                for (Object value : tab) {
                    AbstractDMultiMapView.this.fireEntryRemoved(this.key, value);
                }
            }
        }
    }

    protected class SingleKeyValueSetView
    extends AbstractSet<V>
    implements Serializable,
    DataViewDelegate.Delegator<Set<V>> {
        private static final long serialVersionUID = 4290615787745160981L;
        private final K key;
        private final Set<V> values;

        public SingleKeyValueSetView(K key, Set<V> values) {
            this.key = key;
            this.values = values;
        }

        @Override
        public Set<V> getDelegatedObject() {
            return this.values;
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(this.values.iterator());
        }

        @Override
        public boolean add(V element) {
            if (this.values.add(element)) {
                AbstractDMultiMapView.this.fireEntryAdded(this.key, element);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractDMultiMapView.this.removeAll(this.key);
        }

        private class ValueIterator
        implements Iterator<V> {
            private final Iterator<V> iterator;
            private V value;

            ValueIterator(Iterator<V> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                this.value = this.iterator.next();
                return this.value;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMultiMapView.this.fireEntryRemoved(SingleKeyValueSetView.this.key, this.value);
            }
        }
    }

    protected class SingleKeyValueListView
    extends AbstractList<V>
    implements Serializable,
    DataViewDelegate.Delegator<List<V>> {
        private static final long serialVersionUID = 4290615787745160981L;
        private final K key;
        private final List<V> values;

        public SingleKeyValueListView(K key, List<V> values) {
            this.key = key;
            this.values = values;
        }

        @Override
        public List<V> getDelegatedObject() {
            return this.values;
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public V get(int index) {
            return this.values.get(index);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(this.values.iterator());
        }

        @Override
        public boolean add(V element) {
            if (this.values.add(element)) {
                AbstractDMultiMapView.this.fireEntryAdded(this.key, element);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractDMultiMapView.this.removeAll(this.key);
        }

        private class ValueIterator
        implements Iterator<V> {
            private final Iterator<V> iterator;
            private V value;

            ValueIterator(Iterator<V> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                this.value = this.iterator.next();
                return this.value;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMultiMapView.this.fireEntryRemoved(SingleKeyValueListView.this.key, this.value);
            }
        }
    }
}

