/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.util;

import io.janusproject.services.distributeddata.DMap;
import io.janusproject.util.AbstractMapView;
import io.janusproject.util.DataViewDelegate;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDMapView<K, V>
extends AbstractMapView<K, V>
implements DMap<K, V>,
Serializable,
DataViewDelegate.Delegator<Map<K, V>> {
    private static final long serialVersionUID = -2836872682477402816L;
    private final String name;

    public AbstractDMapView(String name) {
        this.name = name;
    }

    @Override
    public boolean isBackedCollection() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        return ((Map)this.getDelegatedObject()).equals(DataViewDelegate.undelegate(obj));
    }

    @Override
    public int hashCode() {
        return ((Map)this.getDelegatedObject()).hashCode();
    }

    public String toString() {
        return ((Map)this.getDelegatedObject()).toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((Map)this.getDelegatedObject()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Map)this.getDelegatedObject()).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((Map)this.getDelegatedObject()).get(key);
    }

    @Override
    public boolean isEmpty() {
        return ((Map)this.getDelegatedObject()).isEmpty();
    }

    @Override
    public int size() {
        return ((Map)this.getDelegatedObject()).size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntryView(((Map)this.getDelegatedObject()).entrySet());
    }

    @Override
    public Set<K> keySet() {
        return new KeyView(((Map)this.getDelegatedObject()).entrySet());
    }

    @Override
    public Collection<V> values() {
        return new ValueView(((Map)this.getDelegatedObject()).entrySet());
    }

    @Override
    public void clear() {
        if (!((Map)this.getDelegatedObject()).isEmpty()) {
            ((Map)this.getDelegatedObject()).clear();
            this.fireCleared(false);
        }
    }

    @Override
    public V put(K key, V value) {
        V old = ((Map)this.getDelegatedObject()).put(key, value);
        if (old != null) {
            this.fireEntryUpdated(key, value);
        } else {
            this.fireEntryAdded(key, value);
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Object old = ((Map)this.getDelegatedObject()).remove(key);
        if (old != null) {
            this.fireEntryRemoved(key, old);
        }
        return old;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (!((Map)this.getDelegatedObject()).containsKey(key)) {
            V old = ((Map)this.getDelegatedObject()).put(key, value);
            this.fireEntryAdded(key, value);
            return old;
        }
        return ((Map)this.getDelegatedObject()).get(key);
    }

    protected class ValueView
    extends AbstractCollection<V>
    implements Serializable,
    DataViewDelegate.Delegator<Collection<V>> {
        private static final long serialVersionUID = -5603710938557144864L;
        private final Set<Map.Entry<K, V>> entries;

        public ValueView(Set<Map.Entry<K, V>> data) {
            this.entries = data;
        }

        @Override
        public Collection<V> getDelegatedObject() {
            return ((Map)AbstractDMapView.this.getDelegatedObject()).values();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(this.entries.iterator());
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        private class ValueIterator
        implements Iterator<V> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private K key;
            private V value;

            ValueIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                Map.Entry entry = this.iterator.next();
                this.key = entry.getKey();
                this.value = entry.getValue();
                return this.value;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMapView.this.fireEntryRemoved(this.key, this.value);
            }
        }
    }

    protected class KeyView
    extends AbstractSet<K>
    implements Serializable,
    DataViewDelegate.Delegator<Set<K>> {
        private static final long serialVersionUID = -1182559049456023451L;
        private final Set<Map.Entry<K, V>> entries;

        public KeyView(Set<Map.Entry<K, V>> data) {
            this.entries = data;
        }

        @Override
        public Set<K> getDelegatedObject() {
            return ((Map)AbstractDMapView.this.getDelegatedObject()).keySet();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.entries.iterator());
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        private class KeyIterator
        implements Iterator<K> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private K key;
            private V value;

            KeyIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public K next() {
                Map.Entry entry = this.iterator.next();
                this.key = entry.getKey();
                this.value = entry.getValue();
                return this.key;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMapView.this.fireEntryRemoved(this.key, this.value);
            }
        }
    }

    protected class EntryView
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable,
    DataViewDelegate.Delegator<Set<Map.Entry<K, V>>> {
        private static final long serialVersionUID = 7929741824792802767L;
        private final Set<Map.Entry<K, V>> entries;

        public EntryView(Set<Map.Entry<K, V>> data) {
            this.entries = data;
        }

        @Override
        public Set<Map.Entry<K, V>> getDelegatedObject() {
            return this.entries;
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        private class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private K key;
            private V value;

            EntryIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = this.iterator.next();
                this.key = entry.getKey();
                this.value = entry.getValue();
                return entry;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                AbstractDMapView.this.fireEntryRemoved(this.key, this.value);
            }
        }
    }
}

