/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.services;

import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import io.janusproject.services.AsyncStateService;
import io.janusproject.services.DependentService;
import io.janusproject.services.GoogleServiceManager;
import io.janusproject.services.IServiceManager;
import io.janusproject.services.infrastructure.InfrastructureService;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.TreeSet;
import org.arakhne.afc.vmutil.ClassComparator;

public final class Services {
    private Services() {
    }

    public static void startServices(ServiceManager manager) {
        Services.startServices(new GoogleServiceManager(manager));
    }

    public static void startServices(IServiceManager manager) {
        ArrayList<Service> otherServices = new ArrayList<Service>();
        ArrayList<Service> infraServices = new ArrayList<Service>();
        LinkedList<DependencyNode> serviceQueue = new LinkedList<DependencyNode>();
        StartingPhaseAccessors accessors = new StartingPhaseAccessors();
        Services.buildDependencyGraph(manager, serviceQueue, infraServices, otherServices, accessors);
        Services.runDependencyGraph(serviceQueue, infraServices, otherServices, accessors);
        manager.awaitHealthy();
    }

    public static void stopServices(ServiceManager manager) {
        Services.stopServices(new GoogleServiceManager(manager));
    }

    public static void stopServices(IServiceManager manager) {
        ArrayList<Service> otherServices = new ArrayList<Service>();
        ArrayList<Service> infraServices = new ArrayList<Service>();
        LinkedList<DependencyNode> serviceQueue = new LinkedList<DependencyNode>();
        StoppingPhaseAccessors accessors = new StoppingPhaseAccessors();
        Services.buildInvertedDependencyGraph(manager, serviceQueue, infraServices, otherServices, accessors);
        Services.runDependencyGraph(serviceQueue, infraServices, otherServices, accessors);
        manager.awaitStopped();
    }

    private static void addNodeIntoDependencyGraph(DependentService depServ, Map<Class<? extends Service>, DependencyNode> dependentServices, List<DependencyNode> roots) {
        DependencyNode depNode;
        Class<? extends Service> type = depServ.getServiceType();
        assert (type != null);
        assert (type.isInterface()) : type.getName();
        DependencyNode node = dependentServices.get(type);
        if (node == null) {
            node = new DependencyNode(depServ, type);
            dependentServices.put(type, node);
        } else {
            assert (node.getService() == null);
            node.setService(depServ);
        }
        boolean isRoot = true;
        Collection<Class<? extends Service>> deps = depServ.getServiceDependencies();
        for (Class<? extends Service> dep : deps) {
            isRoot = false;
            depNode = dependentServices.get(dep);
            if (depNode == null) {
                depNode = new DependencyNode(dep);
                dependentServices.put(dep, depNode);
            }
            depNode.getNextServices().add(node);
        }
        deps = depServ.getServiceWeakDependencies();
        for (Class<? extends Service> dep : deps) {
            isRoot = false;
            depNode = dependentServices.get(dep);
            if (depNode == null) {
                depNode = new DependencyNode(dep);
                dependentServices.put(dep, depNode);
            }
            depNode.getNextWeakServices().add(node);
        }
        if (isRoot) {
            roots.add(node);
        }
    }

    private static void buildDependencyGraph(IServiceManager manager, List<DependencyNode> roots, List<Service> infraServices, List<Service> freeServices, Accessors accessors) {
        TreeMap<Class<? extends Service>, DependencyNode> dependentServices = new TreeMap<Class<? extends Service>, DependencyNode>((Comparator<Class<? extends Service>>)ClassComparator.SINGLETON);
        for (Map.Entry entry : manager.servicesByState().entries()) {
            if (!accessors.matches((Service.State)entry.getKey())) continue;
            Service service = (Service)entry.getValue();
            if (service instanceof InfrastructureService) {
                infraServices.add(service);
                continue;
            }
            if (service instanceof DependentService) {
                Services.addNodeIntoDependencyGraph((DependentService)service, dependentServices, roots);
                continue;
            }
            freeServices.add(service);
        }
        if (accessors.isAsyncStateWaitingEnabled()) {
            for (DependencyNode node : dependentServices.values()) {
                assert (node.getService() != null);
                if (!(node.getService() instanceof AsyncStateService)) continue;
                for (DependencyNode next : node.getNextServices()) {
                    next.getAsyncStateServices().add(new WeakReference<DependencyNode>(node));
                }
            }
        }
    }

    private static void buildInvertedDependencyGraph(IServiceManager manager, List<DependencyNode> roots, List<Service> infraServices, List<Service> freeServices, Accessors accessors) {
        TreeMap<Class<? extends Service>, DependencyNode> dependentServices = new TreeMap<Class<? extends Service>, DependencyNode>((Comparator<Class<? extends Service>>)ClassComparator.SINGLETON);
        TreeMap<Class<? extends Service>, DependencyNode> rootServices = new TreeMap<Class<? extends Service>, DependencyNode>((Comparator<Class<? extends Service>>)ClassComparator.SINGLETON);
        for (Map.Entry entry : manager.servicesByState().entries()) {
            if (!accessors.matches((Service.State)entry.getKey())) continue;
            Service service = (Service)entry.getValue();
            if (service instanceof InfrastructureService) {
                infraServices.add(service);
                continue;
            }
            if (service instanceof DependentService) {
                DependencyNode depNode;
                DependentService depServ = (DependentService)service;
                Class<? extends Service> type = depServ.getServiceType();
                DependencyNode node = (DependencyNode)dependentServices.get(type);
                boolean isRoot = true;
                if (node == null) {
                    node = new DependencyNode(depServ, type);
                    dependentServices.put(type, node);
                } else {
                    assert (node.getService() == null);
                    node.setService(depServ);
                    isRoot = false;
                }
                Collection<Class<? extends Service>> deps = depServ.getServiceDependencies();
                for (Class<? extends Service> dep : deps) {
                    depNode = (DependencyNode)dependentServices.get(dep);
                    if (depNode == null) {
                        depNode = new DependencyNode(dep);
                        dependentServices.put(dep, depNode);
                    }
                    node.getNextServices().add(depNode);
                    rootServices.remove(depNode.getType());
                }
                deps = depServ.getServiceWeakDependencies();
                for (Class<? extends Service> dep : deps) {
                    depNode = (DependencyNode)dependentServices.get(dep);
                    if (depNode == null) {
                        depNode = new DependencyNode(dep);
                        dependentServices.put(dep, depNode);
                    }
                    node.getNextWeakServices().add(depNode);
                    rootServices.remove(depNode.getType());
                }
                if (!isRoot) continue;
                rootServices.put(type, node);
                continue;
            }
            freeServices.add(service);
        }
        roots.addAll(rootServices.values());
    }

    private static void runDependencyGraph(Queue<DependencyNode> roots, List<Service> infraServices, List<Service> freeServices, Accessors accessors) {
        boolean async = accessors.isAsyncStateWaitingEnabled();
        TreeSet<Class<? extends Service>> executed = new TreeSet<Class<? extends Service>>((Comparator<Class<? extends Service>>)ClassComparator.SINGLETON);
        accessors.runInfrastructureServicesBefore(infraServices);
        accessors.runFreeServicesBefore(freeServices);
        while (!roots.isEmpty()) {
            DependencyNode node = roots.remove();
            assert (node != null && node.getType() != null);
            if (executed.contains(node.getType())) continue;
            executed.add(node.getType());
            roots.addAll(node.getNextServices());
            roots.addAll(node.getNextWeakServices());
            assert (node.getService() != null);
            if (async) {
                for (WeakReference<DependencyNode> asyncService : node.getAsyncStateServices()) {
                    AsyncStateService as = (AsyncStateService)((DependencyNode)asyncService.get()).getService();
                    assert (as != null);
                    while (!as.isReadyForOtherServices()) {
                        Thread.yield();
                    }
                }
            }
            accessors.run(node.getService());
        }
        accessors.runFreeServicesAfter(freeServices);
        accessors.runInfrastructureServicesAfter(infraServices);
    }

    private static class StoppingPhaseAccessors
    implements Accessors {
        StoppingPhaseAccessors() {
        }

        @Override
        public boolean matches(Service.State element) {
            return element != Service.State.TERMINATED && element != Service.State.STOPPING;
        }

        @Override
        public void runFreeServicesBefore(List<Service> freeServices) {
            for (Service serv : freeServices) {
                serv.stopAsync();
            }
        }

        @Override
        public void runInfrastructureServicesBefore(List<Service> infraServices) {
        }

        @Override
        public boolean isAsyncStateWaitingEnabled() {
            return false;
        }

        @Override
        public void run(Service service) {
            service.stopAsync().awaitTerminated();
        }

        @Override
        public void runFreeServicesAfter(List<Service> freeServices) {
        }

        @Override
        public void runInfrastructureServicesAfter(List<Service> infraServices) {
            for (Service serv : infraServices) {
                serv.stopAsync();
            }
        }
    }

    private static class StartingPhaseAccessors
    implements Accessors {
        StartingPhaseAccessors() {
        }

        @Override
        public boolean matches(Service.State element) {
            return element == Service.State.NEW;
        }

        @Override
        public void runFreeServicesBefore(List<Service> freeServices) {
        }

        @Override
        public void runInfrastructureServicesBefore(List<Service> infraServices) {
            for (Service serv : infraServices) {
                serv.startAsync().awaitRunning();
            }
        }

        @Override
        public boolean isAsyncStateWaitingEnabled() {
            return true;
        }

        @Override
        public void run(Service service) {
            service.startAsync().awaitRunning();
        }

        @Override
        public void runFreeServicesAfter(List<Service> freeServices) {
            for (Service serv : freeServices) {
                serv.startAsync();
            }
        }

        @Override
        public void runInfrastructureServicesAfter(List<Service> infraServices) {
        }
    }

    private static interface Accessors {
        public boolean matches(Service.State var1);

        public void runInfrastructureServicesBefore(List<Service> var1);

        public void runFreeServicesBefore(List<Service> var1);

        public boolean isAsyncStateWaitingEnabled();

        public void run(Service var1);

        public void runFreeServicesAfter(List<Service> var1);

        public void runInfrastructureServicesAfter(List<Service> var1);
    }

    private static class DependencyNode {
        private Service service;
        private final Class<? extends Service> type;
        private final Collection<DependencyNode> nextServices = new ArrayList<DependencyNode>();
        private final Collection<DependencyNode> nextWeakServices = new ArrayList<DependencyNode>();
        private final Collection<WeakReference<DependencyNode>> asyncStateServices = new ArrayList<WeakReference<DependencyNode>>();

        DependencyNode(DependentService service, Class<? extends Service> type) {
            assert (service != null);
            this.service = service;
            this.type = type;
        }

        DependencyNode(Class<? extends Service> type) {
            this.service = null;
            this.type = type;
        }

        public Service getService() {
            return this.service;
        }

        public void setService(Service service) {
            this.service = service;
        }

        public Class<? extends Service> getType() {
            return this.type;
        }

        public Collection<WeakReference<DependencyNode>> getAsyncStateServices() {
            return this.asyncStateServices;
        }

        public Collection<DependencyNode> getNextServices() {
            return this.nextServices;
        }

        public Collection<DependencyNode> getNextWeakServices() {
            return this.nextWeakServices;
        }

        public String toString() {
            if (this.service == null) {
                return "!!!" + this.type.getName();
            }
            return this.service.toString();
        }
    }
}

