/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.hazelcast;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import java.io.IOException;
import java.util.UUID;
import org.arakhne.afc.vmutil.locale.Locale;

class SpaceIDSerializer
implements StreamSerializer<SpaceID> {
    public static final int SPACE_ID_CLASS_TYPE = 19118;

    SpaceIDSerializer() {
    }

    public int getTypeId() {
        return 19118;
    }

    public void destroy() {
    }

    public void write(ObjectDataOutput out, SpaceID object) throws IOException {
        out.writeObject((Object)object.getContextID());
        out.writeObject((Object)object.getID());
        out.writeUTF(object.getSpaceSpecification().getCanonicalName());
    }

    public SpaceID read(ObjectDataInput in) throws IOException {
        try {
            Class<?> type;
            UUID cid = (UUID)in.readObject();
            UUID id = (UUID)in.readObject();
            String specCls = in.readUTF();
            if (cid != null && id != null && specCls != null && SpaceSpecification.class.isAssignableFrom(type = Class.forName(specCls))) {
                return new SpaceID(cid, id, type);
            }
            throw new IOException(Locale.getString((String)"BUILD_ERROR", (Object[])new Object[]{cid, id, specCls}));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(Locale.getString((String)"SPECIFICATION_CLASS_NOT_FOUND", (Object[])new Object[0]), e);
        }
    }
}

