/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules.hazelcast;

import com.hazelcast.logging.AbstractLogger;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactorySupport;
import io.janusproject.services.logging.LogService;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class HazelcastKernelLoggerFactory
extends LoggerFactorySupport {
    private static LogService logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogService getLogService() {
        Class<HazelcastKernelLoggerFactory> clazz = HazelcastKernelLoggerFactory.class;
        synchronized (HazelcastKernelLoggerFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogService(LogService service) {
        Class<HazelcastKernelLoggerFactory> clazz = HazelcastKernelLoggerFactory.class;
        synchronized (HazelcastKernelLoggerFactory.class) {
            logger = service;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected ILogger createLogger(String name) {
        return new HzKernelLogger();
    }

    private static final class HzKernelLogger
    extends AbstractLogger {
        HzKernelLogger() {
        }

        public void log(Level level, String message) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                serv.log(new LogRecord(level, message));
            }
        }

        public void log(Level level, String message, Throwable thrown) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null && serv.isLoggeable(level)) {
                StackTraceElement elt = HzKernelLogger.getCaller();
                assert (elt != null);
                LogRecord record = new LogRecord(level, message);
                if (thrown != null) {
                    record.setThrown(thrown);
                }
                record.setSourceClassName(elt.getClassName());
                record.setSourceMethodName(elt.getMethodName());
                serv.log(record);
            }
        }

        public void log(LogEvent logEvent) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                serv.log(logEvent.getLogRecord());
            }
        }

        public Level getLevel() {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                return serv.getLevel();
            }
            return Level.OFF;
        }

        public boolean isLoggable(Level level) {
            LogService serv = HazelcastKernelLoggerFactory.getLogService();
            if (serv != null) {
                return serv.isLoggeable(level);
            }
            return false;
        }

        private static StackTraceElement getCaller() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < stackTrace.length; ++i) {
                try {
                    Class<?> type = Class.forName(stackTrace[i].getClassName());
                    if (type == null || ILogger.class.isAssignableFrom(type)) continue;
                    return stackTrace[i];
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

