/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import io.janusproject.JanusConfig;
import io.janusproject.modules.BootModule;
import io.janusproject.modules.StandardCoreModule;
import io.janusproject.modules.eventserial.NetworkEventModule;
import io.janusproject.modules.hazelcast.HazelcastModule;
import io.janusproject.modules.kernel.LocalDistributedDataStructureServiceModule;
import io.janusproject.modules.kernel.LocalInfrastructureServiceModule;
import io.janusproject.modules.kernel.LocalKernelDiscoveryServiceModule;
import io.janusproject.modules.nonetwork.NoNetworkModule;
import io.janusproject.modules.zeromq.ZeroMQNetworkModule;
import org.arakhne.afc.vmutil.OperatingSystem;

public class StandardJanusPlatformModule
extends AbstractModule {
    protected void configure() {
        boolean isNetworkEnabled = !JanusConfig.getSystemPropertyAsBoolean("janus.network.offline", false) && !OperatingSystem.ANDROID.isCurrentOS();
        this.install((Module)new BootModule());
        if (isNetworkEnabled) {
            this.install((Module)new HazelcastModule());
        } else {
            this.install((Module)new LocalInfrastructureServiceModule());
            this.install((Module)new LocalDistributedDataStructureServiceModule());
            this.install((Module)new LocalKernelDiscoveryServiceModule());
        }
        this.install((Module)new StandardCoreModule());
        if (isNetworkEnabled) {
            this.install((Module)new NetworkEventModule());
            this.install((Module)new ZeroMQNetworkModule());
        } else {
            this.install((Module)new NoNetworkModule());
        }
    }
}

