/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.spawn;

import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Service;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.janusproject.kernel.bic.BuiltinCapacityUtil;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.spawn.KernelAgentSpawnListener;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.janusproject.util.ListenerCollection;
import io.sarl.core.AgentKilled;
import io.sarl.core.AgentSpawned;
import io.sarl.lang.annotation.SarlSpecification;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.inject.Inject;
import org.arakhne.afc.vmutil.locale.Locale;

@Singleton
public class StandardSpawnService
extends AbstractDependentService
implements SpawnService {
    private final ListenerCollection<?> globalListeners = new ListenerCollection();
    private final Multimap<UUID, SpawnServiceListener> agentLifecycleListeners = ArrayListMultimap.create();
    private final Map<UUID, Agent> agents = new TreeMap<UUID, Agent>();
    private final Injector injector;

    @Inject
    public StandardSpawnService(Injector injector) {
        this.injector = injector;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return SpawnService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ContextSpaceService.class);
    }

    private static void ensureSarlSpecificationVersion(Class<? extends Agent> agentClazz) {
        String value;
        SarlSpecification annotation = agentClazz.getAnnotation(SarlSpecification.class);
        if (annotation != null && !Strings.isNullOrEmpty((String)(value = annotation.value())) && "0.3".equals(value)) {
            return;
        }
        throw new InvalidSarlSpecificationException(agentClazz);
    }

    @Override
    public synchronized UUID spawn(AgentContext parent, UUID agentID, Class<? extends Agent> agentClazz, Object ... params) {
        if (this.isRunning()) {
            try {
                StandardSpawnService.ensureSarlSpecificationVersion(agentClazz);
                JustInTimeAgentInjectionModule agentInjectionModule = new JustInTimeAgentInjectionModule(this.injector, agentClazz, parent.getID(), agentID);
                Injector agentInjector = this.injector.createChildInjector(new Module[]{agentInjectionModule});
                Agent agent = (Agent)agentInjector.getInstance(Agent.class);
                assert (agent != null);
                this.agents.put(agent.getID(), agent);
                this.fireAgentSpawned(parent, agent, params);
                return agent.getID();
            }
            catch (Throwable e) {
                throw new CannotSpawnException(agentClazz, e);
            }
        }
        throw new SpawnDisabledException(parent.getID(), agentClazz);
    }

    @Override
    public synchronized void killAgent(UUID agentID) throws SpawnService.AgentKillException {
        boolean error = !this.isRunning();
        Agent agent = this.agents.get(agentID);
        if (agent != null) {
            if (this.canKillAgent(agent)) {
                this.agents.remove(agentID);
                this.fireAgentDestroyed(agent);
                if (this.agents.isEmpty()) {
                    this.fireKernelAgentDestroy();
                }
                if (error) {
                    throw new SpawnServiceStopException(agentID);
                }
            } else {
                throw new SpawnService.AgentKillException(agentID);
            }
        }
    }

    public synchronized SynchronizedSet<UUID> getAgents() {
        return Collections3.synchronizedSet(this.agents.keySet(), (Object)this);
    }

    synchronized Agent getAgent(UUID id) {
        assert (id != null);
        return this.agents.get(id);
    }

    @Override
    public void addKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.add(KernelAgentSpawnListener.class, listener);
    }

    @Override
    public void removeKernelAgentSpawnListener(KernelAgentSpawnListener listener) {
        this.globalListeners.remove(KernelAgentSpawnListener.class, listener);
    }

    protected void fireKernelAgentSpawn() {
        for (KernelAgentSpawnListener l : (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class)) {
            l.kernelAgentSpawn();
        }
    }

    protected void fireKernelAgentDestroy() {
        for (KernelAgentSpawnListener l : (KernelAgentSpawnListener[])this.globalListeners.getListeners(KernelAgentSpawnListener.class)) {
            l.kernelAgentDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.put((Object)id, (Object)agentLifecycleListener);
        }
    }

    @Override
    public void addSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.add(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpawnServiceListener(UUID id, SpawnServiceListener agentLifecycleListener) {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.remove((Object)id, (Object)agentLifecycleListener);
        }
    }

    @Override
    public void removeSpawnServiceListener(SpawnServiceListener agentLifecycleListener) {
        this.globalListeners.remove(SpawnServiceListener.class, agentLifecycleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentSpawned(AgentContext context, Agent agent, Object[] initializationParameters) {
        for (SpawnServiceListener l : (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class)) {
            l.agentSpawned(context, agent, initializationParameters);
        }
        SpawnServiceListener[] spawnServiceListenerArray = this.agentLifecycleListeners;
        synchronized (this.agentLifecycleListeners) {
            Collection list = this.agentLifecycleListeners.get((Object)agent.getID());
            SpawnServiceListener[] agentListeners = new SpawnServiceListener[list.size()];
            list.toArray(agentListeners);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            for (SpawnServiceListener l : agentListeners) {
                l.agentSpawned(context, agent, initializationParameters);
            }
            UUID agentID = agent.getID();
            assert (agentID != null) : "Empty agent identifier";
            EventSpace defSpace = context.getDefaultSpace();
            assert (defSpace != null) : "A context does not contain a default space";
            Address agentAddress = defSpace.getAddress(agentID);
            assert (agentAddress != null) : "Cannot find an address in the default space for " + agentID;
            defSpace.emit((Event)new AgentSpawned(agentAddress, agentID, agent.getClass().getName()));
            return;
        }
    }

    public synchronized boolean canKillAgent(Agent agent) {
        try {
            SynchronizedSet participants;
            AgentContext ac = BuiltinCapacityUtil.getContextIn(agent);
            return ac == null || (participants = ac.getDefaultSpace().getParticipants()) == null || participants.size() <= 1 && (participants.size() != 1 || participants.contains(agent.getID()));
        }
        catch (Throwable exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAgentDestroyed(Agent agent) {
        SpawnServiceListener[] ilisteners;
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            Collection list = this.agentLifecycleListeners.get((Object)agent.getID());
            ilisteners = new SpawnServiceListener[list.size()];
            list.toArray(ilisteners);
        }
        SpawnServiceListener[] ilisteners2 = (SpawnServiceListener[])this.globalListeners.getListeners(SpawnServiceListener.class);
        try {
            SynchronizedCollection<AgentContext> sc = BuiltinCapacityUtil.getContextsOf(agent);
            Object object = sc.mutex();
            synchronized (object) {
                for (AgentContext context : sc) {
                    EventSpace defSpace = context.getDefaultSpace();
                    defSpace.emit((Event)new AgentKilled(defSpace.getAddress(agent.getID()), agent.getID(), agent.getClass().getName()));
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (SpawnServiceListener l : ilisteners) {
            l.agentDestroy(agent);
        }
        for (SpawnServiceListener l : ilisteners2) {
            l.agentDestroy(agent);
        }
    }

    protected synchronized void doStart() {
        this.fireKernelAgentSpawn();
        this.notifyStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doStop() {
        Multimap<UUID, SpawnServiceListener> multimap = this.agentLifecycleListeners;
        synchronized (multimap) {
            this.agentLifecycleListeners.clear();
        }
        this.notifyStopped();
    }

    private static class JustInTimeAgentInjectionModule
    extends AbstractModule
    implements Provider<Agent> {
        private final Injector injector;
        private final Class<? extends Agent> agentType;
        private final UUID parentID;
        private final UUID agentID;

        JustInTimeAgentInjectionModule(Injector injector, Class<? extends Agent> agentType, UUID parentID, UUID agentID) {
            assert (injector != null);
            assert (agentType != null);
            assert (parentID != null);
            this.injector = injector;
            this.agentType = agentType;
            this.parentID = parentID;
            this.agentID = agentID == null ? UUID.randomUUID() : agentID;
        }

        public void configure() {
            this.bind(Agent.class).toProvider((Provider)this);
        }

        public Agent get() {
            try {
                BuiltinCapacitiesProvider capacityProvider = (BuiltinCapacitiesProvider)this.injector.getInstance(BuiltinCapacitiesProvider.class);
                Constructor<? extends Agent> constructor = this.agentType.getConstructor(BuiltinCapacitiesProvider.class, UUID.class, UUID.class);
                return constructor.newInstance(capacityProvider, this.parentID, this.agentID);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                throw new CannotSpawnException(this.agentType, (Throwable)exception);
            }
        }
    }

    public static class CannotSpawnException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public CannotSpawnException(Class<? extends Agent> agentClazz, Throwable cause) {
            super(Locale.getString(StandardSpawnService.class, (String)"CANNOT_INSTANCIATE_AGENT", (Object[])new Object[]{agentClazz, cause == null ? null : cause.getLocalizedMessage()}), cause);
        }
    }

    public static class InvalidSarlSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = -3194494637438344108L;

        public InvalidSarlSpecificationException(Class<? extends Agent> agentType) {
            super(Locale.getString(StandardSpawnService.class, (String)"INVALID_SARL_SPECIFICATION", (Object[])new Object[]{agentType.getName()}));
        }
    }

    public static class SpawnServiceStopException
    extends RuntimeException {
        private static final long serialVersionUID = 8104012713598435249L;

        public SpawnServiceStopException(UUID agentID) {
            super(Locale.getString(StandardSpawnService.class, (String)"KILL_DISABLED", (Object[])new Object[]{agentID}));
        }
    }

    public static class SpawnDisabledException
    extends RuntimeException {
        private static final long serialVersionUID = -380402400888610762L;

        public SpawnDisabledException(UUID parentID, Class<? extends Agent> agentClazz) {
            super(Locale.getString(StandardSpawnService.class, (String)"SPAWN_DISABLED", (Object[])new Object[]{parentID, agentClazz}));
        }
    }
}

