/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.network;

import com.google.inject.Inject;
import io.janusproject.services.network.AbstractEventSerializer;
import io.janusproject.services.network.EventDispatch;
import io.janusproject.services.network.EventEncrypter;
import io.janusproject.services.network.EventEnvelope;
import io.janusproject.services.network.NetworkUtil;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.UUID;
import org.arakhne.afc.vmutil.locale.Locale;

public class JavaBinaryEventSerializer
extends AbstractEventSerializer {
    @Inject
    public JavaBinaryEventSerializer(EventEncrypter encrypter) {
        super(encrypter);
    }

    @Override
    public EventEnvelope serialize(EventDispatch dispatch) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (dispatch != null) : "Parameter 'dispatch' must not be null";
        Event event = dispatch.getEvent();
        assert (event != null);
        SpaceID spaceID = dispatch.getSpaceID();
        assert (spaceID != null);
        assert (spaceID.getSpaceSpecification() != null);
        Map<String, String> headers = dispatch.getCustomHeaders();
        assert (headers != null);
        headers.put("x-java-spacespec-class", spaceID.getSpaceSpecification().getName());
        Scope<?> scope = dispatch.getScope();
        EventEnvelope envelope = new EventEnvelope(NetworkUtil.toByteArray(spaceID.getContextID()), NetworkUtil.toByteArray(spaceID.getID()), JavaBinaryEventSerializer.toBytes(scope), JavaBinaryEventSerializer.toBytes(dispatch.getCustomHeaders()), JavaBinaryEventSerializer.toBytes(event));
        this.encrypter.encrypt(envelope);
        return envelope;
    }

    private static byte[] toBytes(Object object) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    @Override
    public EventDispatch deserialize(EventEnvelope envelope) throws Exception {
        assert (this.encrypter != null) : "Invalid injection of the encrypter";
        assert (envelope != null) : "Parameter 'envelope' must not be null";
        this.encrypter.decrypt(envelope);
        Map headers = JavaBinaryEventSerializer.fromBytes(envelope.getCustomHeaders(), Map.class);
        assert (headers != null);
        Class<?> spaceSpec = null;
        String classname = (String)headers.get("x-java-spacespec-class");
        if (classname != null) {
            try {
                spaceSpec = Class.forName(classname);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (spaceSpec == null || !SpaceSpecification.class.isAssignableFrom(spaceSpec)) {
            throw new ClassCastException(Locale.getString((String)"INVALID_TYPE", (Object[])new Object[]{spaceSpec}));
        }
        UUID contextId = NetworkUtil.fromByteArray(envelope.getContextId());
        UUID spaceId = NetworkUtil.fromByteArray(envelope.getSpaceId());
        SpaceID spaceID = new SpaceID(contextId, spaceId, spaceSpec);
        Event event = JavaBinaryEventSerializer.fromBytes(envelope.getBody(), Event.class);
        assert (event != null);
        Scope scope = JavaBinaryEventSerializer.fromBytes(envelope.getScope(), Scope.class);
        return new EventDispatch(spaceID, event, scope, headers);
    }

    private static <T> T fromBytes(byte[] data, Class<T> type) throws IOException, ClassNotFoundException {
        Throwable throwable = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            ObjectInputStream oos = new ObjectInputStream(bais);
            Object object = oos.readObject();
            if (object != null && type.isInstance(object)) {
                T t = type.cast(object);
                return t;
            }
            try {
                throw new ClassCastException(Locale.getString((String)"INVALID_TYPE", (Object[])new Object[]{type.getName()}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

