/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.kerneldiscovery;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.AsyncStateService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryServiceListener;
import io.janusproject.services.network.NetworkService;
import io.janusproject.util.TwoStepConstruction;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@Singleton
@TwoStepConstruction
public class StandardKernelDiscoveryService
extends AbstractDependentService
implements KernelDiscoveryService,
AsyncStateService {
    private URI localURI;
    private boolean isReady;
    private NetworkService network;

    @Inject
    void postConstruction(NetworkService networkService, ExecutorService executorService) {
        this.network = networkService;
        this.network.addListener(new NetworkStartListener(), executorService.getExecutorService());
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(ExecutorService.class);
    }

    @Override
    public boolean isReadyForOtherServices() {
        return this.isRunning() && this.isReady;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return KernelDiscoveryService.class;
    }

    @Override
    public URI getCurrentKernel() {
        return this.localURI;
    }

    @Override
    public synchronized Collection<URI> getKernels() {
        ArrayList<URI> col = new ArrayList<URI>();
        col.add(this.localURI);
        return col;
    }

    @Override
    public void addKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
    }

    @Override
    public void removeKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
    }

    protected synchronized void doStart() {
        this.notifyStarted();
    }

    protected synchronized void doStop() {
        this.isReady = false;
        this.notifyStopped();
    }

    private class NetworkStartListener
    extends Service.Listener {
        NetworkStartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void running() {
            URI uri = StandardKernelDiscoveryService.this.network.getURI();
            if (StandardKernelDiscoveryService.this.localURI == null) {
                StandardKernelDiscoveryService standardKernelDiscoveryService = StandardKernelDiscoveryService.this;
                synchronized (standardKernelDiscoveryService) {
                    StandardKernelDiscoveryService.this.localURI = uri;
                    StandardKernelDiscoveryService.this.isReady = true;
                }
            }
        }
    }
}

