/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.Initialize;
import io.sarl.lang.core.Agent;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.arakhne.afc.vmutil.locale.Locale;

@Singleton
public class JdkUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler,
SubscriberExceptionHandler {
    private final LogService logger;
    @Inject
    private SpawnService spawnService;

    @Inject
    public JdkUncaughtExceptionHandler(LogService logger) {
        assert (logger != null);
        this.logger = logger;
    }

    private void log(Throwable exception, String taskId, String taskName) {
        LogRecord record;
        Throwable cause;
        assert (exception != null);
        for (cause = exception; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
        }
        if (cause instanceof ChuckNorrisException || exception instanceof ChuckNorrisException) {
            return;
        }
        if (cause instanceof CancellationException || exception instanceof CancellationException) {
            if (!this.logger.isLoggeable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, Locale.getString((String)"CANCEL_TASK", (Object[])new Object[]{taskId, taskName}));
        } else if (cause instanceof InterruptedException || exception instanceof InterruptedException) {
            if (!this.logger.isLoggeable(Level.FINEST)) {
                return;
            }
            record = new LogRecord(Level.FINEST, Locale.getString((String)"INTERRUPT_TASK", (Object[])new Object[]{taskId, taskName}));
        } else {
            if (!this.logger.isLoggeable(Level.SEVERE)) {
                return;
            }
            record = new LogRecord(Level.SEVERE, Locale.getString((String)"UNCAUGHT_EXCEPTION", (Object[])new Object[]{cause.getLocalizedMessage(), taskId, taskName}));
        }
        record.setThrown(cause);
        StackTraceElement[] trace = cause.getStackTrace();
        if (trace != null && trace.length > 0) {
            StackTraceElement elt = trace[0];
            assert (elt != null);
            record.setSourceClassName(elt.getClassName());
            record.setSourceMethodName(elt.getMethodName());
        }
        this.logger.log(record);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        this.log(exception, Long.toString(thread.getId()), thread.getName());
    }

    public boolean isAutoKillEvent(Object object) {
        return object instanceof Initialize;
    }

    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        this.log(exception, context.getEventBus().toString(), context.getEvent().toString());
        if (this.isAutoKillEvent(context.getEvent())) {
            Agent caller = (Agent)context.getSubscriber();
            try {
                this.spawnService.killAgent(caller.getID());
            }
            catch (Exception e) {
                this.log(e, context.getEventBus().toString(), context.getEvent().toString());
            }
        }
    }
}

