/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.inject.Inject;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.services.jdk.executors.JdkExecutorUtil;
import io.janusproject.kernel.services.jdk.executors.JdkJanusFutureTask;
import io.janusproject.kernel.services.jdk.executors.JdkTaskListener;
import io.janusproject.util.ListenerCollection;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JdkThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final long TIMEOUT = 60L;
    private ListenerCollection<JdkTaskListener> listeners;

    @Inject
    public JdkThreadPoolExecutor(ThreadFactory factory) {
        this(JanusConfig.getSystemPropertyAsInteger("janus.executors.threads.max", 50), factory);
    }

    public JdkThreadPoolExecutor(int poolSize, ThreadFactory factory) {
        super(poolSize, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory);
    }

    public synchronized void addTaskListener(JdkTaskListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerCollection();
        }
        this.listeners.add(JdkTaskListener.class, listener);
    }

    public synchronized void removeTaskListener(JdkTaskListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(JdkTaskListener.class, listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTaskFinished(Thread thread, Runnable task) {
        JdkTaskListener[] jdkTaskListenerArray = this;
        synchronized (this) {
            if (this.listeners == null) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            JdkTaskListener[] listeners = (JdkTaskListener[])this.listeners.getListeners(JdkTaskListener.class);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (JdkTaskListener listener : listeners) {
                listener.taskFinished(thread, task);
            }
            return;
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new JdkJanusFutureTask<T>(callable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new JdkJanusFutureTask<T>(runnable, value);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        if (runnable instanceof JdkJanusFutureTask) {
            ((JdkJanusFutureTask)runnable).setThread(thread);
        }
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        Thread th;
        JdkJanusFutureTask task;
        if (runnable instanceof JdkJanusFutureTask) {
            task = (JdkJanusFutureTask)runnable;
            th = task.getThread();
        } else {
            task = null;
            th = Thread.currentThread();
        }
        if (throwable != null && task != null) {
            JdkExecutorUtil.log(th, throwable);
        }
        this.fireTaskFinished(th, runnable);
    }
}

