/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import io.janusproject.kernel.services.jdk.executors.JdkExecutorUtil;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.services.executor.JanusScheduledFutureTask;
import java.lang.ref.WeakReference;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class JdkJanusScheduledFutureTask<V>
implements JanusScheduledFutureTask<V> {
    private final AtomicBoolean treated = new AtomicBoolean(false);
    private final RunnableScheduledFuture<V> task;
    private WeakReference<Thread> thread;

    JdkJanusScheduledFutureTask(RunnableScheduledFuture<V> task) {
        assert (task != null);
        this.task = task;
    }

    public String toString() {
        return "[ " + this.task + " ] ON [ " + this.getThread() + " ]";
    }

    synchronized void setThread(Thread thread) {
        this.thread = thread == null ? null : new WeakReference<Thread>(thread);
    }

    void reportException(Thread thread) {
        block5: {
            try {
                this.task.get();
            }
            catch (ExecutionException e) {
                Throwable ex = e;
                while (ex instanceof ExecutionException) {
                    ex = e.getCause();
                }
                if (!(ex instanceof ChuckNorrisException) && !this.treated.getAndSet(true)) {
                    JdkExecutorUtil.log(thread, ex);
                }
            }
            catch (InterruptedException | CancellationException e) {
                if (this.treated.getAndSet(true)) break block5;
                JdkExecutorUtil.log(thread, e);
            }
        }
    }

    @Override
    public synchronized Thread getThread() {
        return this.thread == null ? null : (Thread)this.thread.get();
    }

    @Override
    public boolean isCurrentThread() {
        return Thread.currentThread() == this.getThread();
    }

    @Override
    public void run() {
        this.task.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.task.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.task.get();
        }
        catch (ExecutionException e) {
            Throwable ex = e;
            while (ex instanceof ExecutionException) {
                ex = e.getCause();
            }
            if (ex instanceof ChuckNorrisException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.task.get(timeout, unit);
        }
        catch (ExecutionException e) {
            Throwable ex = e;
            while (ex instanceof ExecutionException) {
                ex = e.getCause();
            }
            if (ex instanceof ChuckNorrisException) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.task.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed delayed) {
        return this.task.compareTo(delayed);
    }

    @Override
    public boolean isPeriodic() {
        return this.task.isPeriodic();
    }
}

