/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.executors;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.janusproject.JanusConfig;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.executor.ExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Singleton
public class JdkExecutorService
extends AbstractDependentService
implements ExecutorService {
    private ScheduledExecutorService schedules;
    private java.util.concurrent.ExecutorService exec;
    private ScheduledFuture<?> purgeTask;

    @Inject
    void setScheduledExecutorService(ScheduledExecutorService service) {
        this.schedules = service;
    }

    @Inject
    void setExecutorService(java.util.concurrent.ExecutorService service) {
        this.exec = service;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return ExecutorService.class;
    }

    protected void doStart() {
        assert (this.schedules != null);
        assert (this.exec != null);
        if (this.schedules instanceof ThreadPoolExecutor || this.exec instanceof ThreadPoolExecutor) {
            int delay = JanusConfig.getSystemPropertyAsInteger("janus.executors.purgeDelay", 30);
            this.purgeTask = this.schedules.scheduleWithFixedDelay(new Purger(), delay, delay, TimeUnit.SECONDS);
        }
        this.notifyStarted();
    }

    protected void doStop() {
        if (this.purgeTask != null) {
            this.purgeTask.cancel(true);
            this.purgeTask = null;
        }
        this.exec.shutdown();
        this.schedules.shutdown();
        try {
            int timeout = JanusConfig.getSystemPropertyAsInteger("janus.executors.timeout", 30);
            this.schedules.awaitTermination(timeout, TimeUnit.SECONDS);
            this.exec.awaitTermination(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.schedules.shutdownNow();
            this.exec.shutdownNow();
            this.notifyStopped();
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.exec.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.exec.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.exec.submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedules.schedule(command, delay, unit);
    }

    @Override
    public <T> ScheduledFuture<T> schedule(Callable<T> command, long delay, TimeUnit unit) {
        return this.schedules.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.schedules.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.schedules.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public java.util.concurrent.ExecutorService getExecutorService() {
        return this.exec;
    }

    @Override
    public void purge() {
        if (this.exec instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.exec).purge();
        }
        if (this.schedules instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)((Object)this.schedules)).purge();
        }
    }

    private class Purger
    implements Runnable {
        private String oldThreadName;

        Purger() {
        }

        private boolean setName() {
            if (this.oldThreadName != null) {
                return false;
            }
            Thread t = Thread.currentThread();
            this.oldThreadName = t.getName();
            t.setName(this.toString());
            return true;
        }

        private boolean restoreName() {
            if (this.oldThreadName == null) {
                return false;
            }
            Thread t = Thread.currentThread();
            t.setName(this.oldThreadName);
            this.oldThreadName = null;
            return true;
        }

        @Override
        public void run() {
            assert (this.setName());
            try {
                JdkExecutorService.this.purge();
            }
            finally {
                assert (this.restoreName());
            }
        }

        public String toString() {
            return "Janus Thread Purger";
        }
    }
}

