/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.janusproject.kernel.services.jdk.contextspace.Context;
import io.janusproject.kernel.services.jdk.contextspace.ContextFactory;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepositoryFactory;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.contextspace.ContextRepositoryListener;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.util.ListenerCollection;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.Collections3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

@Singleton
@TwoStepConstruction
public class StandardContextSpaceService
extends AbstractDependentService
implements ContextSpaceService {
    private final ListenerCollection<?> listeners = new ListenerCollection();
    private ContextFactory contextFactory;
    private SpaceRepositoryFactory spaceRepositoryFactory;
    private DMap<UUID, SpaceID> defaultSpaces;
    private Map<UUID, AgentContext> contexts = new TreeMap<UUID, AgentContext>();
    private ContextDMapListener dmapListener;
    private LogService logger;

    @Override
    public final Class<? extends Service> getServiceType() {
        return ContextSpaceService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(DistributedDataStructureService.class, NetworkService.class, KernelDiscoveryService.class);
    }

    ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    void setContextFactory(ContextFactory factory) {
        if (factory != null) {
            this.contextFactory = factory;
        }
    }

    SpaceRepositoryFactory getSpaceRepositoryFactory() {
        return this.spaceRepositoryFactory;
    }

    void setSpaceRepositoryFactory(SpaceRepositoryFactory factory) {
        if (factory != null) {
            this.spaceRepositoryFactory = factory;
        }
    }

    @Override
    public final Object mutex() {
        return this;
    }

    @Inject
    synchronized void postConstruction(@Named(value="janus.context.id") UUID janusID, DistributedDataStructureService dataStructureService, LogService logService, Injector injector) {
        this.logger = logService;
        this.contextFactory = new DefaultContextFactory();
        this.spaceRepositoryFactory = new Context.DefaultSpaceRepositoryFactory(injector, dataStructureService, logService);
        this.defaultSpaces = dataStructureService.getMap(janusID.toString(), null);
    }

    @Override
    public synchronized boolean isEmptyContextRepository() {
        return this.contexts.isEmpty();
    }

    @Override
    public synchronized int getNumberOfContexts() {
        return this.contexts.size();
    }

    @Override
    public synchronized boolean containsContext(UUID contextID) {
        return this.contexts.containsKey(contextID);
    }

    @Override
    public synchronized AgentContext createContext(UUID contextID, UUID defaultSpaceUUID) {
        assert (contextID != null) : "The contextID cannot be null";
        assert (defaultSpaceUUID != null) : "The defaultSpaceUUID cannot be null";
        assert (this.contexts != null) : "Internal Error: the context container must not be null";
        AgentContext context = this.contexts.get(contextID);
        if (context == null) {
            Context ctx = this.contextFactory.newInstance(contextID, defaultSpaceUUID, this.spaceRepositoryFactory, new SpaceEventProxy());
            assert (ctx != null) : "The internal Context cannot be null";
            assert (this.contexts != null) : "Internal Error: the context container must not be null";
            this.contexts.put(contextID, ctx);
            this.fireContextCreated(ctx);
            EventSpace defaultSpace = ctx.postConstruction();
            assert (defaultSpace != null) : "The default space in the context " + contextID + " cannot be null";
            this.defaultSpaces.putIfAbsent(ctx.getID(), defaultSpace.getID());
            return ctx;
        }
        return context;
    }

    @Override
    public final void removeContext(AgentContext context) {
        this.removeContext(context.getID());
    }

    @Override
    public synchronized void removeContext(UUID contextID) {
        this.defaultSpaces.remove(contextID);
        AgentContext context = this.contexts.remove(contextID);
        if (context != null) {
            ((Context)context).destroy();
            this.fireContextDestroyed(context);
        }
    }

    @Override
    public synchronized Collection<AgentContext> getContexts() {
        return Collections.unmodifiableCollection(Collections3.synchronizedCollection(this.contexts.values(), (Object)this.mutex()));
    }

    @Override
    public synchronized Collection<AgentContext> getContexts(final Collection<UUID> contextIDs) {
        return Collections2.filter(this.contexts.values(), (Predicate)new Predicate<AgentContext>(){

            public boolean apply(AgentContext input) {
                return contextIDs.contains(input.getID());
            }
        });
    }

    @Override
    public synchronized Set<UUID> getContextIDs() {
        return Collections.unmodifiableSet(Collections3.synchronizedSet(this.contexts.keySet(), (Object)this.mutex()));
    }

    @Override
    public synchronized AgentContext getContext(UUID contextID) {
        return this.contexts.get(contextID);
    }

    @Override
    public void addContextRepositoryListener(ContextRepositoryListener listener) {
        this.listeners.add(ContextRepositoryListener.class, listener);
    }

    @Override
    public void removeContextRepositoryListener(ContextRepositoryListener listener) {
        this.listeners.remove(ContextRepositoryListener.class, listener);
    }

    protected void fireContextCreated(AgentContext context) {
        ContextRepositoryListener[] ilisteners = (ContextRepositoryListener[])this.listeners.getListeners(ContextRepositoryListener.class);
        this.logger.info(StandardContextSpaceService.class, "CONTEXT_CREATED", context.getID());
        for (ContextRepositoryListener listener : ilisteners) {
            listener.contextCreated(context);
        }
    }

    protected void fireContextDestroyed(AgentContext context) {
        ContextRepositoryListener[] ilisteners = (ContextRepositoryListener[])this.listeners.getListeners(ContextRepositoryListener.class);
        this.logger.info(StandardContextSpaceService.class, "CONTEXT_DESTROYED", context.getID());
        for (ContextRepositoryListener listener : ilisteners) {
            listener.contextDestroyed(context);
        }
    }

    @Override
    public void addSpaceRepositoryListener(SpaceRepositoryListener listener) {
        this.listeners.add(SpaceRepositoryListener.class, listener);
    }

    @Override
    public void removeSpaceRepositoryListener(SpaceRepositoryListener listener) {
        this.listeners.remove(SpaceRepositoryListener.class, listener);
    }

    protected void fireSpaceCreated(Space space, boolean isLocalCreation) {
        for (SpaceRepositoryListener listener : (SpaceRepositoryListener[])this.listeners.getListeners(SpaceRepositoryListener.class)) {
            listener.spaceCreated(space, isLocalCreation);
        }
    }

    protected void fireSpaceDestroyed(Space space, boolean isLocalDestruction) {
        for (SpaceRepositoryListener listener : (SpaceRepositoryListener[])this.listeners.getListeners(SpaceRepositoryListener.class)) {
            listener.spaceDestroyed(space, isLocalDestruction);
        }
    }

    protected synchronized void ensureDefaultSpaceDefinition(SpaceID spaceID) {
        UUID contextID = spaceID.getContextID();
        this.createContext(contextID, spaceID.getID());
    }

    protected synchronized void removeDefaultSpaceDefinition(SpaceID spaceID) {
        AgentContext context = this.contexts.remove(spaceID.getContextID());
        if (context != null) {
            this.fireContextDestroyed(context);
        }
    }

    protected synchronized void doStart() {
        for (SpaceID space : this.defaultSpaces.values()) {
            this.ensureDefaultSpaceDefinition(space);
        }
        this.dmapListener = new ContextDMapListener();
        this.defaultSpaces.addDMapListener(this.dmapListener);
        this.notifyStarted();
    }

    protected synchronized void doStop() {
        if (this.dmapListener != null) {
            this.defaultSpaces.removeDMapListener(this.dmapListener);
        }
        Map<UUID, AgentContext> old = this.contexts;
        this.contexts = new TreeMap<UUID, AgentContext>();
        for (AgentContext context : old.values()) {
            ((Context)context).destroy();
            this.fireContextDestroyed(context);
        }
        this.notifyStopped();
    }

    private static class DefaultContextFactory
    implements ContextFactory {
        DefaultContextFactory() {
        }

        @Override
        public Context newInstance(UUID contextId, UUID defaultSpaceId, SpaceRepositoryFactory factory, SpaceRepositoryListener listener) {
            return new Context(contextId, defaultSpaceId, factory, listener);
        }
    }

    private class SpaceEventProxy
    implements SpaceRepositoryListener {
        SpaceEventProxy() {
        }

        @Override
        public void spaceCreated(Space space, boolean isLocalCreation) {
            StandardContextSpaceService.this.fireSpaceCreated(space, isLocalCreation);
        }

        @Override
        public void spaceDestroyed(Space space, boolean isLocalDestruction) {
            StandardContextSpaceService.this.fireSpaceDestroyed(space, isLocalDestruction);
        }
    }

    private class ContextDMapListener
    implements DMapListener<UUID, SpaceID> {
        ContextDMapListener() {
        }

        @Override
        public void entryAdded(UUID key, SpaceID value) {
            assert (value != null);
            StandardContextSpaceService.this.ensureDefaultSpaceDefinition(value);
        }

        @Override
        public void entryRemoved(UUID key, SpaceID value) {
            assert (value != null);
            StandardContextSpaceService.this.removeDefaultSpaceDefinition(value);
        }

        @Override
        public void entryUpdated(UUID key, SpaceID value) {
        }

        @Override
        public void mapCleared(boolean localClearing) {
            throw new UnsupportedOperationException();
        }
    }
}

