/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.inject.Injector;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.Collections3;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.arakhne.afc.vmutil.ClassComparator;
import org.arakhne.afc.vmutil.ObjectReferenceComparator;

@TwoStepConstruction
class SpaceRepository {
    private static final Object[] NO_PARAMETERS = new Object[0];
    private final String distributedSpaceSetName;
    private final Injector injector;
    private SpaceDMapListener internalListener;
    private final SpaceRepositoryListener externalListener;
    private final DMap<SpaceID, Object[]> spaceIDs;
    private final Map<SpaceID, Space> spaces;
    private final Multimap<Class<? extends SpaceSpecification<?>>, SpaceID> spacesBySpec;

    SpaceRepository(String distributedSpaceSetName, DistributedDataStructureService distributedDataStructureService, Injector injector, SpaceRepositoryListener listener) {
        this.distributedSpaceSetName = distributedSpaceSetName;
        this.injector = injector;
        this.externalListener = listener;
        this.spaces = new TreeMap<SpaceID, Space>();
        this.spacesBySpec = TreeMultimap.create((Comparator)ClassComparator.SINGLETON, (Comparator)ObjectReferenceComparator.SINGLETON);
        this.spaceIDs = distributedDataStructureService.getMap(this.distributedSpaceSetName, null);
    }

    synchronized void postConstruction() {
        for (Map.Entry e : this.spaceIDs.entrySet()) {
            assert (this.spaceIDs.containsKey(e.getKey()));
            this.ensureLocalSpaceDefinition((SpaceID)e.getKey(), (Object[])e.getValue());
        }
        this.internalListener = new SpaceDMapListener();
        this.spaceIDs.addDMapListener(this.internalListener);
    }

    public synchronized void destroy() {
        if (this.internalListener != null) {
            this.spaceIDs.removeDMapListener(this.internalListener);
        }
        ArrayList ids = new ArrayList(this.spaceIDs.keySet());
        this.spaceIDs.clear();
        for (SpaceID spaceId : ids) {
            this.removeLocalSpaceDefinition(spaceId, true);
        }
    }

    private synchronized <S extends Space> S createSpaceInstance(Class<? extends SpaceSpecification<S>> spec, SpaceID spaceID, boolean isLocalCreation, Object[] creationParams) {
        assert (spaceID.getSpaceSpecification() == null || spaceID.getSpaceSpecification().equals(spec)) : "The specification type is invalid";
        Space space = creationParams != null && creationParams.length > 0 ? ((SpaceSpecification)this.injector.getInstance(spec)).create(spaceID, creationParams) : ((SpaceSpecification)this.injector.getInstance(spec)).create(spaceID, new Object[0]);
        assert (space != null);
        SpaceID id = space.getID();
        assert (id != null);
        this.spaces.put(id, space);
        this.spacesBySpec.put((Object)id.getSpaceSpecification(), (Object)id);
        if (isLocalCreation) {
            Object[] sharedParams = NO_PARAMETERS;
            if (creationParams != null && creationParams.length > 0) {
                ArrayList<Object> serializableParameters = new ArrayList<Object>(creationParams.length);
                for (Object creationParameter : creationParams) {
                    if (!(creationParameter instanceof Serializable)) continue;
                    serializableParameters.add(creationParameter);
                }
                if (!serializableParameters.isEmpty()) {
                    sharedParams = serializableParameters.toArray();
                }
            }
            this.spaceIDs.putIfAbsent(id, sharedParams);
        }
        this.fireSpaceAdded(space, isLocalCreation);
        return (S)space;
    }

    protected synchronized void ensureLocalSpaceDefinition(SpaceID id, Object[] initializationParameters) {
        if (!this.spaces.containsKey(id)) {
            this.createSpaceInstance(id.getSpaceSpecification(), id, false, initializationParameters);
        }
    }

    protected synchronized void removeLocalSpaceDefinition(SpaceID id, boolean isLocalDestruction) {
        Space space = this.spaces.remove(id);
        if (space != null) {
            this.spacesBySpec.remove((Object)id.getSpaceSpecification(), (Object)id);
            this.fireSpaceRemoved(space, isLocalDestruction);
        }
    }

    protected synchronized void removeLocalSpaceDefinitions(boolean isLocalDestruction) {
        if (!this.spaces.isEmpty()) {
            ArrayList<Space> removedSpaces = new ArrayList<Space>(this.spaces.size());
            Iterator<Map.Entry<SpaceID, Space>> iterator = this.spaces.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<SpaceID, Space> entry = iterator.next();
                SpaceID id = entry.getKey();
                Space space = entry.getValue();
                iterator.remove();
                this.spacesBySpec.remove((Object)id.getSpaceSpecification(), (Object)id);
                removedSpaces.add(space);
            }
            for (Space s : removedSpaces) {
                this.fireSpaceRemoved(s, isLocalDestruction);
            }
        }
    }

    public synchronized <S extends Space> S createSpace(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        if (!this.spaces.containsKey(spaceID)) {
            return this.createSpaceInstance(spec, spaceID, true, creationParams);
        }
        return null;
    }

    public synchronized <S extends Space> S getOrCreateSpaceWithSpec(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        Collection ispaces = this.spacesBySpec.get(spec);
        Object firstSpace = ispaces == null || ispaces.isEmpty() ? this.createSpaceInstance(spec, spaceID, true, creationParams) : this.spaces.get(ispaces.iterator().next());
        assert (firstSpace != null);
        return firstSpace;
    }

    public synchronized <S extends Space> S getOrCreateSpaceWithID(SpaceID spaceID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        Object space = this.spaces.get(spaceID);
        if (space == null) {
            space = this.createSpaceInstance(spec, spaceID, true, creationParams);
        }
        assert (space != null);
        return (S)space;
    }

    public synchronized SynchronizedCollection<? extends Space> getSpaces() {
        return Collections3.synchronizedCollection(Collections.unmodifiableCollection(this.spaces.values()), (Object)this);
    }

    public synchronized <S extends Space> SynchronizedCollection<S> getSpaces(final Class<? extends SpaceSpecification<S>> spec) {
        return Collections3.synchronizedCollection((Collection)Collections2.filter(this.spaces.values(), (Predicate)new Predicate<Space>(){

            public boolean apply(Space input) {
                return input.getID().getSpaceSpecification().equals(spec);
            }
        }), (Object)this);
    }

    public synchronized Space getSpace(SpaceID spaceID) {
        return this.spaces.get(spaceID);
    }

    protected void fireSpaceAdded(Space space, boolean isLocalCreation) {
        if (this.externalListener != null) {
            this.externalListener.spaceCreated(space, isLocalCreation);
        }
    }

    protected void fireSpaceRemoved(Space space, boolean isLocalDestruction) {
        if (this.externalListener != null) {
            this.externalListener.spaceDestroyed(space, isLocalDestruction);
        }
    }

    private class SpaceDMapListener
    implements DMapListener<SpaceID, Object[]> {
        SpaceDMapListener() {
        }

        @Override
        public void entryAdded(SpaceID key, Object[] value) {
            assert (SpaceRepository.this.spaceIDs.containsKey(key));
            SpaceRepository.this.ensureLocalSpaceDefinition(key, value);
        }

        @Override
        public void entryRemoved(SpaceID key, Object[] value) {
            assert (!SpaceRepository.this.spaceIDs.containsKey(key));
            SpaceRepository.this.removeLocalSpaceDefinition(key, false);
        }

        @Override
        public void entryUpdated(SpaceID key, Object[] value) {
        }

        @Override
        public void mapCleared(boolean localClearing) {
            SpaceRepository.this.removeLocalSpaceDefinitions(false);
        }
    }
}

