/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.jdk.contextspace;

import com.google.inject.Injector;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepository;
import io.janusproject.kernel.services.jdk.contextspace.SpaceRepositoryFactory;
import io.janusproject.services.contextspace.SpaceRepositoryListener;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.TwoStepConstruction;
import io.sarl.core.SpaceCreated;
import io.sarl.core.SpaceDestroyed;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.core.SpaceSpecification;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.OpenEventSpace;
import io.sarl.util.OpenEventSpaceSpecification;
import java.util.UUID;

@TwoStepConstruction
class Context
implements AgentContext {
    private final UUID id;
    private final SpaceRepository spaceRepository;
    private final UUID defaultSpaceID;
    private OpenEventSpace defaultSpace;

    Context(UUID id, UUID defaultSpaceID, SpaceRepositoryFactory factory, SpaceRepositoryListener startUpListener) {
        assert (factory != null);
        this.id = id;
        this.defaultSpaceID = defaultSpaceID;
        this.spaceRepository = factory.newInstance(this, id.toString() + "-spaces", startUpListener);
    }

    public String toString() {
        return this.id.toString();
    }

    EventSpace postConstruction() {
        this.spaceRepository.postConstruction();
        this.defaultSpace = (OpenEventSpace)this.createSpace(OpenEventSpaceSpecification.class, this.defaultSpaceID, new Object[0]);
        if (this.defaultSpace == null) {
            this.defaultSpace = (OpenEventSpace)this.spaceRepository.getSpace(new SpaceID(this.id, this.defaultSpaceID, OpenEventSpaceSpecification.class));
        }
        return this.defaultSpace;
    }

    public void destroy() {
        this.spaceRepository.destroy();
    }

    public UUID getID() {
        return this.id;
    }

    public OpenEventSpace getDefaultSpace() {
        return this.defaultSpace;
    }

    public <S extends Space> SynchronizedCollection<S> getSpaces(Class<? extends SpaceSpecification<S>> spec) {
        return this.spaceRepository.getSpaces(spec);
    }

    public SynchronizedCollection<? extends Space> getSpaces() {
        return this.spaceRepository.getSpaces();
    }

    public <S extends Space> S createSpace(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.spaceRepository.createSpace(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    @Deprecated
    public <S extends Space> S getOrCreateSpace(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.getOrCreateSpaceWithSpec(spec, spaceUUID, creationParams);
    }

    public <S extends Space> S getOrCreateSpaceWithSpec(Class<? extends SpaceSpecification<S>> spec, UUID spaceUUID, Object ... creationParams) {
        return this.spaceRepository.getOrCreateSpaceWithSpec(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    public <S extends Space> S getOrCreateSpaceWithID(UUID spaceUUID, Class<? extends SpaceSpecification<S>> spec, Object ... creationParams) {
        return this.spaceRepository.getOrCreateSpaceWithID(new SpaceID(this.id, spaceUUID, spec), spec, creationParams);
    }

    public <S extends Space> S getSpace(UUID spaceUUID) {
        return (S)this.spaceRepository.getSpace(new SpaceID(this.id, spaceUUID, null));
    }

    public static class DefaultSpaceRepositoryFactory
    implements SpaceRepositoryFactory {
        private final DistributedDataStructureService dataStructureService;
        private final Injector injector;
        private final LogService logger;

        DefaultSpaceRepositoryFactory(Injector injector, DistributedDataStructureService distributedDataStructure, LogService logger) {
            this.dataStructureService = distributedDataStructure;
            this.injector = injector;
            this.logger = logger;
        }

        @Override
        public final SpaceRepository newInstance(Context context, String distributedSpaceSetName, SpaceRepositoryListener listener) {
            return this.newInstanceWithPrivateSpaceListener(context, distributedSpaceSetName, new SpaceListener(context, this.logger, listener));
        }

        protected SpaceRepository newInstanceWithPrivateSpaceListener(Context context, String distributedSpaceSetName, SpaceRepositoryListener listener) {
            return new SpaceRepository(distributedSpaceSetName, this.dataStructureService, this.injector, listener);
        }
    }

    private static class SpaceListener
    implements SpaceRepositoryListener {
        private final Context context;
        private final SpaceRepositoryListener relay;
        private final LogService logger;

        SpaceListener(Context context, LogService logger, SpaceRepositoryListener relay) {
            assert (context != null);
            assert (logger != null);
            assert (relay != null);
            this.context = context;
            this.logger = logger;
            this.relay = relay;
        }

        @Override
        public void spaceCreated(Space space, boolean isLocalCreation) {
            OpenEventSpace defSpace;
            this.logger.info(Context.class, "SPACE_CREATED", space.getID());
            this.relay.spaceCreated(space, isLocalCreation);
            if (isLocalCreation && (defSpace = this.context.getDefaultSpace()) != null) {
                defSpace.emit((Event)new SpaceCreated(new Address(defSpace.getID(), this.context.getID()), space.getID()));
            }
        }

        @Override
        public void spaceDestroyed(Space space, boolean isLocalDestruction) {
            OpenEventSpace defSpace;
            this.logger.info(Context.class, "SPACE_DESTROYED", space.getID());
            if (isLocalDestruction && (defSpace = this.context.getDefaultSpace()) != null) {
                defSpace.emit((Event)new SpaceDestroyed(new Address(defSpace.getID(), this.context.getID()), space.getID()));
            }
            this.relay.spaceDestroyed(space, isLocalDestruction);
        }
    }
}

