/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.hazelcast;

import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.MapListener;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.AsyncStateService;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryService;
import io.janusproject.services.kerneldiscovery.KernelDiscoveryServiceListener;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.network.NetworkService;
import io.janusproject.services.network.NetworkUtil;
import io.janusproject.util.ListenerCollection;
import io.janusproject.util.TwoStepConstruction;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

@Singleton
@TwoStepConstruction
public class HazelcastKernelDiscoveryService
extends AbstractDependentService
implements KernelDiscoveryService,
AsyncStateService {
    private final UUID janusID;
    private URI currentPubURI;
    private URI currentHzURI;
    private IMap<URI, URI> kernels;
    private boolean isReady;
    private String hzRegId1;
    private String hzRegId2;
    private NetworkService network;
    private LogService logger;
    private ExecutorService executorService;
    private final ListenerCollection<KernelDiscoveryServiceListener> listeners = new ListenerCollection();
    private HazelcastInstance hazelcastInstance;
    private final HazelcastListener hzListener = new HazelcastListener();
    private NetworkStartListener networkStartListener = new NetworkStartListener();

    @Inject
    public HazelcastKernelDiscoveryService(@Named(value="janus.context.id") UUID janusID) {
        this.janusID = janusID;
    }

    @Override
    public boolean isReadyForOtherServices() {
        return this.isRunning() && this.isReady;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return KernelDiscoveryService.class;
    }

    @Override
    public Collection<Class<? extends Service>> getServiceDependencies() {
        return Arrays.asList(LogService.class, ExecutorService.class);
    }

    @Inject
    void postConstruction(HazelcastInstance hazelcastInstance, NetworkService networkService, ExecutorService executorService, LogService logger) {
        this.executorService = executorService;
        this.hazelcastInstance = hazelcastInstance;
        this.logger = logger;
        this.network = networkService;
        this.kernels = hazelcastInstance.getMap(this.janusID.toString() + "-kernels");
        this.network.addListener(this.networkStartListener, this.executorService.getExecutorService());
    }

    @Override
    public URI getCurrentKernel() {
        return this.currentPubURI;
    }

    @Override
    public synchronized Collection<URI> getKernels() {
        return new ArrayList<URI>(this.kernels.values());
    }

    @Override
    public void addKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
        this.listeners.add(KernelDiscoveryServiceListener.class, listener);
    }

    @Override
    public void removeKernelDiscoveryServiceListener(KernelDiscoveryServiceListener listener) {
        this.listeners.remove(KernelDiscoveryServiceListener.class, listener);
    }

    protected void fireKernelDiscovered(URI uri) {
        this.logger.info(HazelcastKernelDiscoveryService.class, "KERNEL_DISCOVERY", uri, this.getCurrentKernel());
        for (KernelDiscoveryServiceListener listener : (KernelDiscoveryServiceListener[])this.listeners.getListeners(KernelDiscoveryServiceListener.class)) {
            listener.kernelDiscovered(uri);
        }
    }

    protected void fireKernelDisconnected(URI uri) {
        this.logger.info(HazelcastKernelDiscoveryService.class, "KERNEL_DISCONNECTION", uri, this.getCurrentKernel());
        for (KernelDiscoveryServiceListener listener : (KernelDiscoveryServiceListener[])this.listeners.getListeners(KernelDiscoveryServiceListener.class)) {
            listener.kernelDisconnected(uri);
        }
    }

    protected synchronized void doStart() {
        this.hzRegId1 = this.kernels.addEntryListener((MapListener)this.hzListener, true);
        this.hzRegId2 = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this.hzListener);
        this.notifyStarted();
    }

    protected synchronized void doStop() {
        this.isReady = false;
        if (this.hzRegId1 != null) {
            this.kernels.removeEntryListener(this.hzRegId1);
        }
        if (this.hzRegId2 != null) {
            this.hazelcastInstance.getClientService().removeClientListener(this.hzRegId2);
        }
        if (this.currentHzURI != null) {
            this.kernels.remove((Object)this.currentHzURI);
        }
        this.network = null;
        this.notifyStopped();
    }

    private class NetworkStartListener
    extends Service.Listener {
        NetworkStartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void running() {
            URI uri = HazelcastKernelDiscoveryService.this.network.getURI();
            if (HazelcastKernelDiscoveryService.this.currentPubURI == null) {
                Object object = HazelcastKernelDiscoveryService.this;
                synchronized (object) {
                    HazelcastKernelDiscoveryService.this.currentPubURI = uri;
                    HazelcastKernelDiscoveryService.this.currentHzURI = NetworkUtil.toURI(HazelcastKernelDiscoveryService.this.hazelcastInstance.getCluster().getLocalMember().getSocketAddress());
                }
                for (URI remotePublicKernel : HazelcastKernelDiscoveryService.this.getKernels()) {
                    HazelcastKernelDiscoveryService.this.fireKernelDiscovered(remotePublicKernel);
                }
                object = HazelcastKernelDiscoveryService.this;
                synchronized (object) {
                    HazelcastKernelDiscoveryService.this.isReady = true;
                    HazelcastKernelDiscoveryService.this.kernels.putIfAbsent((Object)HazelcastKernelDiscoveryService.this.currentHzURI, (Object)HazelcastKernelDiscoveryService.this.currentPubURI);
                }
            }
        }
    }

    private class HazelcastListener
    implements MembershipListener,
    EntryAddedListener<URI, URI>,
    EntryRemovedListener<URI, URI>,
    EntryEvictedListener<URI, URI> {
        HazelcastListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void memberRemoved(MembershipEvent membershipEvent) {
            URI u;
            InetSocketAddress socketAddress = membershipEvent.getMember().getSocketAddress();
            if (socketAddress != null && (u = NetworkUtil.toURI(socketAddress)) != null) {
                HazelcastKernelDiscoveryService hazelcastKernelDiscoveryService = HazelcastKernelDiscoveryService.this;
                synchronized (hazelcastKernelDiscoveryService) {
                    HazelcastKernelDiscoveryService.this.kernels.remove((Object)u);
                }
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }

        public void entryAdded(EntryEvent<URI, URI> event) {
            URI newPeer = (URI)event.getValue();
            assert (newPeer != null);
            if (!newPeer.equals(HazelcastKernelDiscoveryService.this.getCurrentKernel())) {
                HazelcastKernelDiscoveryService.this.fireKernelDiscovered(newPeer);
            }
        }

        public void entryRemoved(EntryEvent<URI, URI> event) {
            this.fireDisconnected(event);
        }

        public void entryEvicted(EntryEvent<URI, URI> event) {
            this.fireDisconnected(event);
        }

        private void fireDisconnected(EntryEvent<URI, URI> event) {
            URI oldPeer = (URI)event.getValue();
            assert (oldPeer != null);
            if (!oldPeer.equals(HazelcastKernelDiscoveryService.this.getCurrentKernel())) {
                HazelcastKernelDiscoveryService.this.fireKernelDisconnected(oldPeer);
            }
        }
    }
}

