/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.hazelcast;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.distributeddata.DMap;
import io.janusproject.services.distributeddata.DMapListener;
import io.janusproject.services.distributeddata.DMultiMap;
import io.janusproject.services.distributeddata.DistributedDataStructureService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HazelcastDistributedDataStructureService
extends AbstractDependentService
implements DistributedDataStructureService {
    @Inject
    private HazelcastInstance hazelcastInstance;

    @Override
    public final Class<? extends Service> getServiceType() {
        return DistributedDataStructureService.class;
    }

    void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }

    @Override
    public <K, V> DMap<K, V> getMap(String name) {
        IMap map = this.hazelcastInstance.getMap(name);
        if (map != null) {
            return new MapView(name, map);
        }
        return null;
    }

    @Override
    public <K, V> DMap<K, V> getMap(String name, Comparator<? super K> comparator) {
        IMap map = this.hazelcastInstance.getMap(name);
        if (map != null) {
            return new MapView(name, map);
        }
        return null;
    }

    @Override
    public <K, V> DMultiMap<K, V> getMultiMap(String name) {
        MultiMap map = this.hazelcastInstance.getMultiMap(name);
        if (map != null) {
            return new MultiMapView(name, map);
        }
        return null;
    }

    @Override
    public <K, V> DMultiMap<K, V> getMultiMap(String name, Comparator<? super K> comparator) {
        MultiMap map = this.hazelcastInstance.getMultiMap(name);
        if (map != null) {
            return new MultiMapView(name, map);
        }
        return null;
    }

    private static class EntryListenerWrapper<K, V>
    implements EntryListener<K, V> {
        private final DMapListener<? super K, ? super V> dmapListener;
        private String key;

        EntryListenerWrapper(DMapListener<? super K, ? super V> listener) {
            this.dmapListener = listener;
        }

        public String getHazelcastListener() {
            return this.key;
        }

        public void setHazelcastListener(String hazelcastListener) {
            this.key = hazelcastListener;
        }

        public void entryAdded(EntryEvent<K, V> event) {
            this.dmapListener.entryAdded(event.getKey(), event.getValue());
        }

        public void entryEvicted(EntryEvent<K, V> event) {
            if (event.getValue() != null) {
                this.dmapListener.entryRemoved(event.getKey(), event.getValue());
            } else {
                this.dmapListener.entryRemoved(event.getKey(), event.getOldValue());
            }
        }

        public void entryRemoved(EntryEvent<K, V> event) {
            if (event.getValue() != null) {
                this.dmapListener.entryRemoved(event.getKey(), event.getValue());
            } else {
                this.dmapListener.entryRemoved(event.getKey(), event.getOldValue());
            }
        }

        public void entryUpdated(EntryEvent<K, V> event) {
            this.dmapListener.entryUpdated(event.getKey(), event.getValue());
        }

        public void mapCleared(MapEvent event) {
            this.dmapListener.mapCleared(true);
        }

        public void mapEvicted(MapEvent event) {
            this.dmapListener.mapCleared(false);
        }
    }

    private static final class MultiMapView<K, V>
    implements DMultiMap<K, V> {
        private final String name;
        private final MultiMap<K, V> map;

        MultiMapView(String name, MultiMap<K, V> map) {
            this.name = name;
            assert (map != null);
            this.map = map;
        }

        @Override
        public boolean isBackedCollection() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean put(K key, V value) {
            return this.map.put(key, value);
        }

        public Collection<V> get(K key) {
            return this.map.get(key);
        }

        public boolean remove(Object key, Object value) {
            return this.map.remove(key, value);
        }

        public Collection<V> removeAll(Object key) {
            return this.map.remove(key);
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Multiset<K> keys() {
            return new SetMultiset();
        }

        public Collection<V> values() {
            return this.map.values();
        }

        public Collection<Map.Entry<K, V>> entries() {
            return this.map.entrySet();
        }

        public boolean containsKey(Object key) {
            try {
                return this.map.containsKey(key);
            }
            catch (ClassCastException exception) {
                return false;
            }
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public boolean containsEntry(Object key, Object value) {
            try {
                return this.map.containsEntry(key, value);
            }
            catch (ClassCastException exception) {
                return false;
            }
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }

        @Override
        public int valueCount(K key) {
            return this.map.valueCount(key);
        }

        @Override
        public void addDMapListener(DMapListener<? super K, ? super V> listener) {
            EntryListenerWrapper<K, V> w = new EntryListenerWrapper<K, V>(listener);
            String k = this.map.addEntryListener(w, true);
            w.setHazelcastListener(k);
        }

        @Override
        public void removeDMapListener(DMapListener<? super K, ? super V> listener) {
            String k;
            if (listener instanceof EntryListenerWrapper && (k = ((EntryListenerWrapper)((Object)listener)).getHazelcastListener()) != null) {
                this.map.removeEntryListener(k);
            }
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            Collection oldValues = this.map.remove(key);
            for (V value : values) {
                this.map.put(key, value);
            }
            return oldValues;
        }

        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            boolean changed = false;
            for (Map.Entry value : multimap.entries()) {
                changed = this.map.put(value.getKey(), value.getValue()) && changed;
            }
            return changed;
        }

        public boolean putAll(K key, Iterable<? extends V> values) {
            boolean changed = false;
            for (V value : values) {
                changed = this.map.put(key, value) && changed;
            }
            return changed;
        }

        public Map<K, Collection<V>> asMap() {
            return Multimaps.asMap((Multimap)this);
        }

        private class SetMultiset
        implements Multiset<K> {
            SetMultiset() {
            }

            public int size() {
                return MultiMapView.this.size();
            }

            public boolean isEmpty() {
                return MultiMapView.this.isEmpty();
            }

            public Object[] toArray() {
                Object[] tab = new Object[MultiMapView.this.size()];
                int i = 0;
                for (Map.Entry e : MultiMapView.this.entries()) {
                    tab[i] = e.getKey();
                    ++i;
                }
                return tab;
            }

            public <T> T[] toArray(T[] array) {
                Object[] tab = array;
                if (tab == null || tab.length < MultiMapView.this.size()) {
                    tab = new Object[MultiMapView.this.size()];
                    int i = 0;
                    for (Map.Entry e : MultiMapView.this.entries()) {
                        tab[i] = e.getKey();
                        ++i;
                    }
                }
                return tab;
            }

            public void clear() {
                MultiMapView.this.clear();
            }

            public int count(Object element) {
                int c = 0;
                for (Map.Entry e : MultiMapView.this.entries()) {
                    if (!Objects.equal((Object)element, e.getKey())) continue;
                    ++c;
                }
                return c;
            }

            public int add(K element, int occurrences) {
                throw new UnsupportedOperationException();
            }

            public boolean add(K element) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object element) {
                Collection values = MultiMapView.this.removeAll(element);
                return values != null && !values.isEmpty();
            }

            public int remove(Object element, int occurrences) {
                if (occurrences < 0) {
                    throw new IllegalArgumentException();
                }
                try {
                    Collection values = MultiMapView.this.get(element);
                    int old = values.size();
                    Iterator iterator = values.iterator();
                    for (int i = 0; i < occurrences && iterator.hasNext(); ++i) {
                        iterator.next();
                        iterator.remove();
                    }
                    return old;
                }
                catch (ClassCastException exception) {
                    return 0;
                }
            }

            public int setCount(K element, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException();
                }
                Collection values = MultiMapView.this.get(element);
                int old = values.size();
                if (count > old) {
                    throw new UnsupportedOperationException();
                }
                try {
                    Iterator iterator = values.iterator();
                    int toRemove = old - count;
                    for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                        iterator.next();
                        iterator.remove();
                    }
                    return old;
                }
                catch (ClassCastException exception) {
                    return 0;
                }
            }

            public boolean setCount(K element, int oldCount, int newCount) {
                if (oldCount < 0 || newCount < 0) {
                    throw new IllegalArgumentException();
                }
                Collection values = MultiMapView.this.get(element);
                int old = values.size();
                if (oldCount == old) {
                    if (newCount > old) {
                        throw new UnsupportedOperationException();
                    }
                    try {
                        Iterator iterator = values.iterator();
                        int toRemove = old - newCount;
                        if (toRemove > 0) {
                            for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                                iterator.next();
                                iterator.remove();
                            }
                            return true;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return false;
            }

            public boolean addAll(Collection<? extends K> collection) {
                throw new UnsupportedOperationException();
            }

            public Set<K> elementSet() {
                return MultiMapView.this.keySet();
            }

            public Set<Multiset.Entry<K>> entrySet() {
                throw new UnsupportedOperationException();
            }

            public Iterator<K> iterator() {
                final Iterator entries = MultiMapView.this.entries().iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((Map.Entry)entries.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        entries.remove();
                    }
                };
            }

            public boolean contains(Object element) {
                return MultiMapView.this.containsKey(element);
            }

            public boolean containsAll(Collection<?> elements) {
                return MultiMapView.this.keySet().containsAll(elements);
            }

            public boolean removeAll(Collection<?> collection) {
                return MultiMapView.this.keySet().removeAll(collection);
            }

            public boolean retainAll(Collection<?> collection) {
                return MultiMapView.this.keySet().retainAll(collection);
            }
        }
    }

    private static final class MapView<K, V>
    implements DMap<K, V> {
        private final String name;
        private final IMap<K, V> map;

        MapView(String name, IMap<K, V> map) {
            assert (map != null);
            this.name = name;
            this.map = map;
        }

        @Override
        public boolean isBackedCollection() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object arg0) {
            return this.map.containsKey(arg0);
        }

        @Override
        public boolean containsValue(Object arg0) {
            return this.map.containsValue(arg0);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public V get(Object arg0) {
            return (V)this.map.get(arg0);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public V put(K arg0, V arg1) {
            return (V)this.map.put(arg0, arg1);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0) {
            this.map.putAll(arg0);
        }

        @Override
        public V remove(Object arg0) {
            return (V)this.map.remove(arg0);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            return (V)this.map.putIfAbsent(key, value);
        }

        @Override
        public void addDMapListener(DMapListener<? super K, ? super V> listener) {
            EntryListenerWrapper<K, V> w = new EntryListenerWrapper<K, V>(listener);
            String k = this.map.addEntryListener(w, true);
            w.setHazelcastListener(k);
        }

        @Override
        public void removeDMapListener(DMapListener<? super K, ? super V> listener) {
            String k;
            if (listener instanceof EntryListenerWrapper && (k = ((EntryListenerWrapper)((Object)listener)).getHazelcastListener()) != null) {
                this.map.removeEntryListener(k);
            }
        }
    }
}

