/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.hazelcast;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.hazelcast.core.MultiMap;
import io.janusproject.util.AbstractDMultiMapView;
import io.janusproject.util.DataViewDelegate;
import io.janusproject.util.MultisetView;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HazelcastDMultiMapView<K, V>
extends AbstractDMultiMapView<K, V>
implements SetMultimap<K, V> {
    private static final long serialVersionUID = -6970650402150118406L;
    private final Multimap<K, V> map;

    public HazelcastDMultiMapView(MultiMap<K, V> map) {
        super(map.getName());
        this.map = new Wrapper<K, V>(map);
    }

    @Override
    public boolean isBackedCollection() {
        return false;
    }

    @Override
    public Multimap<K, V> getDelegatedObject() {
        return this.map;
    }

    @Override
    public boolean equals(Object obj) {
        return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
    }

    @Override
    public int hashCode() {
        return this.getDelegatedObject().hashCode();
    }

    @Override
    public String toString() {
        return this.getDelegatedObject().toString();
    }

    @Override
    public synchronized Set<V> removeAll(Object key) {
        return (Set)super.removeAll(key);
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        return (Set)super.replaceValues(key, values);
    }

    @Override
    public Set<V> get(K key) {
        return (Set)super.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return new EntryCollectionView(this.getDelegatedObject().entries());
    }

    protected class EntryCollectionView
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable,
    DataViewDelegate.Delegator<Collection<Map.Entry<K, V>>> {
        private static final long serialVersionUID = 3746778947439539504L;
        private final Collection<Map.Entry<K, V>> entries;

        public EntryCollectionView(Collection<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @Override
        public Set<Map.Entry<K, V>> getDelegatedObject() {
            return (Set)HazelcastDMultiMapView.this.getDelegatedObject().entries();
        }

        @Override
        public boolean equals(Object obj) {
            return this.getDelegatedObject().equals(DataViewDelegate.undelegate(obj));
        }

        @Override
        public int hashCode() {
            return this.getDelegatedObject().hashCode();
        }

        @Override
        public String toString() {
            return this.getDelegatedObject().toString();
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (this.entries.add(entry)) {
                HazelcastDMultiMapView.this.fireEntryAdded(entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        private class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> iterator;
            private Map.Entry<K, V> entry;

            EntryIterator(Iterator<Map.Entry<K, V>> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = this.iterator.next();
                return this.entry;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                HazelcastDMultiMapView.this.fireEntryRemoved(this.entry.getKey(), this.entry.getValue());
            }
        }
    }

    private static class Wrapper<K, V>
    implements Multimap<K, V> {
        private final MultiMap<K, V> map;
        private Map<K, Collection<V>> mapView;

        Wrapper(MultiMap<K, V> map) {
            this.map = map;
        }

        public boolean equals(Object obj) {
            return this.map.equals(obj);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.size() == 0;
        }

        public boolean containsKey(Object key) {
            try {
                return this.map.containsKey(key);
            }
            catch (ClassCastException exception) {
                return false;
            }
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public boolean containsEntry(Object key, Object value) {
            try {
                return this.map.containsEntry(key, value);
            }
            catch (ClassCastException exception) {
                return false;
            }
        }

        public Collection<V> get(K key) {
            return this.map.get(key);
        }

        public boolean put(K key, V value) {
            if (this.map.put(key, value)) {
                this.mapView = null;
                return true;
            }
            return false;
        }

        public boolean putAll(K key, Iterable<? extends V> values) {
            boolean changed = false;
            for (V value : values) {
                if (!this.map.put(key, value)) continue;
                changed = true;
            }
            if (changed) {
                this.mapView = null;
            }
            return changed;
        }

        public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
            boolean changed = false;
            for (Map.Entry entry : multimap.entries()) {
                if (!this.map.put(entry.getKey(), entry.getValue())) continue;
                changed = true;
            }
            if (changed) {
                this.mapView = null;
            }
            return changed;
        }

        public boolean remove(Object key, Object value) {
            if (this.map.remove(key, value)) {
                this.mapView = null;
                return true;
            }
            return false;
        }

        public Collection<V> removeAll(Object key) {
            this.mapView = null;
            return this.map.remove(key);
        }

        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            this.mapView = null;
            Collection oldValue = this.map.remove(key);
            for (V value : values) {
                this.map.put(key, value);
            }
            return oldValue;
        }

        public void clear() {
            this.map.clear();
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Collection<V> values() {
            return this.map.values();
        }

        public Collection<Map.Entry<K, V>> entries() {
            return this.map.entrySet();
        }

        public Multiset<K> keys() {
            return new MultisetView(this);
        }

        public Map<K, Collection<V>> asMap() {
            if (this.mapView == null) {
                this.mapView = this.createMapView();
            }
            return this.mapView;
        }

        private Map<K, Collection<V>> createMapView() {
            HashMap map = Maps.newHashMap();
            Object oldKey = null;
            Collection oldValues = null;
            for (Map.Entry entry : this.map.entrySet()) {
                Collection values = Objects.equal(entry.getKey(), oldKey) ? oldValues : (Collection)map.get(entry.getKey());
                if (values == null) {
                    values = Lists.newArrayList();
                    map.put(entry.getKey(), values);
                }
                values.add(entry.getValue());
                oldKey = entry.getKey();
                oldValues = values;
            }
            return map;
        }
    }
}

