/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.services.arakhne;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import io.janusproject.services.AbstractDependentService;
import io.janusproject.services.logging.LogService;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.arakhne.afc.vmutil.locale.Locale;

public class ArakhneLocaleLogService
extends AbstractDependentService
implements LogService {
    private Logger logger;
    private LoggerCallerProvider loggerCallerProvider = new StackTraceLoggerCallerProvider();

    public LoggerCallerProvider getLoggerCaller() {
        return this.loggerCallerProvider;
    }

    public void setLoggerCaller(LoggerCallerProvider provider) {
        this.loggerCallerProvider = provider == null ? new StackTraceLoggerCallerProvider() : provider;
    }

    @Override
    public final Class<? extends Service> getServiceType() {
        return LogService.class;
    }

    protected boolean isLogEnabled() {
        return this.state().ordinal() <= Service.State.RUNNING.ordinal();
    }

    private static String getLogRecordText(LoggerCaller caller, Class<?> propertyType, String messageKey, Object ... message) {
        Class<?> propType = propertyType;
        if (propType == null) {
            propType = caller.getPropertyType();
        }
        if (propType == null) {
            throw new IllegalStateException();
        }
        return Locale.getString(propType, (String)messageKey, (Object[])message);
    }

    private static LogRecord createLogRecord(Level level, String text, boolean exception, Object ... message) {
        Throwable realException = null;
        if (exception) {
            for (Object m : message) {
                if (!(m instanceof Throwable)) continue;
                realException = (Throwable)m;
                break;
            }
        }
        LogRecord record = new LogRecord(level, text);
        if (realException != null) {
            record.setThrown(realException);
        }
        return record;
    }

    private synchronized void writeInLog(Level level, boolean exception, Class<?> propertyType, String messageKey, Object ... message) {
        if (this.isLogEnabled() && this.logger.isLoggable(level)) {
            LoggerCaller caller = this.loggerCallerProvider.getLoggerCaller();
            String text = ArakhneLocaleLogService.getLogRecordText(caller, propertyType, messageKey, message);
            LogRecord record = ArakhneLocaleLogService.createLogRecord(level, text, exception, message);
            record.setSourceClassName(caller.getTypeName());
            String methodName = caller.getMethod();
            if (!Strings.isNullOrEmpty((String)methodName)) {
                record.setSourceMethodName(methodName);
            }
            this.logger.log(record);
        }
    }

    @Override
    public synchronized void log(LogRecord record) {
        if (this.isLogEnabled()) {
            this.logger.log(record);
        }
    }

    @Override
    public void log(Level level, Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(level, true, propertyType, messageKey, message);
    }

    @Override
    public void log(Level level, String messageKey, Object ... message) {
        this.writeInLog(level, true, null, messageKey, message);
    }

    @Override
    public void info(String messageKey, Object ... message) {
        this.writeInLog(Level.INFO, false, null, messageKey, message);
    }

    @Override
    public void info(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.INFO, false, propertyType, messageKey, message);
    }

    @Override
    public void fineInfo(String messageKey, Object ... message) {
        this.writeInLog(Level.FINE, false, null, messageKey, message);
    }

    @Override
    public void fineInfo(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.FINE, false, propertyType, messageKey, message);
    }

    @Override
    public void finerInfo(String messageKey, Object ... message) {
        this.writeInLog(Level.FINER, false, null, messageKey, message);
    }

    @Override
    public void finerInfo(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.FINER, false, propertyType, messageKey, message);
    }

    @Override
    public void debug(String messageKey, Object ... message) {
        this.writeInLog(Level.FINEST, true, null, messageKey, message);
    }

    @Override
    public void debug(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.FINEST, true, propertyType, messageKey, message);
    }

    @Override
    public void warning(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.WARNING, true, propertyType, messageKey, message);
    }

    @Override
    public void warning(String messageKey, Object ... message) {
        this.writeInLog(Level.WARNING, true, null, messageKey, message);
    }

    @Override
    public void error(String messageKey, Object ... message) {
        this.writeInLog(Level.SEVERE, true, null, messageKey, message);
    }

    @Override
    public void error(Class<?> propertyType, String messageKey, Object ... message) {
        this.writeInLog(Level.SEVERE, true, propertyType, messageKey, message);
    }

    @Override
    public synchronized Logger getLogger() {
        return this.logger;
    }

    @Override
    @Inject
    public synchronized void setLogger(Logger logger) {
        if (logger != null) {
            this.logger = logger;
        }
    }

    @Override
    public synchronized void setFilter(Filter filter) {
        this.logger.setFilter(filter);
    }

    @Override
    public synchronized Filter getFilter() {
        return this.logger.getFilter();
    }

    @Override
    public boolean isLoggeable(Level level) {
        return this.isLogEnabled() && this.logger.isLoggable(level);
    }

    @Override
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }

    public static class StackTraceLoggerCallerProvider
    implements LoggerCallerProvider {
        private static StackTraceElement getStackTraceElement() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 3; i < stackTrace.length; ++i) {
                try {
                    Class<?> type = Class.forName(stackTrace[i].getClassName());
                    if (type == null || LogService.class.isAssignableFrom(type) || LoggerCallerProvider.class.isAssignableFrom(type)) continue;
                    return stackTrace[i];
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public LoggerCaller getLoggerCaller() {
            StackTraceElement element = StackTraceLoggerCallerProvider.getStackTraceElement();
            if (element != null) {
                try {
                    return new LoggerCaller(Class.forName(element.getClassName()), element.getClassName(), element.getMethodName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class LoggerCaller {
        private final Class<?> type;
        private final String methodName;
        private final String className;

        public LoggerCaller(Class<?> propertyType, String className, String methodName) {
            this.type = propertyType;
            this.className = className;
            this.methodName = methodName;
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public String getTypeName() {
            return this.className;
        }

        public String getMethod() {
            return this.methodName;
        }
    }

    public static interface LoggerCallerProvider {
        public LoggerCaller getLoggerCaller();
    }
}

