/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.janusproject.kernel.Kernel;
import io.janusproject.kernel.bic.BehaviorsSkill;
import io.janusproject.kernel.bic.DefaultContextInteractionsSkill;
import io.janusproject.kernel.bic.ExternalContextAccessSkill;
import io.janusproject.kernel.bic.InnerContextSkill;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.kernel.bic.InternalEventBusSkill;
import io.janusproject.kernel.bic.LifecycleSkill;
import io.janusproject.kernel.bic.LoggingSkill;
import io.janusproject.kernel.bic.MicroKernelCapacity;
import io.janusproject.kernel.bic.MicroKernelSkill;
import io.janusproject.kernel.bic.SchedulesSkill;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.janusproject.services.spawn.SpawnService;
import io.janusproject.services.spawn.SpawnServiceListener;
import io.sarl.core.Behaviors;
import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.Destroy;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.Initialize;
import io.sarl.core.InnerContextAccess;
import io.sarl.core.Lifecycle;
import io.sarl.core.Logging;
import io.sarl.core.Schedules;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.BuiltinCapacitiesProvider;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.OpenEventSpaceSpecification;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StandardBuiltinCapacitiesProvider
implements BuiltinCapacitiesProvider {
    @Inject
    private Injector injector;
    @Inject
    private SpawnService spawnService;
    @Inject
    private ContextSpaceService contextRepository;

    public Map<Class<? extends Capacity>, Skill> getBuiltinCapacities(Agent agent) {
        UUID innerContextID = agent.getID();
        SpaceID innerSpaceID = new SpaceID(innerContextID, UUID.randomUUID(), OpenEventSpaceSpecification.class);
        Address agentAddressInInnerSpace = new Address(innerSpaceID, agent.getID());
        Kernel k = (Kernel)this.injector.getInstance(Kernel.class);
        InternalEventBusSkill eventBusSkill = new InternalEventBusSkill(agent, agentAddressInInnerSpace);
        InnerContextSkill innerContextSkill = new InnerContextSkill(agent, agentAddressInInnerSpace);
        BehaviorsSkill behaviorSkill = new BehaviorsSkill(agent, agentAddressInInnerSpace);
        LifecycleSkill lifecycleSkill = new LifecycleSkill(agent);
        ExternalContextAccessSkill externalContextSkill = new ExternalContextAccessSkill(agent);
        DefaultContextInteractionsSkill interactionSkill = new DefaultContextInteractionsSkill(agent, this.contextRepository.getContext(agent.getParentID()));
        SchedulesSkill scheduleSkill = new SchedulesSkill(agent);
        LoggingSkill loggingSkill = new LoggingSkill(agent);
        this.injector.injectMembers((Object)eventBusSkill);
        this.injector.injectMembers((Object)innerContextSkill);
        this.injector.injectMembers((Object)behaviorSkill);
        this.injector.injectMembers((Object)lifecycleSkill);
        this.injector.injectMembers((Object)externalContextSkill);
        this.injector.injectMembers((Object)interactionSkill);
        this.injector.injectMembers((Object)scheduleSkill);
        this.injector.injectMembers((Object)loggingSkill);
        MicroKernelSkill microKernelSkill = new MicroKernelSkill(agent, k);
        HashMap<Class<? extends Capacity>, Skill> result = new HashMap<Class<? extends Capacity>, Skill>();
        result.put(MicroKernelCapacity.class, microKernelSkill);
        result.put(InternalEventBusCapacity.class, eventBusSkill);
        result.put(InnerContextAccess.class, innerContextSkill);
        result.put(Behaviors.class, behaviorSkill);
        result.put(Lifecycle.class, lifecycleSkill);
        result.put(ExternalContextAccess.class, externalContextSkill);
        result.put(DefaultContextInteractions.class, interactionSkill);
        result.put(Schedules.class, scheduleSkill);
        result.put(Logging.class, loggingSkill);
        this.spawnService.addSpawnServiceListener(agent.getID(), new AgentLifeCycleSupport(agent.getID(), this.spawnService, eventBusSkill, microKernelSkill, innerContextSkill, behaviorSkill, lifecycleSkill, externalContextSkill, interactionSkill, scheduleSkill, loggingSkill));
        assert (result.get(Behaviors.class) != null);
        assert (result.get(DefaultContextInteractions.class) != null);
        assert (result.get(InternalEventBusCapacity.class) != null);
        assert (result.get(ExternalContextAccess.class) != null);
        assert (result.get(InnerContextAccess.class) != null);
        assert (result.get(Lifecycle.class) != null);
        assert (result.get(Schedules.class) != null);
        assert (result.get(MicroKernelCapacity.class) != null);
        assert (result.get(Logging.class) != null);
        return result;
    }

    private static class AgentLifeCycleSupport
    implements SpawnServiceListener {
        private final UUID agentID;
        private final WeakReference<SpawnService> spawnService;
        private final InternalEventBusCapacity eventBusCapacity;
        private final Skill[] skills;

        AgentLifeCycleSupport(UUID agentId, SpawnService spawnService, InternalEventBusCapacity eventBusCapacity, Skill ... skills) {
            this.agentID = agentId;
            this.spawnService = new WeakReference<SpawnService>(spawnService);
            this.eventBusCapacity = eventBusCapacity;
            this.skills = skills;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void agentSpawned(AgentContext parent, Agent agent, Object[] initializationParameters) {
            try {
                Method method = Skill.class.getDeclaredMethod("install", new Class[0]);
                boolean isAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    method.invoke((Object)this.eventBusCapacity, new Object[0]);
                    for (Skill s : this.skills) {
                        method.invoke((Object)s, new Object[0]);
                    }
                }
                finally {
                    method.setAccessible(isAccessible);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Initialize init = new Initialize();
            init.parameters = initializationParameters;
            this.eventBusCapacity.selfEvent((Event)init);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void agentDestroy(Agent agent) {
            SpawnService service = (SpawnService)this.spawnService.get();
            assert (service != null);
            service.removeSpawnServiceListener(this.agentID, this);
            Destroy destroy = new Destroy();
            this.eventBusCapacity.selfEvent((Event)destroy);
            try {
                Method method = Skill.class.getDeclaredMethod("uninstall", new Class[0]);
                boolean isAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    for (int i = this.skills.length - 1; i >= 0; --i) {
                        method.invoke((Object)this.skills[i], new Object[0]);
                    }
                    method.invoke((Object)this.eventBusCapacity, new Object[0]);
                }
                finally {
                    method.setAccessible(isAccessible);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

