/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import io.janusproject.services.executor.ExecutorService;
import io.janusproject.services.executor.JanusScheduledFutureTask;
import io.janusproject.services.logging.LogService;
import io.sarl.core.AgentTask;
import io.sarl.core.Schedules;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Skill;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.arakhne.afc.vmutil.locale.Locale;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

class SchedulesSkill
extends Skill
implements Schedules {
    @Inject
    private ExecutorService executorService;
    @Inject
    private LogService logger;
    private final Map<String, AgentTask> tasks = new HashMap<String, AgentTask>();
    private final Map<String, ScheduledFuture<?>> futures = new HashMap();

    SchedulesSkill(Agent agent) {
        super(agent);
    }

    protected String attributesToString() {
        return super.attributesToString() + ", tasks = " + this.tasks;
    }

    private synchronized void finishTask(String name) {
        this.tasks.remove(name);
        this.futures.remove(name);
    }

    synchronized Collection<String> getActiveTasks() {
        return new ArrayList<String>(this.tasks.keySet());
    }

    synchronized Collection<ScheduledFuture<?>> getActiveFutures() {
        return new ArrayList(this.futures.values());
    }

    protected synchronized void uninstall() {
        for (Map.Entry<String, ScheduledFuture<?>> futureDescription : this.futures.entrySet()) {
            ScheduledFuture<?> future = futureDescription.getValue();
            if (future instanceof JanusScheduledFutureTask && ((JanusScheduledFutureTask)future).isCurrentThread()) {
                this.logger.fineInfo(SchedulesSkill.class, "SKIP_CANCELED_TASK_ON_CURRENT_THREAD", futureDescription.getKey(), future);
                continue;
            }
            future.cancel(true);
            this.logger.fineInfo(SchedulesSkill.class, "CANCELED_TASK", futureDescription.getKey(), future);
        }
        this.futures.clear();
        this.tasks.clear();
    }

    public AgentTask in(long delay, Procedures.Procedure1<? super Agent> procedure) {
        return this.in(this.task("task-" + UUID.randomUUID()), delay, procedure);
    }

    public synchronized AgentTask in(AgentTask task, long delay, Procedures.Procedure1<? super Agent> procedure) {
        task.setProcedure(procedure);
        ScheduledFuture<?> sf = this.executorService.schedule(new AgentRunnableTask(task, false), delay, TimeUnit.MILLISECONDS);
        this.futures.put(task.getName(), sf);
        return task;
    }

    public synchronized AgentTask task(String name) {
        if (this.tasks.containsKey(name)) {
            return this.tasks.get(name);
        }
        AgentTask t = new AgentTask();
        t.setName(name);
        t.setGuard((Functions.Function1)new Functions.Function1<Agent, Boolean>(){

            public Boolean apply(Agent arg0) {
                return Boolean.TRUE;
            }
        });
        this.tasks.put(name, t);
        return t;
    }

    public final boolean cancel(AgentTask task) {
        return this.cancel(task, true);
    }

    public synchronized boolean cancel(AgentTask task, boolean mayInterruptIfRunning) {
        String name;
        ScheduledFuture<?> future;
        if (task != null && (future = this.futures.get(name = task.getName())) != null && !future.isDone() && !future.isCancelled() && future.cancel(mayInterruptIfRunning)) {
            this.finishTask(name);
        }
        return false;
    }

    public AgentTask every(long period, Procedures.Procedure1<? super Agent> procedure) {
        return this.every(this.task("task-" + UUID.randomUUID()), period, procedure);
    }

    public synchronized AgentTask every(AgentTask task, long period, Procedures.Procedure1<? super Agent> procedure) {
        task.setProcedure(procedure);
        ScheduledFuture<?> sf = this.executorService.scheduleAtFixedRate(new AgentRunnableTask(task, true), 0L, period, TimeUnit.MILLISECONDS);
        this.futures.put(task.getName(), sf);
        return task;
    }

    private class AgentRunnableTask
    implements Runnable {
        private WeakReference<AgentTask> agentTaskRef;
        private final boolean isPeriodic;

        AgentRunnableTask(AgentTask task, boolean isPeriodic) {
            this.agentTaskRef = new WeakReference<AgentTask>(task);
            this.isPeriodic = isPeriodic;
        }

        @Override
        public void run() {
            AgentTask task = (AgentTask)this.agentTaskRef.get();
            if (task == null) {
                throw new RuntimeException(Locale.getString(SchedulesSkill.class, (String)"NULL_AGENT_TASK", (Object[])new Object[0]));
            }
            try {
                Agent owner = SchedulesSkill.this.getOwner();
                if (((Boolean)task.getGuard().apply((Object)owner)).booleanValue()) {
                    task.getProcedure().apply((Object)owner);
                }
            }
            finally {
                if (!this.isPeriodic) {
                    SchedulesSkill.this.finishTask(task.getName());
                }
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)((AgentTask)this.agentTaskRef.get()).getName()).add("agent", (Object)SchedulesSkill.this.getOwner().getID()).toString();
        }
    }
}

