/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.janusproject.services.logging.LogService;
import io.janusproject.util.LoggerCreator;
import io.sarl.core.Logging;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Skill;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arakhne.afc.vmutil.locale.Locale;

class LoggingSkill
extends Skill
implements Logging {
    @Inject
    private LogService logService;
    private Logger logger;

    LoggingSkill(Agent agent) {
        super(agent);
    }

    public Logger getLogger() {
        return this.logger;
    }

    void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void install() {
        UUID agentId = this.getOwner().getID();
        String loggerName = Locale.getString(LoggingSkill.class, (String)"AGENT_NAME", (Object[])new Object[]{agentId});
        this.logger = LoggerCreator.createLogger(loggerName, this.logService.getLogger());
    }

    public void setLoggingName(String name) {
        String loggingName = name;
        if (loggingName == null || loggingName.isEmpty()) {
            loggingName = Locale.getString(LoggingSkill.class, (String)"AGENT_NAME", (Object[])new Object[]{this.getOwner().getID()});
        }
        Level level = this.logger.getLevel();
        this.logger = LoggerCreator.createLogger(loggingName, this.logService.getLogger());
        this.logger.setLevel(level);
    }

    public void println(Object message) {
        this.info(message);
    }

    public void error(Object message, Throwable exception) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String loggableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            if (exception != null) {
                this.logger.log(Level.SEVERE, loggableMessage, exception);
            } else {
                this.logger.log(Level.SEVERE, loggableMessage);
            }
        }
    }

    public void error(Object message) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            String loggeableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            this.logger.log(Level.SEVERE, loggeableMessage);
        }
    }

    public void warning(Object message, Throwable exception) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String loggeableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            if (exception != null) {
                this.logger.log(Level.WARNING, loggeableMessage, exception);
            } else {
                this.logger.log(Level.WARNING, loggeableMessage);
            }
        }
    }

    public void warning(Object message) {
        if (this.logger.isLoggable(Level.WARNING)) {
            String loggeableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            this.logger.log(Level.WARNING, loggeableMessage);
        }
    }

    public void info(Object message) {
        if (this.logger.isLoggable(Level.INFO)) {
            String loggeableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            this.logger.log(Level.INFO, loggeableMessage);
        }
    }

    public void debug(Object message) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            String loggeableMessage = Strings.nullToEmpty((String)(message == null ? null : message.toString()));
            this.logger.log(Level.CONFIG, loggeableMessage);
        }
    }

    public boolean isErrorLogEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isWarningLogEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isInfoLogEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isDebugLogEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    public int getLogLevel() {
        return LoggerCreator.toInt(this.logger.getLevel());
    }

    public void setLogLevel(int level) {
        this.logger.setLevel(LoggerCreator.fromInt(level));
    }
}

