/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.executor.ChuckNorrisException;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Skill;
import java.util.UUID;

class LifecycleSkill
extends Skill
implements Lifecycle {
    @Inject
    private SpawnService spawnService;

    LifecycleSkill(Agent agent) {
        super(agent);
    }

    public UUID spawnInContext(Class<? extends Agent> agentType, AgentContext context, Object ... params) {
        return this.spawnService.spawn(context, null, agentType, params);
    }

    public UUID spawnInContextWithID(Class<? extends Agent> agentClass, UUID agentID, AgentContext context, Object ... params) {
        return this.spawnService.spawn(context, agentID, agentClass, params);
    }

    public void killMe() {
        InternalEventBusCapacity busCapacity = (InternalEventBusCapacity)this.getSkill(InternalEventBusCapacity.class);
        busCapacity.selfEvent(new AsynchronousAgentKillingEvent());
        throw new ChuckNorrisException();
    }

    public static class AgentKillException
    extends RuntimeException {
        private static final long serialVersionUID = 3186824315988212481L;

        AgentKillException(SpawnService.AgentKillException exception) {
            super(exception.getMessage(), exception);
        }

        public UUID getAgent() {
            return ((SpawnService.AgentKillException)this.getCause()).getAgent();
        }
    }
}

