/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Queues;
import com.google.common.eventbus.AsyncSyncEventBus;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.AsynchronousAgentKillingEvent;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.logging.LogService;
import io.janusproject.services.spawn.SpawnService;
import io.sarl.core.AgentSpawned;
import io.sarl.core.Destroy;
import io.sarl.core.Initialize;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Skill;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

class InternalEventBusSkill
extends Skill
implements InternalEventBusCapacity {
    private final AtomicReference<InternalEventBusCapacity.OwnerState> state = new AtomicReference<InternalEventBusCapacity.OwnerState>(InternalEventBusCapacity.OwnerState.NEW);
    private final AgentEventListener agentAsEventListener = new AgentEventListener();
    @Inject
    private AsyncSyncEventBus eventBus;
    @Inject
    private LogService logger;
    @Inject
    private SpawnService spawnService;
    private final Address agentAddressInInnerDefaultSpace;
    private List<Object> eventListeners;

    InternalEventBusSkill(Agent agent, Address addressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = addressInInnerDefaultSpace;
    }

    protected String attributesToString() {
        return super.attributesToString() + ", state = " + this.state + ", addressInDefaultspace = " + this.agentAddressInInnerDefaultSpace;
    }

    @Override
    public InternalEventBusCapacity.OwnerState getOwnerState() {
        return this.state.get();
    }

    @Override
    public synchronized Address getInnerDefaultSpaceAddress() {
        return this.agentAddressInInnerDefaultSpace;
    }

    protected synchronized void install() {
        this.eventBus.register((Object)this.getOwner());
    }

    protected synchronized void uninstall() {
        this.eventBus.unregister((Object)this.getOwner());
        List<Object> list = this.eventListeners;
        this.eventListeners = null;
        if (list != null) {
            for (Object o : list) {
                this.eventBus.unregister(o);
            }
        }
    }

    @Override
    public synchronized void registerEventListener(Object listener) {
        this.eventBus.register(listener);
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<Object>();
        }
        this.eventListeners.add(listener);
    }

    @Override
    public synchronized void unregisterEventListener(Object listener) {
        this.eventBus.unregister(listener);
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
            if (this.eventListeners.isEmpty()) {
                this.eventListeners = null;
            }
        }
    }

    @Override
    public synchronized void selfEvent(Event event) {
        event.setSource(this.getInnerDefaultSpaceAddress());
        if (event instanceof Initialize) {
            this.eventBus.fire((Object)event);
            this.state.set(InternalEventBusCapacity.OwnerState.RUNNING);
        } else if (event instanceof Destroy) {
            this.state.set(InternalEventBusCapacity.OwnerState.DESTROYED);
            this.eventBus.fire((Object)event);
        } else if (event instanceof AsynchronousAgentKillingEvent) {
            this.agentAsEventListener.killOrMarkAsKilled();
        } else {
            this.agentAsEventListener.receiveEvent(event);
        }
        this.logger.debug("SELF_EVENT", event);
    }

    @Override
    public final EventListener asEventListener() {
        return this.agentAsEventListener;
    }

    private class AgentEventListener
    implements EventListener {
        private Queue<Event> buffer = Queues.newConcurrentLinkedQueue();
        private final UUID aid;
        private boolean isKilled;

        AgentEventListener() {
            this.aid = InternalEventBusSkill.this.getOwner().getID();
        }

        public UUID getID() {
            return this.aid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveEvent(Event event) {
            assert (!(event instanceof Initialize || event instanceof Destroy || event instanceof AsynchronousAgentKillingEvent)) : "Unsupported type of event: " + event;
            InternalEventBusSkill internalEventBusSkill = InternalEventBusSkill.this;
            synchronized (internalEventBusSkill) {
                if (event instanceof AgentSpawned && this.aid.equals(((AgentSpawned)event).agentID)) {
                    this.fireEnqueuedEvents(InternalEventBusSkill.this);
                    if (this.isKilled) {
                        this.killOwner(InternalEventBusSkill.this);
                        return;
                    }
                }
                switch ((InternalEventBusCapacity.OwnerState)((Object)InternalEventBusSkill.this.state.get())) {
                    case NEW: {
                        this.buffer.add(event);
                        break;
                    }
                    case RUNNING: {
                        this.fireEnqueuedEvents(InternalEventBusSkill.this);
                        InternalEventBusSkill.this.eventBus.post((Object)event);
                        break;
                    }
                    case DESTROYED: {
                        InternalEventBusSkill.this.logger.debug(InternalEventBusSkill.class, "EVENT_DROP_WARNING", event);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        private void fireEnqueuedEvents(InternalEventBusSkill skill) {
            Queue<Event> queue = this.buffer;
            if (queue != null && !queue.isEmpty()) {
                this.buffer = null;
                for (Event evt : queue) {
                    skill.eventBus.post((Object)evt);
                }
            }
        }

        private void killOwner(InternalEventBusSkill skill) {
            try {
                skill.spawnService.killAgent(this.aid);
            }
            catch (SpawnService.AgentKillException e) {
                skill.logger.error(InternalEventBusSkill.class, "CANNOT_KILL_AGENT", this.aid, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void killOrMarkAsKilled() {
            InternalEventBusSkill internalEventBusSkill = InternalEventBusSkill.this;
            synchronized (internalEventBusSkill) {
                this.isKilled = true;
                if (InternalEventBusSkill.this.state.get() != InternalEventBusCapacity.OwnerState.NEW) {
                    this.killOwner(InternalEventBusSkill.this);
                }
            }
        }
    }
}

