/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.inject.Inject;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.InnerContextAccess;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventListener;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedSet;
import io.sarl.util.Collections3;
import io.sarl.util.OpenEventSpace;
import java.util.HashSet;
import java.util.UUID;

class InnerContextSkill
extends Skill
implements InnerContextAccess {
    private final Address agentAddressInInnerDefaultSpace;
    private AgentContext innerContext;
    @Inject
    private ContextSpaceService contextService;

    InnerContextSkill(Agent agent, Address agentAddressInInnerDefaultSpace) {
        super(agent);
        this.agentAddressInInnerDefaultSpace = agentAddressInInnerDefaultSpace;
    }

    synchronized boolean hasInnerContext() {
        return this.innerContext != null;
    }

    synchronized void resetInnerContext() {
        this.innerContext = null;
    }

    protected String attributesToString() {
        return super.attributesToString() + ", addressInDefaultspace = " + this.agentAddressInInnerDefaultSpace;
    }

    protected void uninstall() {
        AgentContext context = this.innerContext;
        this.innerContext = null;
        if (context != null) {
            EventListener listener = ((InternalEventBusCapacity)this.getSkill(InternalEventBusCapacity.class)).asEventListener();
            ((OpenEventSpace)context.getDefaultSpace()).unregister(listener);
            this.contextService.removeContext(context);
        }
    }

    public synchronized AgentContext getInnerContext() {
        if (this.innerContext == null) {
            this.innerContext = this.contextService.createContext(this.agentAddressInInnerDefaultSpace.getSpaceId().getContextID(), this.agentAddressInInnerDefaultSpace.getSpaceId().getID());
            EventListener listener = ((InternalEventBusCapacity)this.getSkill(InternalEventBusCapacity.class)).asEventListener();
            OpenEventSpace defSpace = (OpenEventSpace)this.innerContext.getDefaultSpace();
            defSpace.register(listener);
        }
        return this.innerContext;
    }

    public synchronized boolean hasMemberAgent() {
        if (this.innerContext != null) {
            SynchronizedSet participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            return participants.size() > 1 || participants.size() == 1 && !participants.contains(this.getOwner().getID());
        }
        return false;
    }

    public synchronized int getMemberAgentCount() {
        if (this.innerContext != null) {
            SynchronizedSet participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            int count = participants.size();
            if (participants.contains((Object)this.getOwner().getID())) {
                --count;
            }
            return count;
        }
        return 0;
    }

    public synchronized SynchronizedSet<UUID> getMemberAgents() {
        if (this.innerContext != null) {
            SynchronizedSet participants = this.innerContext.getDefaultSpace().getParticipants();
            assert (participants != null);
            HashSet<UUID> members = new HashSet<UUID>();
            UUID myId = this.getOwner().getID();
            for (UUID id : participants) {
                if (id.equals(myId)) continue;
                members.add(id);
            }
            return Collections3.synchronizedSet(members, members);
        }
        return Collections3.emptySynchronizedSet();
    }

    public boolean isInnerDefaultSpace(Space space) {
        return this.isInnerDefaultSpace(space.getID());
    }

    public boolean isInnerDefaultSpace(SpaceID spaceID) {
        return spaceID.equals((Object)this.innerContext.getDefaultSpace().getID());
    }

    public boolean isInnerDefaultSpace(UUID spaceID) {
        return spaceID.equals(this.innerContext.getDefaultSpace().getID().getID());
    }

    public boolean isInInnerDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isInnerDefaultSpace(adr.getSpaceId());
        }
        return false;
    }
}

