/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.janusproject.kernel.bic.InternalEventBusCapacity;
import io.janusproject.services.contextspace.ContextSpaceService;
import io.sarl.core.Behaviors;
import io.sarl.core.ContextJoined;
import io.sarl.core.ContextLeft;
import io.sarl.core.ExternalContextAccess;
import io.sarl.core.MemberJoined;
import io.sarl.core.MemberLeft;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.lang.util.SynchronizedCollection;
import io.sarl.util.Collections3;
import io.sarl.util.OpenEventSpace;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.arakhne.afc.vmutil.locale.Locale;

class ExternalContextAccessSkill
extends Skill
implements ExternalContextAccess {
    private final Set<UUID> contexts = Sets.newConcurrentHashSet();
    @Inject
    private ContextSpaceService contextRepository;

    ExternalContextAccessSkill(Agent agent) {
        super(agent);
    }

    protected String attributesToString() {
        return super.attributesToString() + ", contexts = " + this.contextRepository.toString();
    }

    protected void install() {
        AgentContext ac = this.contextRepository.getContext(this.getOwner().getParentID());
        this.join(ac.getID(), ac.getDefaultSpace().getID().getID());
    }

    protected void uninstall() {
        for (UUID contextID : this.contexts) {
            this.leave(contextID);
        }
    }

    public SynchronizedCollection<AgentContext> getAllContexts() {
        return Collections3.synchronizedCollection(Collections.unmodifiableCollection(this.contextRepository.getContexts(this.contexts)), (Object)this.contextRepository.mutex());
    }

    public AgentContext getContext(UUID contextID) {
        assert (contextID != null);
        if (!this.contexts.contains(contextID)) {
            throw new IllegalArgumentException(Locale.getString((String)"UNKNOWN_CONTEXT_ID", (Object[])new Object[]{contextID}));
        }
        return this.contextRepository.getContext(contextID);
    }

    public void join(UUID futureContext, UUID futureContextDefaultSpaceID) {
        assert (futureContext != null);
        assert (futureContextDefaultSpaceID != null);
        if (this.contexts.contains(futureContext)) {
            return;
        }
        AgentContext ac = this.contextRepository.getContext(futureContext);
        assert (ac != null) : "Unknown Context";
        if (!futureContextDefaultSpaceID.equals(ac.getDefaultSpace().getID().getID())) {
            throw new IllegalArgumentException(Locale.getString((String)"INVALID_DEFAULT_SPACE_MATCHING", (Object[])new Object[]{futureContextDefaultSpaceID}));
        }
        this.contexts.add(futureContext);
        ((OpenEventSpace)ac.getDefaultSpace()).register(((InternalEventBusCapacity)this.getSkill(InternalEventBusCapacity.class)).asEventListener());
        this.fireContextJoined(futureContext, futureContextDefaultSpaceID);
        this.fireMemberJoined(ac);
    }

    protected void fireContextJoined(UUID futureContext, UUID futureContextDefaultSpaceID) {
        ((Behaviors)this.getSkill(Behaviors.class)).wake((Event)new ContextJoined(futureContext, futureContextDefaultSpaceID));
    }

    protected void fireMemberJoined(AgentContext newJoinedContext) {
        EventSpace defSpace = newJoinedContext.getDefaultSpace();
        defSpace.emit((Event)new MemberJoined(defSpace.getAddress(this.getOwner().getID()), newJoinedContext.getID(), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    public void leave(UUID contextID) {
        assert (contextID != null);
        AgentContext ac = this.contextRepository.getContext(contextID);
        assert (ac != null) : "Unknown Context";
        if (!this.contexts.contains(contextID)) {
            return;
        }
        this.fireContextLeft(contextID);
        this.fireMemberLeft(ac);
        ((OpenEventSpace)ac.getDefaultSpace()).unregister(((InternalEventBusCapacity)this.getSkill(InternalEventBusCapacity.class)).asEventListener());
        this.contexts.remove(contextID);
    }

    protected void fireContextLeft(UUID contextID) {
        ((Behaviors)this.getSkill(Behaviors.class)).wake((Event)new ContextLeft(contextID));
    }

    protected void fireMemberLeft(AgentContext leftContext) {
        EventSpace defSpace = leftContext.getDefaultSpace();
        defSpace.emit((Event)new MemberLeft(defSpace.getAddress(this.getOwner().getID()), this.getOwner().getID(), this.getOwner().getClass().getName()));
    }

    public boolean isInSpace(Event event, Space space) {
        return this.isInSpace(event, space.getID());
    }

    public boolean isInSpace(Event event, SpaceID spaceID) {
        return spaceID.equals((Object)event.getSource().getSpaceId());
    }

    public boolean isInSpace(Event event, UUID spaceID) {
        return spaceID.equals(event.getSource().getSpaceId().getID());
    }
}

