/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject.kernel.bic;

import io.sarl.core.DefaultContextInteractions;
import io.sarl.core.Lifecycle;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.EventSpace;
import io.sarl.lang.core.Scope;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.Space;
import io.sarl.lang.core.SpaceID;
import io.sarl.util.Scopes;
import java.util.UUID;

class DefaultContextInteractionsSkill
extends Skill
implements DefaultContextInteractions {
    private AgentContext parentContext;
    private EventSpace defaultSpace;
    private Address addressInParentDefaultSpace;

    DefaultContextInteractionsSkill(Agent agent, AgentContext parentContext) {
        super(agent);
        this.parentContext = parentContext;
    }

    protected String attributesToString() {
        return super.attributesToString() + ", parentContext = " + this.parentContext + ", defaultSpace = " + this.defaultSpace + ", addressInDefaultspace = " + this.addressInParentDefaultSpace;
    }

    protected void install() {
        this.defaultSpace = this.parentContext.getDefaultSpace();
    }

    public void emit(Event event) {
        event.setSource(this.getDefaultAddress());
        this.defaultSpace.emit(event);
    }

    public void emit(Event event, Scope<Address> scope) {
        event.setSource(this.getDefaultAddress());
        this.defaultSpace.emit(event, scope);
    }

    public Address getDefaultAddress() {
        Address adr = this.addressInParentDefaultSpace;
        if (adr == null) {
            adr = this.defaultSpace.getAddress(this.getOwner().getID());
            assert (adr != null) : "The agent has no address in the default space";
            this.addressInParentDefaultSpace = adr;
        }
        return adr;
    }

    public AgentContext getDefaultContext() {
        return this.parentContext;
    }

    public EventSpace getDefaultSpace() {
        return this.defaultSpace;
    }

    public void receive(UUID receiverID, Event event) {
        Address recAddr = this.defaultSpace.getAddress(receiverID);
        this.emit(event, (Scope<Address>)Scopes.addresses((Address[])new Address[]{recAddr}));
    }

    public UUID spawn(Class<? extends Agent> agentType, Object ... params) {
        return ((Lifecycle)this.getSkill(Lifecycle.class)).spawnInContext(agentType, this.parentContext, params);
    }

    public boolean isDefaultSpace(Space space) {
        return this.isDefaultSpace(space.getID());
    }

    public boolean isDefaultSpace(SpaceID space) {
        return this.isDefaultSpace(space.getID());
    }

    public boolean isDefaultSpace(UUID space) {
        return space.equals(this.defaultSpace.getID().getID());
    }

    public boolean isInDefaultSpace(Event event) {
        Address adr;
        if (event != null && (adr = event.getSource()) != null) {
            return this.isDefaultSpace(adr.getSpaceId());
        }
        return false;
    }

    public boolean isDefaultContext(AgentContext context) {
        return this.isDefaultContext(context.getID());
    }

    public boolean isDefaultContext(UUID contextID) {
        return contextID.equals(this.defaultSpace.getID().getContextID());
    }
}

