/*
 * Decompiled with CFR 0.152.
 */
package io.janusproject;

import com.google.common.base.Strings;
import com.google.inject.Module;
import io.janusproject.JanusConfig;
import io.janusproject.kernel.Kernel;
import io.janusproject.services.network.NetworkConfig;
import io.janusproject.util.LoggerCreator;
import io.sarl.lang.core.Agent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.arakhne.afc.vmutil.locale.Locale;

public final class Boot {
    private static final int ERROR_EXIT_CODE = 255;
    private static PrintStream consoleLogger;
    private static Exiter applicationExiter;

    private Boot() {
    }

    public static String[] parseCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(Boot.getOptions(), args);
            if (cmd.getArgs().length == 0) {
                Boot.showHelp();
                return null;
            }
            boolean noLogo = false;
            int verbose = LoggerCreator.toInt("info");
            for (Option opt : cmd) {
                switch (opt.getLongOpt()) {
                    case "help": {
                        Boot.showHelp();
                        return null;
                    }
                    case "showdefaults": {
                        Boot.showDefaults();
                        return null;
                    }
                    case "cli": {
                        Boot.showCommandLineArguments(args);
                        return null;
                    }
                    case "file": {
                        File file;
                        String rawFilename = opt.getValue();
                        if (rawFilename == null || "".equals(rawFilename)) {
                            Boot.showHelp();
                        }
                        if (!(file = new File(rawFilename)).canRead()) {
                            Boot.showError(Locale.getString((String)"INVALID_PROPERTY_FILENAME", (Object[])new Object[]{rawFilename}), null);
                            return null;
                        }
                        Boot.setPropertiesFrom(file);
                        break;
                    }
                    case "offline": {
                        Boot.setOffline(true);
                        break;
                    }
                    case "randomid": {
                        Boot.setRandomContextUUID();
                        break;
                    }
                    case "bootid": {
                        Boot.setBootAgentTypeContextUUID();
                        break;
                    }
                    case "worldid": {
                        Boot.setDefaultContextUUID();
                        break;
                    }
                    case "define": {
                        String name = opt.getValue(0);
                        if (Strings.isNullOrEmpty((String)name)) break;
                        Boot.setProperty(name, Strings.emptyToNull((String)opt.getValue(1)));
                        break;
                    }
                    case "log": {
                        verbose = Math.max(LoggerCreator.toInt(opt.getValue()), 0);
                        break;
                    }
                    case "quiet": {
                        if (verbose <= 0) break;
                        --verbose;
                        break;
                    }
                    case "verbose": {
                        ++verbose;
                        break;
                    }
                    case "nologo": {
                        noLogo = true;
                        break;
                    }
                }
            }
            Boot.setVerboseLevel(verbose);
            if (noLogo || verbose == 0) {
                Boot.setProperty("janus.logo.show", Boolean.FALSE.toString());
            }
            return cmd.getArgs();
        }
        catch (IOException | ParseException e) {
            Boot.showError(e.getLocalizedMessage(), e);
            return null;
        }
    }

    private static Class<? extends Agent> loadAgentClass(String fullyQualifiedName) {
        Class<?> type;
        try {
            type = Class.forName(fullyQualifiedName);
        }
        catch (Exception e) {
            Boot.showError(Locale.getString((String)"INVALID_AGENT_QUALIFIED_NAME", (Object[])new Object[]{fullyQualifiedName, System.getProperty("java.class.path")}), e);
            return null;
        }
        if (Agent.class.isAssignableFrom(type)) {
            return type.asSubclass(Agent.class);
        }
        Boot.showError(Locale.getString((String)"INVALID_AGENT_TYPE", (Object[])new Object[]{fullyQualifiedName}), null);
        return null;
    }

    public static void main(String[] args) {
        try {
            String[] freeArgs = Boot.parseCommandLine(args);
            if (JanusConfig.getSystemPropertyAsBoolean("janus.logo.show", JanusConfig.JANUS_LOGO_SHOW)) {
                Boot.showJanusLogo();
            }
            if (freeArgs.length == 0) {
                Boot.showError(Locale.getString((String)"NO_AGENT_QUALIFIED_NAME", (Object[])new Object[0]), null);
                return;
            }
            String agentToLaunch = freeArgs[0].toString();
            freeArgs = Arrays.copyOfRange(freeArgs, 1, freeArgs.length, String[].class);
            Class<? extends Agent> agent = Boot.loadAgentClass(agentToLaunch);
            assert (agent != null);
            Boot.startJanus((Class<? extends Module>)null, agent, (Object[])freeArgs);
        }
        catch (Exception e) {
            Boot.showError(Locale.getString((String)"LAUNCHING_ERROR", (Object[])new Object[]{e.getLocalizedMessage()}), e);
            return;
        }
    }

    public static PrintStream getConsoleLogger() {
        return consoleLogger == null ? System.err : consoleLogger;
    }

    public static void setConsoleLogger(PrintStream stream) {
        consoleLogger = stream;
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption("B", "bootid", false, Locale.getString((String)"CLI_HELP_B", (Object[])new Object[]{"janus.context.id.boot", "janus.context.id.random"}));
        options.addOption("f", "file", true, Locale.getString((String)"CLI_HELP_F", (Object[])new Object[0]));
        options.addOption("h", "help", false, Locale.getString((String)"CLI_HELP_H", (Object[])new Object[0]));
        options.addOption(null, "nologo", false, Locale.getString((String)"CLI_HELP_NOLOGO", (Object[])new Object[0]));
        options.addOption("o", "offline", false, Locale.getString((String)"CLI_HELP_O", (Object[])new Object[]{"janus.network.offline"}));
        options.addOption("q", "quiet", false, Locale.getString((String)"CLI_HELP_Q", (Object[])new Object[0]));
        options.addOption("R", "randomid", false, Locale.getString((String)"CLI_HELP_R", (Object[])new Object[]{"janus.context.id.boot", "janus.context.id.random"}));
        options.addOption("s", "showdefaults", false, Locale.getString((String)"CLI_HELP_S", (Object[])new Object[0]));
        options.addOption(null, "cli", false, Locale.getString((String)"CLI_HELP_CLI", (Object[])new Object[0]));
        options.addOption("v", "verbose", false, Locale.getString((String)"CLI_HELP_V", (Object[])new Object[0]));
        options.addOption("W", "worldid", false, Locale.getString((String)"CLI_HELP_W", (Object[])new Object[]{"janus.context.id.boot", "janus.context.id.random"}));
        StringBuilder b = new StringBuilder();
        int level = 0;
        for (String logLevel : LoggerCreator.getLevelStrings()) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(logLevel);
            b.append(" (");
            b.append(level);
            b.append(")");
            ++level;
        }
        Option opt = new Option("l", "log", true, Locale.getString((String)"CLI_HELP_L", (Object[])new Object[]{"info", b}));
        opt.setArgs(1);
        options.addOption(opt);
        opt = new Option("D", "define", true, Locale.getString((String)"CLI_HELP_D", (Object[])new Object[0]));
        opt.setArgs(2);
        opt.setValueSeparator('=');
        opt.setArgName(Locale.getString((String)"CLI_HELP_D_ARGNAME", (Object[])new Object[0]));
        options.addOption(opt);
        return options;
    }

    protected static void showError(String message, Throwable exception) {
        try (PrintWriter logger = new PrintWriter(Boot.getConsoleLogger());){
            if (message != null && !message.isEmpty()) {
                logger.println(message);
            }
            if (exception != null) {
                exception.printStackTrace(logger);
            }
            logger.flush();
            Boot.showHelp(logger);
        }
    }

    public static void showHelp() {
        Boot.showHelp(new PrintWriter(Boot.getConsoleLogger()));
    }

    private static void showHelp(PrintWriter logger) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(logger, 74, Boot.class.getName() + " " + Locale.getString(Boot.class, (String)"CLI_PARAM_SYNOPTIC", (Object[])new Object[0]), "", Boot.getOptions(), 1, 3, "");
        Boot.getExiter().exit();
    }

    public static void showDefaults() {
        Properties defaultValues = new Properties();
        JanusConfig.getDefaultValues(defaultValues);
        NetworkConfig.getDefaultValues(defaultValues);
        try (PrintStream os = Boot.getConsoleLogger();){
            defaultValues.storeToXML(os, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Boot.getExiter().exit();
    }

    public static void showCommandLineArguments(String[] args) {
        try (PrintStream os = Boot.getConsoleLogger();){
            for (int i = 0; i < args.length; ++i) {
                os.println(i + ": " + args[i]);
            }
            os.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Boot.getExiter().exit();
    }

    public static void showJanusLogo() {
        System.out.println(Locale.getString((String)"JANUS_TEXT_LOGO", (Object[])new Object[0]));
    }

    public static void setOffline(boolean isOffline) {
        System.setProperty("janus.network.offline", Boolean.toString(isOffline));
    }

    public static void setRandomContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.FALSE.toString());
        System.setProperty("janus.context.id.random", Boolean.TRUE.toString());
    }

    public static void setBootAgentTypeContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.TRUE.toString());
        System.setProperty("janus.context.id.random", Boolean.FALSE.toString());
    }

    public static void setDefaultContextUUID() {
        System.setProperty("janus.context.id.boot", Boolean.FALSE.toString());
        System.setProperty("janus.context.id.random", Boolean.FALSE.toString());
    }

    public static void setVerboseLevel(int level) {
        System.setProperty("janus.verbose.level", Integer.toString(level));
    }

    public static void setProperty(String name, String value) {
        if (name != null && !name.isEmpty()) {
            if (value == null || value.isEmpty()) {
                System.getProperties().remove(name);
            } else {
                System.setProperty(name, value);
            }
        }
    }

    public static void setPropertiesFrom(URL propertyFile) throws IOException {
        Properties systemProperties = System.getProperties();
        try (InputStream stream = propertyFile.openStream();){
            systemProperties.load(stream);
        }
    }

    public static void setPropertiesFrom(File propertyFile) throws IOException {
        Properties systemProperties = System.getProperties();
        try (FileInputStream stream = new FileInputStream(propertyFile);){
            systemProperties.load(stream);
        }
    }

    public static UUID getBootAgentIdentifier() {
        String id = JanusConfig.getSystemProperty("janus.boot.agent.id");
        if (id != null && !id.isEmpty()) {
            try {
                return UUID.fromString(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Kernel startJanus(Class<? extends Module> platformModule, Class<? extends Agent> agentCls, Object ... params) throws Exception {
        Class<? extends Module> startupModule = platformModule;
        if (startupModule == null) {
            startupModule = JanusConfig.getSystemPropertyAsClass(Module.class, "janus.injection.module", JanusConfig.INJECTION_MODULE_NAME_VALUE);
        }
        assert (startupModule != null) : "No platform injection module";
        return Boot.startJanus(startupModule.newInstance(), agentCls, params);
    }

    public static Kernel startJanus(Module startupModule, Class<? extends Agent> agentCls, Object ... params) throws Exception {
        UUID id;
        System.setProperty("janus.boot.agent", agentCls.getName());
        assert (startupModule != null) : "No platform injection module";
        Kernel k = Kernel.create(startupModule);
        Logger logger = k.getLogger();
        if (logger != null) {
            logger.info(Locale.getString((String)"LAUNCHING_AGENT", (Object[])new Object[]{agentCls.getName()}));
        }
        if ((id = k.spawn(agentCls, params)) != null) {
            System.setProperty("janus.boot.agent.id", id.toString());
        } else {
            System.getProperties().remove("janus.boot.agent.id");
        }
        return k;
    }

    public static Exiter getExiter() {
        return applicationExiter == null ? new StandardExiter() : applicationExiter;
    }

    public static void setExiter(Exiter exiter) {
        applicationExiter = exiter;
    }

    private static class StandardExiter
    implements Exiter {
        StandardExiter() {
        }

        @Override
        public void exit() {
            System.exit(255);
        }
    }

    public static interface Exiter {
        public void exit();
    }
}

