/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.Config;
import zmq.Ctx;
import zmq.Signaler;
import zmq.pipe.YPipe;
import zmq.util.Errno;

public final class Mailbox
implements Closeable {
    private final YPipe<Command> cpipe;
    private final Signaler signaler;
    private final Lock sync;
    private boolean active;
    private final String name;
    private final Errno errno;

    public Mailbox(Ctx ctx, String name, int tid) {
        this.errno = ctx.errno();
        this.cpipe = new YPipe(Config.COMMAND_PIPE_GRANULARITY.getValue());
        this.sync = new ReentrantLock();
        this.signaler = new Signaler(ctx, tid, this.errno);
        Command cmd = this.cpipe.read();
        assert (cmd == null);
        this.active = false;
        this.name = name;
    }

    public SelectableChannel getFd() {
        return this.signaler.getFd();
    }

    void send(Command cmd) {
        boolean ok = false;
        this.sync.lock();
        try {
            this.cpipe.write(cmd, false);
            ok = this.cpipe.flush();
        }
        finally {
            this.sync.unlock();
        }
        if (!ok) {
            this.signaler.send();
        }
    }

    public Command recv(long timeout) {
        boolean rc;
        Command cmd;
        if (this.active) {
            cmd = this.cpipe.read();
            if (cmd != null) {
                return cmd;
            }
            this.active = false;
        }
        if (!(rc = this.signaler.waitEvent(timeout))) {
            assert (this.errno.get() == 35 || this.errno.get() == 4) : this.errno.get();
            return null;
        }
        this.signaler.recv();
        this.active = true;
        cmd = this.cpipe.read();
        assert (cmd != null) : "command shall never be null when read";
        return cmd;
    }

    @Override
    public void close() throws IOException {
        this.sync.lock();
        this.sync.unlock();
        this.signaler.close();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

