/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class UniqueClassNameValidator
extends AbstractDeclarativeValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    @Inject
    private IJvmModelAssociations associations;

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    @Inject
    protected void register(EValidatorRegistrar registrar, IGrammarAccess grammarAccess) {
        AbstractRule entryRule = IterableExtensions.head(grammarAccess.getGrammar().getRules());
        if (entryRule instanceof ParserRule) {
            registrar.register(((ParserRule)entryRule).getType().getClassifier().getEPackage(), this);
        }
    }

    @Check
    public void checkUniqueName(EObject root) {
        Resource resource;
        EObject _head;
        boolean _equals;
        boolean _tripleEquals;
        EObject _eContainer = root.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals && (_equals = Objects.equal(_head = IterableExtensions.head((resource = root.eResource()).getContents()), root))) {
            Consumer<JvmDeclaredType> _function = it -> this.doCheckUniqueName((JvmDeclaredType)it);
            Iterables.filter(resource.getContents(), JvmDeclaredType.class).forEach(_function);
        }
    }

    protected void doCheckUniqueName(JvmDeclaredType type) {
        QualifiedName name;
        boolean _tripleEquals;
        EObject _eContainer = type.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals && (name = this.qualifiedNameProvider.getFullyQualifiedName(type)) != null) {
            this.doCheckUniqueName(name, type);
        }
    }

    protected boolean doCheckUniqueName(QualifiedName name, JvmDeclaredType type) {
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(type.eResource());
        Iterable<IEObjectDescription> others = index.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, name, false);
        return this.checkUniqueInIndex(type, others);
    }

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        boolean _greaterThan_1;
        boolean _greaterThan;
        Functions.Function1<IEObjectDescription, URI> _function = it -> it.getEObjectURI().trimFragment();
        Set<URI> resourceURIs = IterableExtensions.toSet(IterableExtensions.map(descriptions, _function));
        int _size = resourceURIs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Functions.Function1<URI, Boolean> _function_1 = it -> {
                URI _uRI = type.eResource().getURI();
                return !Objects.equal(it, _uRI);
            };
            this.addIssue(type, IterableExtensions.head(IterableExtensions.filter(resourceURIs, _function_1)).lastSegment());
            return false;
        }
        int _size_1 = IterableExtensions.size(descriptions);
        boolean bl2 = _greaterThan_1 = _size_1 > 1;
        if (_greaterThan_1) {
            this.addIssue(type);
            return false;
        }
        return true;
    }

    protected void addIssue(JvmDeclaredType type) {
        this.addIssue(type, null);
    }

    protected void addIssue(JvmDeclaredType type, String fileName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The type ");
        String _simpleName = type.getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" is already defined");
        if (fileName != null) {
            _builder.append(" in ");
            _builder.append(fileName);
        }
        _builder.append(".");
        String message = _builder.toString();
        EObject sourceElement = this.associations.getPrimarySourceElement(type);
        if (sourceElement == null) {
            this.addIssue(message, type, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type");
        } else {
            EStructuralFeature feature = sourceElement.eClass().getEStructuralFeature("name");
            this.addIssue(message, sourceElement, feature, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type", new String[0]);
        }
    }
}

