/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.XtypeReferenceVisitorWithParameter;

@Singleton
public class ProxyAwareUIStrings
implements XtypeReferenceVisitorWithParameter<StringBuilder, StringBuilder> {
    @Override
    public StringBuilder visit(JvmTypeReference reference, StringBuilder param) {
        if (reference == null) {
            return null;
        }
        return reference.accept(this, param);
    }

    public StringBuilder appendTypeSignature(JvmType type, StringBuilder result) {
        EList<JvmTypeParameter> typeParameters;
        result.append(type.getSimpleName());
        if (type instanceof JvmTypeParameterDeclarator && !(typeParameters = ((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters()).isEmpty()) {
            result.append("<");
            int size = typeParameters.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(((JvmTypeParameter)typeParameters.get(i)).getName());
            }
            result.append(">");
        }
        return result;
    }

    public StringBuilder appendTypeArguments(JvmParameterizedTypeReference typeRef, StringBuilder result) {
        EList<JvmTypeReference> typeArguments = typeRef.getArguments();
        if (typeArguments.isEmpty()) {
            throw new IllegalArgumentException("typeRef is not parameterized");
        }
        result.append("<");
        int size = typeArguments.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            if ((result = this.visit((JvmTypeReference)typeArguments.get(i), result)) != null) continue;
            return null;
        }
        result.append(">");
        return result;
    }

    @Override
    public StringBuilder doVisitAnyTypeReference(JvmAnyTypeReference reference, StringBuilder param) {
        return this.doVisitTypeReference((JvmTypeReference)reference, param);
    }

    @Override
    public StringBuilder doVisitDelegateTypeReference(JvmDelegateTypeReference reference, StringBuilder param) {
        return this.visit(reference.getDelegate(), param);
    }

    @Override
    public StringBuilder doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, StringBuilder param) {
        param = this.visit(reference.getComponentType(), param);
        if (param != null) {
            param.append("[]");
        }
        return param;
    }

    @Override
    public StringBuilder doVisitCompoundTypeReference(JvmCompoundTypeReference reference, StringBuilder param) {
        throw new IllegalStateException("Should never be called");
    }

    protected StringBuilder doVisitCompoundTypeReference(JvmCompoundTypeReference reference, StringBuilder param, String delim) {
        EList<JvmTypeReference> references = reference.getReferences();
        for (int i = 0; i < references.size(); ++i) {
            if (i != 0) {
                param.append(delim);
            }
            if ((param = this.visit((JvmTypeReference)references.get(i), param)) != null) continue;
            return null;
        }
        return param;
    }

    @Override
    public StringBuilder doVisitMultiTypeReference(JvmMultiTypeReference reference, StringBuilder param) {
        return this.doVisitCompoundTypeReference(reference, param, " & ");
    }

    @Override
    public StringBuilder doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, StringBuilder param) {
        JvmType type = reference.getType();
        if (type == null || type.eIsProxy()) {
            return null;
        }
        param.append(type.getSimpleName());
        EList<JvmTypeReference> typeArguments = reference.getArguments();
        if (typeArguments.isEmpty()) {
            return param;
        }
        param.append("<");
        int size = typeArguments.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                param.append(", ");
            }
            if ((param = this.visit((JvmTypeReference)typeArguments.get(i), param)) != null) continue;
            return null;
        }
        param.append(">");
        return param;
    }

    @Override
    public StringBuilder doVisitInnerTypeReference(JvmInnerTypeReference reference, StringBuilder param) {
        JvmType type = reference.getType();
        if (type == null || type.eIsProxy()) {
            return null;
        }
        param = reference.getOuter().accept(this, param);
        if (param == null) {
            return null;
        }
        param.append(".");
        return this.doVisitParameterizedTypeReference((JvmParameterizedTypeReference)reference, param);
    }

    @Override
    public StringBuilder doVisitSpecializedTypeReference(JvmSpecializedTypeReference reference, StringBuilder param) {
        return this.visit(reference.getEquivalent(), param);
    }

    @Override
    public StringBuilder doVisitSynonymTypeReference(JvmSynonymTypeReference reference, StringBuilder param) {
        return this.doVisitCompoundTypeReference(reference, param, " | ");
    }

    @Override
    public StringBuilder doVisitUnknownTypeReference(JvmUnknownTypeReference reference, StringBuilder param) {
        return this.doVisitTypeReference((JvmTypeReference)reference, param);
    }

    @Override
    public StringBuilder doVisitWildcardTypeReference(JvmWildcardTypeReference reference, StringBuilder param) {
        param.append("? ");
        EList<JvmTypeConstraint> constraints = reference.getConstraints();
        int size = constraints.size();
        for (int i = 0; i < size; ++i) {
            JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
            if (constraint.eClass() != TypesPackage.Literals.JVM_LOWER_BOUND) continue;
            param.append("super ");
            return this.visit(constraint.getTypeReference(), param);
        }
        boolean first = true;
        for (int i = 0; i < size; ++i) {
            JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
            if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND) continue;
            if (first) {
                param.append("extends ");
            } else {
                param.append(" & ");
            }
            param = this.visit(constraint.getTypeReference(), param);
            if (param != null) continue;
            return null;
        }
        return param;
    }

    @Override
    public StringBuilder doVisitComputedTypeReference(XComputedTypeReference reference, StringBuilder param) {
        return this.doVisitSpecializedTypeReference((JvmSpecializedTypeReference)reference, param);
    }

    @Override
    public StringBuilder doVisitFunctionTypeReference(XFunctionTypeRef reference, StringBuilder param) {
        param.append("(");
        EList<JvmTypeReference> paramTypes = reference.getParamTypes();
        int size = paramTypes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                param.append(", ");
            }
            if ((param = this.visit((JvmTypeReference)paramTypes.get(i), param)) != null) continue;
            return null;
        }
        param.append(")=>");
        return this.visit(reference.getReturnType(), param);
    }

    @Override
    public StringBuilder doVisitTypeReference(JvmTypeReference reference, StringBuilder param) {
        param.append(reference.getSimpleName());
        return param;
    }
}

