/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.xbase.typesystem.internal.util.WrapperTypeLookup;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypes;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeKind;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithParameterAndResult;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.RecursionGuard;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

public class ParameterizedTypeReference
extends LightweightTypeReference {
    private List<LightweightTypeReference> typeArguments;
    private JvmType type;
    protected boolean resolved;

    public ParameterizedTypeReference(ITypeReferenceOwner owner, JvmType type) {
        super(owner);
        EObject container;
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (type instanceof JvmArrayType) {
            throw new IllegalArgumentException("type may not be an array type");
        }
        if (type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && (container = type.eContainer()) instanceof JvmDeclaredType) {
            this.checkStaticFlag((JvmDeclaredType)type);
        }
        this.type = type;
        this.resolved = !(type instanceof JvmTypeParameter);
    }

    protected void checkStaticFlag(JvmDeclaredType type) {
        if (!type.isStatic()) {
            throw new IllegalArgumentException("type may not be an inner class");
        }
    }

    @Override
    public int getKind() {
        return 5;
    }

    @Override
    public JvmTypeReference toTypeReference() {
        JvmParameterizedTypeReference result = this.getTypesFactory().createJvmParameterizedTypeReference();
        result.setType(this.type);
        if (this.typeArguments != null) {
            for (LightweightTypeReference typeArgument : this.typeArguments) {
                result.getArguments().add(typeArgument.toTypeReference());
            }
        }
        return result;
    }

    @Override
    public LightweightTypeReference getRawTypeReference() {
        if (this.typeArguments == null && this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return this;
        }
        if (this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return this.getOwner().newParameterizedTypeReference(this.type);
        }
        return super.getRawTypeReference();
    }

    @Override
    public LightweightTypeReference getConstraintSubstitute() {
        if (this.type.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            List<LightweightTypeReference> superTypes = this.getSuperTypes();
            if (superTypes.size() == 1) {
                return superTypes.get(0).getConstraintSubstitute();
            }
            CompoundTypeReference compoundTypeReference = this.getOwner().newCompoundTypeReference(false);
            for (LightweightTypeReference superType : superTypes) {
                compoundTypeReference.addComponent(superType.getConstraintSubstitute());
            }
            return compoundTypeReference;
        }
        return this;
    }

    @Override
    public List<JvmType> getRawTypes() {
        if (this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            return Collections.singletonList(this.type);
        }
        return super.getRawTypes();
    }

    protected boolean isTypeVisible(IVisibilityHelper visibilityHelper) {
        return !(this.type instanceof JvmDeclaredType) || visibilityHelper.isVisible((JvmDeclaredType)this.type);
    }

    @Override
    public boolean isVisible(IVisibilityHelper visibilityHelper) {
        if (this.isTypeVisible(visibilityHelper)) {
            if (this.typeArguments != null) {
                for (LightweightTypeReference typeArgument : this.typeArguments) {
                    if (typeArgument.isVisible(visibilityHelper)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public JvmTypeReference toJavaCompliantTypeReference(IVisibilityHelper visibilityHelper) {
        if (this.isTypeVisible(visibilityHelper)) {
            JvmParameterizedTypeReference result = this.getTypesFactory().createJvmParameterizedTypeReference();
            result.setType(this.type);
            if (this.typeArguments != null) {
                for (LightweightTypeReference typeArgument : this.typeArguments) {
                    result.getArguments().add(typeArgument.toJavaCompliantTypeReference());
                }
            }
            return result;
        }
        return this.toJavaCompliantTypeReference(this.getSuperTypes(), visibilityHelper);
    }

    @Override
    public JvmType getType() {
        return this.type;
    }

    @Override
    public boolean isRawType() {
        EClass typeClass = this.type.eClass();
        if (typeClass == TypesPackage.Literals.JVM_GENERIC_TYPE && this.typeArguments == null) {
            return ((InternalEObject)((Object)this.type)).eIsSet(13);
        }
        if (typeClass == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)this.type;
            return this.isRawType(typeParameter, new RecursionGuard<JvmTypeParameter>());
        }
        return false;
    }

    private boolean isRawType(JvmTypeParameter current, RecursionGuard<JvmTypeParameter> guard) {
        if (guard.tryNext(current)) {
            EList<JvmTypeConstraint> constraints = current.getConstraints();
            int size = constraints.size();
            for (int i = 0; i < size; ++i) {
                JvmParameterizedTypeReference casted;
                JvmTypeReference superType;
                JvmType rawSuperType;
                JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
                if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || constraint.getTypeReference() == null || (rawSuperType = (superType = constraint.getTypeReference()).getType()) == null) continue;
                if (rawSuperType.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER && this.isRawType((JvmTypeParameter)rawSuperType, guard)) {
                    return true;
                }
                if (rawSuperType.eClass() != TypesPackage.Literals.JVM_GENERIC_TYPE || ((JvmGenericType)rawSuperType).getTypeParameters().isEmpty() || superType.eClass() != TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE || !(casted = (JvmParameterizedTypeReference)superType).getArguments().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        if (super.isOwnedBy(owner)) {
            if (this.typeArguments != null) {
                for (LightweightTypeReference typeArgument : this.typeArguments) {
                    if (typeArgument.isOwnedBy(owner)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public LightweightTypeReference getWrapperTypeIfPrimitive() {
        Primitives.Primitive primitiveKind = this.getPrimitiveKind();
        if (primitiveKind == null) {
            return this;
        }
        LightweightTypeReference result = WrapperTypeLookup.getWrapperType(this, primitiveKind);
        if (result == null) {
            return this;
        }
        return result;
    }

    @Override
    public LightweightTypeReference getPrimitiveIfWrapperType() {
        Primitives.Primitive primitive = this.getPrimitiveKindIfWrapperType();
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return this.findPrimitive("boolean");
                }
                case Byte: {
                    return this.findPrimitive("byte");
                }
                case Char: {
                    return this.findPrimitive("char");
                }
                case Double: {
                    return this.findPrimitive("double");
                }
                case Float: {
                    return this.findPrimitive("float");
                }
                case Int: {
                    return this.findPrimitive("int");
                }
                case Long: {
                    return this.findPrimitive("long");
                }
                case Short: {
                    return this.findPrimitive("short");
                }
                case Void: {
                    return this.findPrimitive("void");
                }
            }
            throw new IllegalStateException("Unknown primitive kind " + (Object)((Object)primitive));
        }
        return this;
    }

    private LightweightTypeReference findPrimitive(String primitive) {
        JvmType result = (JvmType)this.getOwner().getContextResourceSet().getEObject(URIHelperConstants.PRIMITIVES_URI.appendFragment(primitive), true);
        if (result != null) {
            return this.getOwner().newParameterizedTypeReference(result);
        }
        throw new IllegalStateException("Cannot find primitive type: " + primitive);
    }

    @Override
    public boolean isAnonymous() {
        return this.type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)this.type).isAnonymous();
    }

    @Override
    public boolean isPrimitive() {
        return this.type.eClass() == TypesPackage.Literals.JVM_PRIMITIVE_TYPE;
    }

    @Override
    public Primitives.Primitive getPrimitiveKind() {
        if (this.type.eIsProxy()) {
            return null;
        }
        if (this.type.eClass() == TypesPackage.Literals.JVM_PRIMITIVE_TYPE) {
            String name = this.type.getSimpleName();
            switch (name.length()) {
                case 3: {
                    if (!"int".equals(name)) break;
                    return Primitives.Primitive.Int;
                }
                case 4: {
                    if ("long".equals(name)) {
                        return Primitives.Primitive.Long;
                    }
                    if ("char".equals(name)) {
                        return Primitives.Primitive.Char;
                    }
                    if (!"byte".equals(name)) break;
                    return Primitives.Primitive.Byte;
                }
                case 5: {
                    if ("short".equals(name)) {
                        return Primitives.Primitive.Short;
                    }
                    if (!"float".equals(name)) break;
                    return Primitives.Primitive.Float;
                }
                case 6: {
                    if (!"double".equals(name)) break;
                    return Primitives.Primitive.Double;
                }
                case 7: {
                    if (!"boolean".equals(name)) break;
                    return Primitives.Primitive.Boolean;
                }
            }
        } else if (this.type.eClass() == TypesPackage.Literals.JVM_VOID) {
            return Primitives.Primitive.Void;
        }
        return null;
    }

    @Override
    public Primitives.Primitive getPrimitiveKindIfWrapperType() {
        if (this.type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            JvmGenericType casted = (JvmGenericType)this.type;
            return this.getPrimitiveKind(casted);
        }
        if (this.type.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)this.type;
            return this.getPrimitiveKind(typeParameter, null);
        }
        return null;
    }

    private Primitives.Primitive getPrimitiveKind(JvmTypeParameter type, RecursionGuard<JvmTypeParameter> guard) {
        if (type.eIsProxy()) {
            return null;
        }
        for (JvmTypeConstraint constraint : type.getConstraints()) {
            JvmTypeReference upperBound;
            if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || (upperBound = constraint.getTypeReference()) == null) continue;
            JvmType upperBoundType = upperBound.getType();
            if (upperBoundType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                return this.getPrimitiveKind((JvmGenericType)upperBoundType);
            }
            if (type == upperBoundType) {
                return null;
            }
            if (upperBoundType.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) continue;
            JvmTypeParameter upperBoundTypeParameter = (JvmTypeParameter)upperBoundType;
            if (guard == null) {
                guard = new RecursionGuard();
                guard.tryNext(type);
            }
            if (guard.tryNext(upperBoundTypeParameter)) {
                return this.getPrimitiveKind(upperBoundTypeParameter, guard);
            }
            return null;
        }
        return null;
    }

    private Primitives.Primitive getPrimitiveKind(JvmGenericType type) {
        if (type.eIsProxy()) {
            return null;
        }
        String name = type.getIdentifier();
        switch (name.length()) {
            case 17: {
                if ("java.lang.Integer".equals(name)) {
                    return Primitives.Primitive.Int;
                }
                if (!"java.lang.Boolean".equals(name)) break;
                return Primitives.Primitive.Boolean;
            }
            case 14: {
                if ("java.lang.Long".equals(name)) {
                    return Primitives.Primitive.Long;
                }
                if ("java.lang.Byte".equals(name)) {
                    return Primitives.Primitive.Byte;
                }
                if (!"java.lang.Void".equals(name)) break;
                return Primitives.Primitive.Void;
            }
            case 15: {
                if ("java.lang.Short".equals(name)) {
                    return Primitives.Primitive.Short;
                }
                if (!"java.lang.Float".equals(name)) break;
                return Primitives.Primitive.Float;
            }
            case 16: {
                if (!"java.lang.Double".equals(name)) break;
                return Primitives.Primitive.Double;
            }
            case 19: {
                if (!"java.lang.Character".equals(name)) break;
                return Primitives.Primitive.Char;
            }
        }
        return null;
    }

    @Override
    public boolean isPrimitiveVoid() {
        return this.type.eClass() == TypesPackage.Literals.JVM_VOID && !this.type.eIsProxy();
    }

    @Override
    public boolean isInterfaceType() {
        return this.type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)this.type).isInterface();
    }

    @Override
    public boolean isWrapper() {
        if (this.type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
            JvmGenericType casted = (JvmGenericType)this.type;
            return this.isWrapper(casted);
        }
        if (this.type.eClass() == TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            JvmTypeParameter typeParameter = (JvmTypeParameter)this.type;
            return this.isWrapper(typeParameter, null);
        }
        return false;
    }

    private boolean isWrapper(JvmTypeParameter typeParameter, RecursionGuard<JvmTypeParameter> stack) {
        for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
            JvmTypeReference upperBound;
            if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || (upperBound = constraint.getTypeReference()) == null) continue;
            JvmType upperBoundType = upperBound.getType();
            if (upperBoundType == null) {
                return false;
            }
            if (upperBoundType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE) {
                return this.isWrapper((JvmGenericType)upperBoundType);
            }
            if (upperBoundType.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) continue;
            if (typeParameter == upperBoundType || stack != null && !stack.tryNext((JvmTypeParameter)upperBoundType)) {
                return false;
            }
            if (stack == null) {
                stack = new RecursionGuard();
                stack.tryNext(typeParameter);
                stack.tryNext((JvmTypeParameter)upperBoundType);
            }
            return this.isWrapper((JvmTypeParameter)upperBoundType, stack);
        }
        return false;
    }

    private boolean isWrapper(JvmGenericType type) {
        return this.getPrimitiveKind(type) != null;
    }

    @Override
    protected List<LightweightTypeReference> getSuperTypes(TypeParameterSubstitutor<?> substitutor) {
        EList<JvmTypeConstraint> constraints;
        if (this.type instanceof JvmDeclaredType) {
            EList<JvmTypeReference> superTypes = ((JvmDeclaredType)this.type).getSuperTypes();
            if (!superTypes.isEmpty()) {
                ITypeReferenceOwner owner = this.getOwner();
                ArrayList<LightweightTypeReference> result = Lists.newArrayListWithCapacity(superTypes.size());
                boolean isRawType = this.isRawType();
                for (JvmTypeReference superType : superTypes) {
                    LightweightTypeReference topLevelType;
                    LightweightTypeReference lightweightSuperType = owner.toLightweightTypeReference(superType);
                    if (lightweightSuperType.isType(Object.class) && superTypes.size() != 1) continue;
                    if (!lightweightSuperType.isUnknown()) {
                        if (!isRawType) {
                            result.add(substitutor.substitute(lightweightSuperType));
                            continue;
                        }
                        result.add(substitutor.substitute(lightweightSuperType).getRawTypeReference());
                        continue;
                    }
                    if (superTypes.size() != 1 || (topLevelType = this.internalFindTopLevelType(Object.class)) == null) continue;
                    result.add(topLevelType);
                }
                return result;
            }
        } else if (this.type instanceof JvmTypeParameter && !(constraints = ((JvmTypeParameter)this.type).getConstraints()).isEmpty()) {
            ITypeReferenceOwner owner = this.getOwner();
            ArrayList<LightweightTypeReference> result = Lists.newArrayListWithCapacity(constraints.size());
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmUpperBound) || constraint.getTypeReference() == null) continue;
                LightweightTypeReference upperBound = owner.toLightweightTypeReference(constraint.getTypeReference());
                result.add(substitutor.substitute(upperBound));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public LightweightTypeReference getSuperType(Class<?> rawType) {
        if (this.isType(rawType)) {
            return this;
        }
        if (this.isPrimitive() || this.isPrimitiveVoid() || rawType.isPrimitive() || rawType.isArray()) {
            return null;
        }
        if (this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER && Modifier.isFinal(rawType.getModifiers())) {
            return null;
        }
        if (Object.class.equals(rawType)) {
            try {
                ResourceSet resourceSet = this.getOwner().getContextResourceSet();
                Resource typeResource = resourceSet.getResource(URIHelperConstants.OBJECTS_URI.appendSegment(rawType.getName()), true);
                JvmType type = (JvmType)typeResource.getContents().get(0);
                if (type == null) {
                    return null;
                }
                return this.getOwner().newParameterizedTypeReference(type);
            }
            catch (WrappedException e) {
                return null;
            }
        }
        boolean interfaceType = Modifier.isInterface(rawType.getModifiers());
        if (this.isInterfaceType() && !interfaceType) {
            return null;
        }
        String typeName = rawType.getName();
        return this.getSuperTypeByName(typeName, interfaceType);
    }

    private LightweightTypeReference getSuperTypeByName(String typeName, boolean interfaceType) {
        JvmTypeReference superType = this.getSuperTypeByName(typeName, interfaceType, this.type, new RecursionGuard<JvmType>());
        if (superType != null) {
            JvmType rawType = superType.getType();
            if (this.isRawType()) {
                return this.createRawTypeReference(rawType);
            }
            if (superType.eClass() == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE && ((JvmParameterizedTypeReference)superType).getArguments().isEmpty()) {
                return this.getOwner().newParameterizedTypeReference(rawType);
            }
            LightweightTypeReference unresolved = this.getOwner().toLightweightTypeReference(rawType);
            TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
            LightweightTypeReference result = substitutor.substitute(unresolved);
            return result;
        }
        return null;
    }

    private JvmTypeReference getSuperTypeByName(String typeName, boolean interfaceType, JvmType thisType, RecursionGuard<JvmType> guard) {
        block8: {
            block7: {
                EClass thisTypeEClass = thisType.eClass();
                if (!interfaceType && thisTypeEClass == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)thisType).isInterface()) {
                    return null;
                }
                if (thisTypeEClass == TypesPackage.Literals.JVM_VOID || thisTypeEClass == TypesPackage.Literals.JVM_PRIMITIVE_TYPE) {
                    return null;
                }
                if (typeName.equals(thisType.getIdentifier()) || !guard.tryNext(thisType)) {
                    return null;
                }
                if (thisTypeEClass == TypesPackage.Literals.JVM_TYPE_PARAMETER) break block7;
                if (thisTypeEClass == TypesPackage.Literals.JVM_ARRAY_TYPE) break block8;
                EList<JvmTypeReference> superTypes = ((JvmDeclaredType)thisType).getSuperTypes();
                int size = superTypes.size();
                for (int i = 0; i < size; ++i) {
                    JvmTypeReference superType = (JvmTypeReference)superTypes.get(i);
                    JvmType rawSuperType = superType.getType();
                    if (rawSuperType == null) continue;
                    if (typeName.equals(rawSuperType.getIdentifier())) {
                        return superType;
                    }
                    JvmTypeReference result = this.getSuperTypeByName(typeName, interfaceType, rawSuperType, guard);
                    if (result == null) continue;
                    return result;
                }
                break block8;
            }
            EList<JvmTypeConstraint> constraints = ((JvmTypeParameter)thisType).getConstraints();
            int size = constraints.size();
            for (int i = 0; i < size; ++i) {
                JvmTypeReference superType;
                JvmType rawSuperType;
                JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
                if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || constraint.getTypeReference() == null || (rawSuperType = (superType = constraint.getTypeReference()).getType()) == null) continue;
                if (rawSuperType.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER && typeName.equals(rawSuperType.getIdentifier())) {
                    return superType;
                }
                JvmTypeReference result = this.getSuperTypeByName(typeName, interfaceType, rawSuperType, guard);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public LightweightTypeReference getSuperType(JvmType rawType) {
        Object rawResult = this.internalGetSuperType(rawType);
        if (rawResult instanceof ParameterizedTypeReference) {
            return (LightweightTypeReference)rawResult;
        }
        if (rawResult != null) {
            JvmTypeReference superType = (JvmTypeReference)rawResult;
            if (this.isRawType()) {
                return this.createRawTypeReference(rawType);
            }
            if (superType.eClass() == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE && ((JvmParameterizedTypeReference)superType).getArguments().isEmpty()) {
                return this.getOwner().newParameterizedTypeReference(rawType);
            }
            LightweightTypeReference unresolved = this.getOwner().toLightweightTypeReference(rawType);
            TypeParameterSubstitutor<?> substitutor = this.createSubstitutor();
            LightweightTypeReference result = substitutor.substitute(unresolved);
            return result;
        }
        return null;
    }

    public LightweightTypeReference getRawSuperType(JvmType rawType) {
        Object result = this.internalGetSuperType(rawType);
        if (result instanceof ParameterizedTypeReference) {
            return (LightweightTypeReference)result;
        }
        if (result != null) {
            return this.createRawTypeReference(rawType);
        }
        return null;
    }

    protected LightweightTypeReference createRawTypeReference(JvmType rawType) {
        return this.getOwner().toPlainTypeReference(rawType);
    }

    protected boolean isInner(JvmType type) {
        if (type.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && type.eContainer() instanceof JvmDeclaredType) {
            return !((JvmGenericType)type).isStatic();
        }
        return false;
    }

    private Object internalGetSuperType(JvmType rawType) {
        if (rawType == this.type) {
            return this;
        }
        if (this.isPrimitive() || this.isPrimitiveVoid()) {
            return null;
        }
        EClass otherEClass = rawType.eClass();
        if (otherEClass == TypesPackage.Literals.JVM_PRIMITIVE_TYPE || otherEClass == TypesPackage.Literals.JVM_VOID) {
            return null;
        }
        boolean interfaceType = false;
        if (otherEClass != TypesPackage.Literals.JVM_TYPE_PARAMETER) {
            if (Object.class.getName().equals(rawType.getIdentifier())) {
                return this.getOwner().newParameterizedTypeReference(rawType);
            }
            if (otherEClass != TypesPackage.Literals.JVM_ARRAY_TYPE) {
                JvmDeclaredType declaredType = (JvmDeclaredType)rawType;
                if (this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER && declaredType.isFinal()) {
                    return null;
                }
            } else if (this.isInterfaceType()) {
                return null;
            }
            if (otherEClass == TypesPackage.Literals.JVM_GENERIC_TYPE && !(interfaceType = ((JvmGenericType)rawType).isInterface()) && this.isInterfaceType()) {
                return null;
            }
        }
        JvmTypeReference superType = this.getSuperType(rawType, interfaceType, this.type, new RecursionGuard<JvmType>());
        return superType;
    }

    private JvmTypeReference getSuperType(JvmType rawType, boolean interfaceType, JvmType thisType, RecursionGuard<JvmType> guard) {
        block8: {
            block9: {
                block7: {
                    if (thisType == rawType || !interfaceType && thisType.eClass() == TypesPackage.Literals.JVM_GENERIC_TYPE && ((JvmGenericType)thisType).isInterface()) {
                        return null;
                    }
                    if (!guard.tryNext(thisType)) {
                        return null;
                    }
                    if (thisType.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER) break block7;
                    EList<JvmTypeConstraint> constraints = ((JvmTypeParameter)thisType).getConstraints();
                    int size = constraints.size();
                    for (int i = 0; i < size; ++i) {
                        JvmType rawSuperType;
                        JvmTypeConstraint constraint = (JvmTypeConstraint)constraints.get(i);
                        JvmTypeReference superType = constraint.getTypeReference();
                        if (constraint.eClass() != TypesPackage.Literals.JVM_UPPER_BOUND || superType == null || (rawSuperType = superType.getType()) == null) continue;
                        if (rawType == rawSuperType) {
                            return superType;
                        }
                        JvmTypeReference result = this.getSuperType(rawType, interfaceType, rawSuperType, guard);
                        if (result == null) continue;
                        return result;
                    }
                    break block8;
                }
                if (thisType.eClass() != TypesPackage.Literals.JVM_ARRAY_TYPE) break block9;
                String identifier = rawType.getIdentifier();
                if (Cloneable.class.getName().equals(identifier) || Serializable.class.getName().equals(identifier) || Object.class.getName().equals(identifier)) {
                    return this.getServices().getTypeReferences().createTypeRef(rawType, new JvmTypeReference[0]);
                }
                break block8;
            }
            if (thisType.eClass() == TypesPackage.Literals.JVM_VOID) break block8;
            EList<JvmTypeReference> superTypes = ((JvmDeclaredType)thisType).getSuperTypes();
            int size = superTypes.size();
            for (int i = 0; i < size; ++i) {
                JvmTypeReference superType = (JvmTypeReference)superTypes.get(i);
                JvmType rawSuperType = superType.getType();
                if (rawSuperType == null) continue;
                if (rawType == rawSuperType) {
                    return superType;
                }
                JvmTypeReference result = this.getSuperType(rawType, interfaceType, rawSuperType, guard);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return this.expose(this.typeArguments);
    }

    @Override
    protected ParameterizedTypeReference doCopyInto(ITypeReferenceOwner owner) {
        ParameterizedTypeReference result = owner.newParameterizedTypeReference(this.type);
        this.copyTypeArguments(result, owner);
        return result;
    }

    protected void copyTypeArguments(ParameterizedTypeReference result, ITypeReferenceOwner owner) {
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            for (LightweightTypeReference typeArgument : this.typeArguments) {
                result.addTypeArgument(typeArgument.copyInto(owner));
            }
        }
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public void addTypeArgument(LightweightTypeReference argument) {
        if (argument == null) {
            throw new NullPointerException("argument may not be null");
        }
        if (!argument.isOwnedBy(this.getOwner())) {
            throw new IllegalArgumentException("argument is not valid in current context");
        }
        if (this.typeArguments == null) {
            this.typeArguments = Lists.newArrayListWithCapacity(2);
        }
        this.typeArguments.add(argument);
        this.resolved = this.resolved && argument.isResolved();
    }

    @Override
    public String getSimpleName() {
        return this.getAsString(this.type.getSimpleName(), LightweightTypeReference.SimpleNameFunction.INSTANCE);
    }

    @Override
    public String getIdentifier() {
        return this.getAsString(this.type.getIdentifier(), LightweightTypeReference.IdentifierFunction.INSTANCE);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.getAsString(this.getUniqueIdentifier(this.type), LightweightTypeReference.UniqueIdentifierFunction.INSTANCE);
    }

    @Override
    public String getJavaIdentifier() {
        return this.getAsString(this.type.getIdentifier(), LightweightTypeReference.JavaIdentifierFunction.INSTANCE);
    }

    protected String getAsString(String type, Function<LightweightTypeReference, String> format) {
        if (this.typeArguments != null) {
            return type + "<" + Joiner.on(", ").join(Iterables.transform(this.typeArguments, format)) + ">";
        }
        return type;
    }

    @Override
    public boolean isType(Class<?> clazz) {
        return this.type.eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER && clazz.getName().equals(this.type.getIdentifier());
    }

    @Override
    public void accept(TypeReferenceVisitor visitor) {
        visitor.doVisitParameterizedTypeReference(this);
    }

    @Override
    public <Param> void accept(TypeReferenceVisitorWithParameter<Param> visitor, Param param) {
        visitor.doVisitParameterizedTypeReference(this, param);
    }

    @Override
    public <Result> Result accept(TypeReferenceVisitorWithResult<Result> visitor) {
        return visitor.doVisitParameterizedTypeReference(this);
    }

    @Override
    public <Param, Result> Result accept(TypeReferenceVisitorWithParameterAndResult<Param, Result> visitor, Param param) {
        return visitor.doVisitParameterizedTypeReference(this, param);
    }

    @Override
    public FunctionTypeKind getFunctionTypeKind() {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.getFunctionTypeKind(this);
    }

    @Override
    public FunctionTypeReference getAsFunctionTypeReference() {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.getAsFunctionTypeReference(this);
    }

    @Override
    public FunctionTypeReference tryConvertToFunctionTypeReference(boolean rawType) {
        FunctionTypes functionTypes = this.getServices().getFunctionTypes();
        return functionTypes.tryConvertToFunctionTypeReference(this, rawType);
    }

    @Override
    public ArrayTypeReference tryConvertToArray() {
        ArrayTypes arrayTypes = this.getServices().getArrayTypes();
        return arrayTypes.tryConvertToArray(this);
    }

    @Override
    public LightweightTypeReference tryConvertToListType() {
        if (this.isAssignableFrom(List.class)) {
            return this;
        }
        return super.tryConvertToListType();
    }

    public ParameterizedTypeReference toInstanceTypeReference() {
        ParameterizedTypeReference result = this.getOwner().newParameterizedTypeReference(this.getType());
        for (LightweightTypeReference typeArgument : this.getTypeArguments()) {
            result.addTypeArgument(typeArgument.getInvariantBoundSubstitute());
        }
        return result;
    }
}

