/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.xtext.xbase.compiler.ISourceAppender;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitor;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

public class LightweightTypeReferenceSerializer
extends TypeReferenceVisitor {
    private ISourceAppender appender;

    public LightweightTypeReferenceSerializer(ISourceAppender appender) {
        this.appender = appender;
    }

    @Override
    protected void doVisitAnyTypeReference(AnyTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitArrayTypeReference(ArrayTypeReference reference) {
        reference.getComponentType().accept(this);
        this.appender.append("[]");
    }

    @Override
    protected void doVisitCompoundTypeReference(CompoundTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitFunctionTypeReference(FunctionTypeReference reference) {
        boolean _isJava = this.appender.isJava();
        if (_isJava) {
            this.doVisitParameterizedTypeReference(reference);
        } else {
            boolean _tripleEquals;
            this.appender.append("(");
            this.appendCommaSeparated(reference.getParameterTypes());
            this.appender.append(")=>");
            LightweightTypeReference _returnType = reference.getReturnType();
            boolean bl = _tripleEquals = _returnType == null;
            if (_tripleEquals) {
                this.appender.append("void");
            } else {
                reference.getReturnType().accept(this);
            }
        }
    }

    @Override
    protected void doVisitInnerFunctionTypeReference(InnerFunctionTypeReference reference) {
        boolean _isJava = this.appender.isJava();
        if (_isJava) {
            boolean _not;
            reference.getOuter().accept(this);
            this.appender.append(".");
            this.appender.append(reference.getType().getSimpleName());
            boolean _isEmpty = reference.getTypeArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.appender.append("<");
                this.appendCommaSeparated(reference.getTypeArguments());
                this.appender.append(">");
            }
        } else {
            boolean _tripleEquals;
            this.appender.append("(");
            this.appendCommaSeparated(reference.getParameterTypes());
            this.appender.append(")=>");
            LightweightTypeReference _returnType = reference.getReturnType();
            boolean bl = _tripleEquals = _returnType == null;
            if (_tripleEquals) {
                this.appender.append("void");
            } else {
                reference.getReturnType().accept(this);
            }
        }
    }

    @Override
    protected void doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
        boolean _isAnonymous = reference.isAnonymous();
        if (_isAnonymous) {
            reference.getNamedType().accept(this);
        } else {
            boolean _not;
            this.appender.append(reference.getType());
            boolean _isEmpty = reference.getTypeArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.appender.append("<");
                this.appendCommaSeparated(reference.getTypeArguments());
                this.appender.append(">");
            }
        }
    }

    @Override
    protected void doVisitInnerTypeReference(InnerTypeReference reference) {
        boolean _not;
        reference.getOuter().accept(this);
        this.appender.append(".");
        this.appender.append(reference.getType().getSimpleName());
        boolean _isEmpty = reference.getTypeArguments().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.appender.append("<");
            this.appendCommaSeparated(reference.getTypeArguments());
            this.appender.append(">");
        }
    }

    @Override
    protected void doVisitUnboundTypeReference(UnboundTypeReference reference) {
        reference.toJavaType().accept(this);
    }

    @Override
    protected void doVisitUnknownTypeReference(UnknownTypeReference reference) {
        this.appender.append(reference.getSimpleName());
    }

    @Override
    protected void doVisitWildcardTypeReference(WildcardTypeReference reference) {
        boolean _tripleNotEquals;
        this.appender.append("?");
        LightweightTypeReference _lowerBound = reference.getLowerBound();
        boolean bl = _tripleNotEquals = _lowerBound != null;
        if (_tripleNotEquals) {
            this.appender.append(" super ");
            reference.getLowerBound().accept(this);
        } else {
            boolean _not;
            Functions.Function1<LightweightTypeReference, Boolean> _function = it -> {
                String _identifier = it.getIdentifier();
                return !Objects.equal("java.lang.Object", _identifier);
            };
            Iterable<LightweightTypeReference> relevantUpperBounds = IterableExtensions.filter(reference.getUpperBounds(), _function);
            boolean _isEmpty = IterableExtensions.isEmpty(relevantUpperBounds);
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                this.appender.append(" extends ");
                boolean isFirst = true;
                for (LightweightTypeReference upperBound : relevantUpperBounds) {
                    if (!isFirst) {
                        this.appender.append(" & ");
                    }
                    isFirst = false;
                    upperBound.accept(this);
                }
            }
        }
    }

    protected void appendCommaSeparated(List<LightweightTypeReference> references) {
        boolean isFirst = true;
        for (LightweightTypeReference reference : references) {
            if (!isFirst) {
                this.appender.append(", ");
            }
            isFirst = false;
            reference.accept(this);
        }
    }
}

