/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem;

import com.google.common.collect.Iterables;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typing.IJvmTypeReferenceProvider;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public abstract class LocalVariableCapturer
implements IJvmTypeReferenceProvider {
    private boolean captured = true;
    private final JvmTypeReference equivalent;

    protected LocalVariableCapturer(JvmTypeReference equivalent) {
        this.equivalent = equivalent;
    }

    protected static <R extends LocalVariableCapturer> R findLocalClassSupertype(JvmDeclaredType type) {
        JvmTypeReference superType = Iterables.getLast(type.getSuperTypes(), null);
        if (superType == null) {
            return null;
        }
        return LocalVariableCapturer.findLocalClassSupertype(superType);
    }

    protected static <R extends LocalVariableCapturer> R findLocalClassSupertype(JvmTypeReference typeReference) {
        IJvmTypeReferenceProvider typeProvider;
        if (InferredTypeIndicator.isInferred(typeReference)) {
            JvmTypeReference equivalent = ((XComputedTypeReference)typeReference).getEquivalent();
            return LocalVariableCapturer.findLocalClassSupertype(equivalent);
        }
        if (typeReference instanceof XComputedTypeReference && (typeProvider = ((XComputedTypeReference)typeReference).getTypeProvider()) instanceof LocalVariableCapturer) {
            LocalVariableCapturer result = (LocalVariableCapturer)typeProvider;
            return (R)result;
        }
        return null;
    }

    public static void captureLocalVariables(JvmDeclaredType localType, ITypeComputationState state) {
        LocalVariableCapturer.captureLocalVariables(Iterables.getLast(localType.getSuperTypes()), state);
    }

    public static void captureLocalVariables(JvmTypeReference typeReference, ITypeComputationState state) {
        Object localClassSupertype = LocalVariableCapturer.findLocalClassSupertype(typeReference);
        if (localClassSupertype != null) {
            if (!((LocalVariableCapturer)localClassSupertype).captured) {
                ((LocalVariableCapturer)localClassSupertype).captured = true;
                ((LocalVariableCapturer)localClassSupertype).capture(state);
            }
            return;
        }
        throw new IllegalStateException("Unexpected typeReference: " + typeReference);
    }

    protected void awaitCapturing() {
        this.captured = false;
    }

    protected abstract void capture(ITypeComputationState var1);

    @Override
    public JvmTypeReference getTypeReference(XComputedTypeReferenceImplCustom context) {
        if (!this.captured) {
            throw new IllegalStateException("Not yet captured but navigated: " + this);
        }
        return this.equivalent;
    }

    public JvmTypeReference getEquivalent() {
        return this.equivalent;
    }

    public String toString() {
        return String.format("LocalClassSupertype[captured=%s, equivalent=%s]", this.captured, this.equivalent);
    }
}

