/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.scoping.batch.AbstractFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithNamedStaticTypes;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithStaticTypes;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.ITypeImporter;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

public class TypeImporter
implements ITypeImporter {
    private Map<JvmType, Set<String>> namedStaticImports = Maps.newHashMap();
    private Map<JvmType, Set<String>> namedStaticExtensionImports = Maps.newHashMap();
    private Map<JvmType, Set<String>> bogusNamedStaticExtensionImports = Maps.newHashMap();
    private List<JvmType> staticImports = Lists.newArrayListWithCapacity(3);
    private List<JvmType> staticExtensionImports = Lists.newArrayListWithCapacity(3);
    private List<JvmType> bogusStaticImports = Lists.newArrayListWithCapacity(3);

    protected IFeatureScopeSession process(AbstractFeatureScopeSession parent, ITypeImporter.Client client) {
        client.doAddImports(this);
        AbstractFeatureScopeSession result = parent;
        if (!this.bogusStaticImports.isEmpty()) {
            result = new FeatureScopeSessionWithStaticTypes(result, this.bogusStaticImports, Collections.emptyList(), result.getResolvedFeaturesProvider());
        }
        if (!this.bogusNamedStaticExtensionImports.isEmpty()) {
            result = new FeatureScopeSessionWithNamedStaticTypes(result, this.bogusNamedStaticExtensionImports, Collections.emptyMap(), result.getResolvedFeaturesProvider());
        }
        if (!this.staticImports.isEmpty() || !this.staticExtensionImports.isEmpty()) {
            result = new FeatureScopeSessionWithStaticTypes(result, this.staticImports, this.staticExtensionImports, result.getResolvedFeaturesProvider());
        }
        if (!this.namedStaticImports.isEmpty() || !this.namedStaticExtensionImports.isEmpty()) {
            result = new FeatureScopeSessionWithNamedStaticTypes(result, this.namedStaticImports, this.namedStaticExtensionImports, result.getResolvedFeaturesProvider());
        }
        return result;
    }

    @Override
    public void importStatic(JvmDeclaredType type) {
        this.staticImports.add(type);
    }

    @Override
    public void importStatic(JvmDeclaredType type, String memberName) {
        Maps2.putIntoSetMap(type, memberName, this.namedStaticImports);
    }

    @Override
    public void importStaticExtension(JvmDeclaredType type, boolean strict) {
        this.staticExtensionImports.add(type);
        if (!strict) {
            this.bogusStaticImports.add(type);
        }
    }

    @Override
    public void importStaticExtension(JvmDeclaredType type, String memberName, boolean strict) {
        Maps2.putIntoSetMap(type, memberName, this.namedStaticExtensionImports);
        if (!strict) {
            Maps2.putIntoSetMap(type, memberName, this.bogusNamedStaticExtensionImports);
        }
    }
}

