/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;

public class LocalVariableScope
extends AbstractSessionBasedScope {
    public LocalVariableScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall) {
        super(parent, session, featureCall);
    }

    @Override
    protected List<IEObjectDescription> getAllLocalElements() {
        return this.getSession().getLocalElements();
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription localElement = this.getSession().getLocalElement(name);
        if (localElement != null) {
            return localElement;
        }
        return super.getSingleElement(name);
    }

    @Override
    protected List<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        if (!this.canBeLocalVariable()) {
            return Collections.emptyList();
        }
        IEObjectDescription element = this.getSession().getLocalElement(name);
        if (element == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    protected boolean canBeLocalVariable() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall != null) {
            return this.looksLikeLocalVariable(featureCall) || featureCall instanceof XAssignment;
        }
        return true;
    }

    protected boolean looksLikeLocalVariable(XAbstractFeatureCall featureCall) {
        if (featureCall instanceof XFeatureCall) {
            boolean result = !featureCall.isExplicitOperationCallOrBuilderSyntax() && featureCall.getTypeArguments().isEmpty();
            return result;
        }
        return false;
    }

    protected boolean looksLikeLocalVariable(XAbstractFeatureCall featureCall, List<IEObjectDescription> localElements) {
        return this.looksLikeLocalVariable(featureCall);
    }

    @Override
    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        Iterable localElements = this.getLocalElementsByName(name);
        if (localElements.isEmpty()) {
            return this.getParent().getElements(name);
        }
        if (this.looksLikeLocalVariable(this.getFeatureCall(), (List<IEObjectDescription>)localElements)) {
            return localElements;
        }
        Iterable<IEObjectDescription> parentElements = this.getParentElements(new Provider<Iterable<IEObjectDescription>>(){

            @Override
            public Iterable<IEObjectDescription> get() {
                return LocalVariableScope.this.getParent().getElements(name);
            }
        });
        Iterable<IEObjectDescription> result = Iterables.concat(localElements, parentElements);
        return result;
    }

    @Override
    protected boolean isShadowed(IEObjectDescription fromParent) {
        if (this.getShadowingKey(fromParent).equals(fromParent.getName().toString())) {
            boolean result = this.getSession().getLocalElement(fromParent.getName()) != null;
            return result;
        }
        return false;
    }
}

