/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.jvmmodel.JvmIdentifiableMetaData;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.resource.BatchLinkableResource;

@FinalFieldsConstructor
public class BatchLinkableResourceStorageLoadable
extends ResourceStorageLoadable {
    @Override
    protected void loadEntries(StorageAwareResource resource, ZipInputStream zipIn) throws IOException {
        super.loadEntries(resource, zipIn);
        if (resource instanceof BatchLinkableResource) {
            this.readAssociationsAdapter((BatchLinkableResource)resource, zipIn);
        }
    }

    @Override
    protected Object handleLoadEObject(InternalEObject loaded, BinaryResourceImpl.EObjectInputStream input) throws IOException {
        boolean _xblockexpression = false;
        super.handleLoadEObject(loaded, input);
        boolean _readBoolean = input.readBoolean();
        if (_readBoolean) {
            String doc = input.readString();
            EList<Adapter> _eAdapters = loaded.eAdapters();
            DocumentationAdapter _documentationAdapter = new DocumentationAdapter();
            Procedures.Procedure1<DocumentationAdapter> _function = it -> it.setDocumentation(doc);
            DocumentationAdapter _doubleArrow = ObjectExtensions.operator_doubleArrow(_documentationAdapter, _function);
            _eAdapters.add(_doubleArrow);
        }
        boolean _xifexpression = false;
        boolean _readBoolean_1 = input.readBoolean();
        if (_readBoolean_1) {
            EList<Adapter> _eAdapters_1 = loaded.eAdapters();
            JvmIdentifiableMetaData _jvmIdentifiableMetaData = new JvmIdentifiableMetaData();
            Procedures.Procedure1<JvmIdentifiableMetaData> _function_1 = it -> {
                try {
                    it.setSynthetic(input.readBoolean());
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow(_e);
                }
            };
            JvmIdentifiableMetaData _doubleArrow_1 = ObjectExtensions.operator_doubleArrow(_jvmIdentifiableMetaData, _function_1);
            _xifexpression = _eAdapters_1.add(_doubleArrow_1);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected void readAssociationsAdapter(BatchLinkableResource resource, ZipInputStream stream) throws IOException {
        try {
            JvmModelAssociator.Adapter existing = IterableExtensions.head(Iterables.filter(resource.eAdapters(), JvmModelAssociator.Adapter.class));
            JvmModelAssociator.Adapter _elvis = null;
            if (existing != null) {
                _elvis = existing;
            } else {
                JvmModelAssociator.Adapter _doubleArrow;
                JvmModelAssociator.Adapter _adapter = new JvmModelAssociator.Adapter();
                Procedures.Procedure1<JvmModelAssociator.Adapter> _function = it -> {
                    EList<Adapter> _eAdapters = resource.eAdapters();
                    _eAdapters.add((Adapter)it);
                };
                _elvis = _doubleArrow = ObjectExtensions.operator_doubleArrow(_adapter, _function);
            }
            JvmModelAssociator.Adapter adapter = _elvis;
            stream.getNextEntry();
            BufferedInputStream _bufferedInputStream = new BufferedInputStream(stream);
            ObjectInputStream objIn = new ObjectInputStream(_bufferedInputStream);
            Object _readObject = objIn.readObject();
            Map logicalMap = (Map)_readObject;
            Consumer<Map.Entry> _function_1 = it -> {
                EObject _eObject = resource.getEObject((String)it.getValue());
                adapter.logicalContainerMap.put(resource.getEObject((String)it.getKey()), (JvmIdentifiableElement)_eObject);
            };
            logicalMap.entrySet().forEach(_function_1);
            Object _readObject_1 = objIn.readObject();
            Map sourceToTargetMap = (Map)_readObject_1;
            Consumer<Map.Entry> _function_2 = it -> {
                Functions.Function1<String, EObject> _function_3 = it_1 -> resource.getEObject((String)it_1);
                adapter.sourceToTargetMap.put(resource.getEObject((String)it.getKey()), Sets.newLinkedHashSet(IterableExtensions.map((Iterable)it.getValue(), _function_3)));
            };
            sourceToTargetMap.entrySet().forEach(_function_2);
            Object _readObject_2 = objIn.readObject();
            Map targetToSourceMap = (Map)_readObject_2;
            Consumer<Map.Entry> _function_3 = it -> {
                Functions.Function1<String, EObject> _function_4 = it_1 -> resource.getEObject((String)it_1);
                adapter.targetToSourceMap.put(resource.getEObject((String)it.getKey()), Sets.newLinkedHashSet(IterableExtensions.map((Iterable)it.getValue(), _function_4)));
            };
            targetToSourceMap.entrySet().forEach(_function_3);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    public BatchLinkableResourceStorageLoadable(InputStream arg0, boolean arg1) {
        super(arg0, arg1);
    }
}

